/*
 * Decompiled with CFR 0.152.
 */
package manifold.sql.query.type;

import java.sql.SQLException;
import java.util.List;
import javax.tools.DiagnosticListener;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import manifold.api.fs.IFileFragment;
import manifold.api.gen.AbstractSrcClass;
import manifold.api.gen.AbstractSrcMethod;
import manifold.api.gen.SrcAnnotated;
import manifold.api.gen.SrcAnnotationExpression;
import manifold.api.gen.SrcLinkedClass;
import manifold.api.gen.SrcMethod;
import manifold.api.gen.SrcParameter;
import manifold.api.gen.SrcType;
import manifold.api.host.IModule;
import manifold.internal.javac.HostKind;
import manifold.internal.javac.IIssue;
import manifold.json.rt.api.DataBindings;
import manifold.rt.api.ActualName;
import manifold.rt.api.DisableStringLiteralTemplates;
import manifold.rt.api.FragmentValue;
import manifold.rt.api.util.ManClassUtil;
import manifold.rt.api.util.ManEscapeUtil;
import manifold.sql.api.DataElement;
import manifold.sql.api.Parameter;
import manifold.sql.query.api.Command;
import manifold.sql.query.type.SqlModel;
import manifold.sql.query.type.SqlParentType;
import manifold.sql.rt.api.ColumnInfo;
import manifold.sql.rt.api.DbConfig;
import manifold.sql.rt.api.Executor;
import manifold.sql.rt.api.OperableTxScope;
import manifold.sql.rt.api.SqlCommand;
import manifold.sql.rt.api.TxScope;

class CommandParentType
extends SqlParentType {
    CommandParentType(SqlModel model) {
        super(model);
    }

    @Override
    void render(StringBuilder sb, JavaFileManager.Location location, IModule module, DiagnosticListener<JavaFileObject> errorHandler) {
        String name = this.getCommandName();
        String identifier = SrcLinkedClass.makeIdentifier((String)name, (boolean)false);
        SrcLinkedClass srcClass = (SrcLinkedClass)((SrcLinkedClass)((SrcLinkedClass)new SrcLinkedClass(this.getFqn(), AbstractSrcClass.Kind.Interface, this._model.getFile(), location, module, errorHandler).addAnnotation(new SrcAnnotationExpression(DisableStringLiteralTemplates.class.getSimpleName()))).addInterface(new SrcType("SqlCommand"))).modifiers(1L);
        SrcLinkedClass.addActualNameAnnotation((SrcAnnotated)srcClass, (String)name, (boolean)false);
        this.addImports(srcClass);
        this.addExecuteMethods(srcClass);
        this.addFragmentValueMethod(srcClass);
        srcClass.render(sb, 0);
    }

    private Command getCommand() {
        return (Command)this._model.getSqlStatement();
    }

    private void addFragmentValueMethod(SrcLinkedClass srcClass) {
        if (!(this._model.getFile() instanceof IFileFragment)) {
            return;
        }
        if (!this.isValueFragment(((IFileFragment)this._model.getFile()).getHostKind())) {
            return;
        }
        this.addValueMethodForOperation(srcClass);
    }

    private void addValueMethodForOperation(SrcLinkedClass srcClass) {
        srcClass.addAnnotation(new SrcAnnotationExpression(FragmentValue.class.getSimpleName()).addArgument("methodName", String.class, (Object)"fragmentValue").addArgument("type", String.class, (Object)this.getFqn()));
        String simpleName = srcClass.getSimpleName();
        SrcMethod valueMethod = (SrcMethod)((SrcMethod)((SrcMethod)((SrcMethod)new SrcMethod((AbstractSrcClass)srcClass).modifiers(8L)).name("fragmentValue")).returns(simpleName)).body("return new " + simpleName + "() {};");
        srcClass.addMethod((AbstractSrcMethod)valueMethod);
    }

    private String getCommandName() {
        if (this.getCommand() == null) {
            return ManClassUtil.getShortClassName((String)this.getFqn());
        }
        String name = this.getCommand().getName();
        return name == null || name.isEmpty() ? "Anonymous_" + this._anonCount++ : name;
    }

    private void addExecuteMethods(SrcLinkedClass srcClass) {
        this.addExecuteMethod(srcClass, "execute", Integer.TYPE);
    }

    private void addExecuteMethod(SrcLinkedClass srcClass, String methodName, Class<?> returnType) {
        SrcMethod method = (SrcMethod)((SrcMethod)((SrcMethod)((SrcMethod)((SrcMethod)new SrcMethod((AbstractSrcClass)srcClass).name(methodName)).modifiers(this.isFragment() ? 0x80000000000L : 8L)).addParam("ctx", TxScope.SqlChangeCtx.class.getSimpleName())).throwsList(new Class[]{SQLException.class})).returns(new SrcType(returnType));
        this.addParameters((AbstractSrcMethod)method);
        StringBuilder sb = new StringBuilder();
        sb.append("DataBindings paramBindings = new DataBindings();\n");
        int i = 0;
        for (SrcParameter param : method.getParameters()) {
            if (i++ == 0) continue;
            String paramName = SrcLinkedClass.makeIdentifier((String)param.getSimpleName(), (boolean)false);
            sb.append("    paramBindings.put(\"" + paramName + "\", " + paramName + ");\n");
        }
        String command = this.getCommand() == null ? "<errant sql command>" : this.getCommand().getSqlSource();
        command = ManEscapeUtil.escapeForJavaStringLiteral((String)command);
        String simpleName = srcClass.getSimpleName();
        sb.append("    return new Executor(ctx, " + this.getParameterInfo() + ", paramBindings, \"" + command + "\")." + methodName + "();");
        method.body(sb.toString());
        srcClass.addMethod((AbstractSrcMethod)method);
    }

    private boolean isFragment() {
        return this._model.getFile() instanceof IFileFragment && this.isValueFragment(((IFileFragment)this._model.getFile()).getHostKind());
    }

    private String getParameterInfo() {
        StringBuilder sb = new StringBuilder("new ColumnInfo[]{");
        List<Parameter> parameters = this.getCommand().getParameters();
        for (int i = 0; i < parameters.size(); ++i) {
            Parameter p = parameters.get(i);
            if (i > 0) {
                sb.append(", ");
            }
            sb.append("new ColumnInfo(\"" + p.getName() + "\", " + p.getJdbcType() + ", \"{p.getSqlType()}\", " + p.getSize() + ")");
        }
        return sb.append("}").toString();
    }

    private String getSqlParamTypes() {
        StringBuilder sb = new StringBuilder("new String[]{");
        List<Parameter> parameters = this.getCommand().getParameters();
        for (int i = 0; i < parameters.size(); ++i) {
            Parameter p = parameters.get(i);
            if (i > 0) {
                sb.append(",");
            }
            sb.append("\"").append(p.getSqlType()).append("\"");
        }
        return sb.append("}").toString();
    }

    private boolean isValueFragment(HostKind hostKind) {
        switch (hostKind) {
            case DOUBLE_QUOTE_LITERAL: 
            case TEXT_BLOCK_LITERAL: {
                return true;
            }
        }
        return false;
    }

    private void addParameters(AbstractSrcMethod method) {
        if (this.getCommand() == null) {
            return;
        }
        for (Parameter param : this.getCommand().getParameters()) {
            Class<Object> type = this.getType(param);
            if (type == null) {
                type = Object.class;
            }
            method.addParam(SrcLinkedClass.makeIdentifier((String)param.getName(), (boolean)false), new SrcType(type));
        }
    }

    private Class<?> getType(DataElement elem) {
        Class<?> colType = elem.getType();
        if (colType == null) {
            this._model.addIssue(IIssue.Kind.Error, 0, "parameter type unknown for command '" + this.getCommandName() + "', parameter '" + elem.getName() + "', jdbcType '" + elem.getJdbcType() + "'");
            return null;
        }
        return colType;
    }

    private void addImports(SrcLinkedClass srcClass) {
        srcClass.addImport(SqlCommand.class);
        srcClass.addImport(DataBindings.class);
        srcClass.addImport(ColumnInfo.class);
        srcClass.addImport(Executor.class);
        srcClass.addImport(OperableTxScope.class);
        srcClass.addImport(TxScope.SqlChangeCtx.class);
        srcClass.addImport(ActualName.class);
        srcClass.addImport(DisableStringLiteralTemplates.class);
        srcClass.addImport(FragmentValue.class);
        this.importSchemaType(srcClass);
    }

    private void importSchemaType(SrcLinkedClass srcClass) {
        DbConfig dbconfig = this._model.getScope().getDbconfig();
        srcClass.addImport(dbconfig.getSchemaPackage() + '.' + dbconfig.getName());
    }
}

