/*
 * Decompiled with CFR 0.152.
 */
package manifold.sql.schema.jdbc;

import java.util.List;
import manifold.sql.schema.api.SchemaColumn;
import manifold.sql.schema.api.SchemaForeignKey;
import manifold.sql.schema.api.SchemaTable;

public class JdbcSchemaForeignKey
implements SchemaForeignKey {
    private final String _name;
    private final String _qualifiedName;
    private final String _actualName;
    private final SchemaTable _referencedTable;
    private final List<SchemaColumn> _columns;

    public JdbcSchemaForeignKey(String fkName, SchemaTable referencedTable, List<SchemaColumn> columns) {
        this._referencedTable = referencedTable;
        this._columns = columns;
        this._actualName = fkName;
        String baseName = this.makeFkName(fkName);
        this._name = baseName + "_ref";
        this._qualifiedName = this.makeQualifiedName(baseName);
    }

    private String makeQualifiedName(String baseName) {
        baseName = baseName.equalsIgnoreCase(this._referencedTable.getName()) ? "" : baseName + "_";
        return baseName + this.getOwnTable().getName() + "_ref";
    }

    private String makeFkName(String fkName) {
        if (fkName.toLowerCase().startsWith("fk_")) {
            fkName = fkName.substring("fk_".length());
        }
        if (!this.isFkNameAcceptable(fkName)) {
            fkName = this.assignName();
        }
        return fkName;
    }

    private boolean isFkNameAcceptable(String fkName) {
        return false;
    }

    private String assignName() {
        return this._columns.size() == 1 ? JdbcSchemaForeignKey.removeId(this._columns.get(0).getName()) : this._referencedTable.getName();
    }

    public static String removeId(String name) {
        if (name.toLowerCase().endsWith("_id")) {
            name = name.substring(0, name.length() - "_id".length());
        }
        return name;
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public String getQualifiedName() {
        return this._qualifiedName;
    }

    @Override
    public String getActualName() {
        return this._actualName;
    }

    @Override
    public SchemaTable getReferencedTable() {
        return this._referencedTable;
    }

    @Override
    public List<SchemaColumn> getColumns() {
        return this._columns;
    }
}

