/*
 * Decompiled with CFR 0.152.
 */
package manifold.sql.query.jdbc;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import manifold.rt.api.util.ManStringUtil;
import manifold.sql.api.Parameter;
import manifold.sql.query.api.Command;
import manifold.sql.query.jdbc.JdbcParameter;
import manifold.sql.query.jdbc.ParamInfo;
import manifold.sql.query.jdbc.ParameterParser;
import manifold.sql.query.type.SqlIssueContainer;
import manifold.sql.query.type.SqlScope;
import manifold.sql.rt.api.ConnectionProvider;
import manifold.sql.rt.api.Dependencies;
import manifold.sql.rt.util.DbUtil;
import manifold.sql.rt.util.DriverInfo;
import manifold.sql.schema.api.Schema;
import manifold.sql.util.StatementUtil;

public class JdbcCommand
implements Command {
    private final SqlScope _scope;
    private final String _source;
    private final String _name;
    private final String _escapedName;
    private final List<Parameter> _parameters;
    private final SqlIssueContainer _issues;

    public JdbcCommand(SqlScope scope, String simpleName, String command) {
        this._scope = scope;
        List<ParamInfo> paramNames = ParameterParser.getParameters(command);
        this._source = StatementUtil.replaceNamesWithQuestion(command, paramNames);
        this._name = simpleName;
        this._parameters = new ArrayList<Parameter>();
        Schema schema = this._scope.getSchema();
        this._issues = new SqlIssueContainer(schema == null ? DriverInfo.ERRANT : schema.getDriverInfo(), new ArrayList<Exception>(), ManStringUtil.isCrLf((String)this._source));
        if (this._scope.isErrant()) {
            this._escapedName = this._name;
            return;
        }
        ConnectionProvider cp = Dependencies.instance().getConnectionProvider();
        String escapedName = null;
        try (Connection c = cp.getConnection(scope.getDbconfig());){
            escapedName = DbUtil.enquoteIdentifier((String)this._name, (DatabaseMetaData)c.getMetaData());
            this.build(c, paramNames);
        }
        catch (SQLException e) {
            this._issues.addIssues(Collections.singletonList(e));
        }
        this._escapedName = escapedName;
    }

    private void build(Connection c, List<ParamInfo> paramNames) throws SQLException {
        DatabaseMetaData metadata = c.getMetaData();
        try (PreparedStatement ps = c.prepareStatement(this._source);){
            ParameterMetaData paramMetaData = ps.getParameterMetaData();
            int paramCount = paramMetaData.getParameterCount();
            if (!paramNames.isEmpty() && paramCount != paramNames.size()) {
                throw new SQLException("Parameter name count does not match '?' param count. Query: " + this._name + "\n" + this._source);
            }
            for (int i = 1; i <= paramCount; ++i) {
                String name = paramNames.isEmpty() ? null : paramNames.get(i - 1).getName().substring(1);
                JdbcParameter<JdbcCommand> param = new JdbcParameter<JdbcCommand>(i, name, this, paramMetaData, metadata);
                this._parameters.add(param);
            }
        }
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public String getEscapedName() {
        return this._escapedName;
    }

    @Override
    public String getSqlSource() {
        return this._source;
    }

    @Override
    public List<Parameter> getParameters() {
        return this._parameters;
    }

    @Override
    public SqlIssueContainer getIssues() {
        return this._issues;
    }
}

