/*
 * Decompiled with CFR 0.152.
 */
package manifold.sql.query.type;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticListener;
import javax.tools.JavaFileObject;
import manifold.api.fs.IFile;
import manifold.api.fs.IFileFragment;
import manifold.api.host.IModule;
import manifold.api.type.AbstractSingleFileModel;
import manifold.api.util.JavacDiagnostic;
import manifold.internal.javac.IIssue;
import manifold.internal.javac.SourceJavaFileObject;
import manifold.rt.api.util.ManClassUtil;
import manifold.rt.api.util.ManStringUtil;
import manifold.rt.api.util.StreamUtil;
import manifold.sql.api.Statement;
import manifold.sql.query.api.Command;
import manifold.sql.query.api.QueryTable;
import manifold.sql.query.api.SqlAnalyzer;
import manifold.sql.query.type.CommandParentType;
import manifold.sql.query.type.QueryParentType;
import manifold.sql.query.type.SqlIssueContainer;
import manifold.sql.query.type.SqlManifold;
import manifold.sql.query.type.SqlParentType;
import manifold.sql.query.type.SqlScope;
import manifold.sql.rt.util.DriverInfo;
import manifold.sql.schema.api.Schema;

public class SqlModel
extends AbstractSingleFileModel {
    private final SqlManifold _sqlManifold;
    private SqlScope _scope;
    private SqlParentType _type;
    private Statement _sqlStatement;
    private SqlIssueContainer _issues;

    public SqlModel(SqlManifold sqlManifold, String fqn, Set<IFile> files) {
        super(sqlManifold.getModule().getHost(), fqn, files);
        this._sqlManifold = sqlManifold;
        this.init();
    }

    private void init() {
        this._issues = null;
        this._scope = this.assignScope();
        this.analyze();
        this._type = this.isCommand() ? new CommandParentType(this) : new QueryParentType(this);
    }

    public boolean isQuery() {
        return this.getSqlStatement() instanceof QueryTable;
    }

    public boolean isCommand() {
        return this.getSqlStatement() instanceof Command;
    }

    private void analyze() {
        if (this._scope.isErrant()) {
            return;
        }
        String content = null;
        try (InputStreamReader reader = new InputStreamReader(this.getFile().openInputStream());){
            SqlAnalyzer sqlAnalyzer = (SqlAnalyzer)((Set)SqlAnalyzer.PROVIDERS.get()).stream().findFirst().orElseThrow(() -> new RuntimeException("Missing SqlAnalyzer provider"));
            content = StreamUtil.getContent((Reader)reader);
            this._sqlStatement = sqlAnalyzer.makeStatement(ManClassUtil.getShortClassName((String)this.getFqn()), this._scope, content);
            this._issues = this._sqlStatement.getIssues();
        }
        catch (RuntimeException ise) {
            this._sqlStatement = null;
            Schema schema = this._scope.getSchema();
            this._issues = new SqlIssueContainer(schema == null ? DriverInfo.ERRANT : schema.getDriverInfo(), Collections.singletonList(ise), ManStringUtil.isCrLf(content));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private SqlScope assignScope() {
        SqlScope scope = this._sqlManifold.getScopeFinder().findScope(this.getFile());
        if (scope == null) {
            scope = SqlScope.makeErrantScope(this._sqlManifold.getModule(), this.getFqn(), this.getFile());
        }
        return scope;
    }

    SqlScope getScope() {
        return this._scope;
    }

    Statement getSqlStatement() {
        return this._sqlStatement;
    }

    SqlParentType getType() {
        return this._type;
    }

    IModule getModule() {
        return this._sqlManifold.getModule();
    }

    public void updateFile(IFile file) {
        super.updateFile(file);
        this.init();
    }

    void addIssue(IIssue.Kind kind, int offset, String msg) {
        this._issues.addIssue(kind, offset, msg);
    }

    void addIssue(Exception issue) {
        this._issues.addIssues(Collections.singletonList(issue));
    }

    void report(DiagnosticListener<JavaFileObject> errorHandler) {
        List<IIssue> issues;
        if (errorHandler == null) {
            return;
        }
        List<IIssue> scopeIssues = this.getScope().getIssues();
        if (!scopeIssues.isEmpty()) {
            for (IIssue scopeIssue : scopeIssues) {
                Diagnostic.Kind kind = scopeIssue.getKind() == IIssue.Kind.Error ? Diagnostic.Kind.ERROR : Diagnostic.Kind.WARNING;
                errorHandler.report((Diagnostic<JavaFileObject>)new JavacDiagnostic(null, kind, (long)scopeIssue.getStartOffset(), (long)scopeIssue.getLine(), (long)scopeIssue.getColumn(), scopeIssue.getMessage()));
            }
        }
        if (!(issues = this.getIssues()).isEmpty()) {
            SourceJavaFileObject file = new SourceJavaFileObject(this.getFile().toURI());
            for (IIssue issue : issues) {
                int offset = issue.getStartOffset();
                if (this.getFile() instanceof IFileFragment) {
                    offset += ((IFileFragment)this.getFile()).getOffset();
                }
                Diagnostic.Kind kind = issue.getKind() == IIssue.Kind.Error ? Diagnostic.Kind.ERROR : Diagnostic.Kind.WARNING;
                errorHandler.report((Diagnostic<JavaFileObject>)new JavacDiagnostic((JavaFileObject)file, kind, (long)offset, (long)issue.getLine(), (long)issue.getColumn(), issue.getMessage()));
            }
        }
    }

    private List<IIssue> getIssues() {
        return this._issues.getIssues();
    }
}

