/*
 * Decompiled with CFR 0.152.
 */
package manifold.sql.schema.type;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.tools.DiagnosticListener;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import manifold.api.gen.AbstractSrcClass;
import manifold.api.gen.AbstractSrcMethod;
import manifold.api.gen.SrcAnnotated;
import manifold.api.gen.SrcAnnotationExpression;
import manifold.api.gen.SrcConstructor;
import manifold.api.gen.SrcField;
import manifold.api.gen.SrcGetProperty;
import manifold.api.gen.SrcLinkedClass;
import manifold.api.gen.SrcMethod;
import manifold.api.gen.SrcParameter;
import manifold.api.gen.SrcSetProperty;
import manifold.api.gen.SrcType;
import manifold.api.host.IModule;
import manifold.api.util.cache.FqnCache;
import manifold.json.rt.api.DataBindings;
import manifold.rt.api.ActualName;
import manifold.rt.api.Bindings;
import manifold.rt.api.DisableStringLiteralTemplates;
import manifold.rt.api.util.ManClassUtil;
import manifold.rt.api.util.ManIdentifierUtil;
import manifold.rt.api.util.Pair;
import manifold.rt.api.util.StreamUtil;
import manifold.sql.api.Column;
import manifold.sql.rt.api.BaseEntity;
import manifold.sql.rt.api.BasicTxBindings;
import manifold.sql.rt.api.ColumnInfo;
import manifold.sql.rt.api.CrudProvider;
import manifold.sql.rt.api.DbConfig;
import manifold.sql.rt.api.Dependencies;
import manifold.sql.rt.api.Entity;
import manifold.sql.rt.api.KeyRef;
import manifold.sql.rt.api.OperableTxBindings;
import manifold.sql.rt.api.OperableTxScope;
import manifold.sql.rt.api.QueryContext;
import manifold.sql.rt.api.Runner;
import manifold.sql.rt.api.SchemaBuilder;
import manifold.sql.rt.api.SchemaType;
import manifold.sql.rt.api.TableInfo;
import manifold.sql.rt.api.TxBindings;
import manifold.sql.rt.api.TxKind;
import manifold.sql.rt.api.TxScope;
import manifold.sql.rt.api.TxScopeProvider;
import manifold.sql.rt.util.DriverInfo;
import manifold.sql.schema.api.Schema;
import manifold.sql.schema.api.SchemaColumn;
import manifold.sql.schema.api.SchemaForeignKey;
import manifold.sql.schema.api.SchemaTable;
import manifold.sql.schema.jdbc.JdbcSchemaForeignKey;
import manifold.sql.schema.type.SchemaModel;
import manifold.util.concurrent.LocklessLazyVar;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class SchemaParentType {
    public static final String ENTITY = "Entity";
    private final SchemaModel _model;

    SchemaParentType(SchemaModel model) {
        this._model = model;
    }

    private String getFqn() {
        return this._model.getFqn();
    }

    boolean hasChild(String childName) {
        return this.getSchema() != null && this.getSchema().hasTable(childName);
    }

    private Schema getSchema() {
        return this._model.getSchema();
    }

    void render(StringBuilder sb, JavaFileManager.Location location, IModule module, DiagnosticListener<JavaFileObject> errorHandler) {
        SrcLinkedClass srcClass = (SrcLinkedClass)((SrcLinkedClass)((SrcLinkedClass)new SrcLinkedClass(this.getFqn(), AbstractSrcClass.Kind.Class, this._model.getFile(), location, module, errorHandler).addAnnotation(new SrcAnnotationExpression(DisableStringLiteralTemplates.class.getSimpleName()))).modifiers(1L)).addInterface(SchemaType.class.getSimpleName());
        this.addImports(srcClass);
        this.addTxScopeMethods(srcClass);
        this.addInnerTypes(srcClass);
        this.addFkColAssignMethod(srcClass);
        srcClass.render(sb, 0);
    }

    private void addTxScopeMethods(SrcLinkedClass srcClass) {
        this.addNewScopeMethod(srcClass);
        this.addDefaultScopeMethod(srcClass);
        this.addGetDbConfigMethod(srcClass);
        this.addCommitMethod(srcClass);
        this.addRevertMethod(srcClass);
        this.addSqlChangeMethod(srcClass);
    }

    private void addDefaultScopeMethod(SrcLinkedClass srcClass) {
        SrcMethod method = (SrcMethod)((SrcMethod)((SrcMethod)((SrcMethod)new SrcMethod((AbstractSrcClass)srcClass).modifiers(10L)).name("defaultScope")).returns(new SrcType(TxScope.class.getSimpleName()))).body("return " + Dependencies.class.getName() + ".instance().getDefaultTxScopeProvider().defaultScope(" + srcClass.getName() + ".class);");
        srcClass.addMethod((AbstractSrcMethod)method);
    }

    private void addGetDbConfigMethod(SrcLinkedClass srcClass) {
        SrcMethod method = (SrcMethod)((SrcMethod)((SrcMethod)((SrcMethod)new SrcMethod((AbstractSrcClass)srcClass).modifiers(9L)).name("getDbConfig")).returns(DbConfig.class)).body("return defaultScope().getDbConfig();");
        srcClass.addMethod((AbstractSrcMethod)method);
    }

    private void addCommitMethod(SrcLinkedClass srcClass) {
        SrcMethod method = (SrcMethod)((SrcMethod)((SrcMethod)((SrcMethod)new SrcMethod((AbstractSrcClass)srcClass).modifiers(9L)).name("commit")).throwsList(new SrcType[]{new SrcType(SQLException.class.getSimpleName())})).body("defaultScope().commit();");
        srcClass.addMethod((AbstractSrcMethod)method);
        method = (SrcMethod)((SrcMethod)((SrcMethod)((SrcMethod)((SrcMethod)new SrcMethod((AbstractSrcClass)srcClass).modifiers(9L)).name("commit")).addParam("changes", TxScope.ScopeConsumer.class.getSimpleName())).throwsList(new SrcType[]{new SrcType(SQLException.class.getSimpleName())})).body("defaultScope().commit(changes);");
        srcClass.addMethod((AbstractSrcMethod)method);
    }

    private void addRevertMethod(SrcLinkedClass srcClass) {
        SrcMethod method = (SrcMethod)((SrcMethod)((SrcMethod)((SrcMethod)new SrcMethod((AbstractSrcClass)srcClass).modifiers(9L)).name("revert")).throwsList(new SrcType[]{new SrcType(SQLException.class.getSimpleName())})).body("defaultScope().revert();");
        srcClass.addMethod((AbstractSrcMethod)method);
    }

    private void addSqlChangeMethod(SrcLinkedClass srcClass) {
        SrcMethod method = (SrcMethod)((SrcMethod)((SrcMethod)((SrcMethod)((SrcMethod)new SrcMethod((AbstractSrcClass)srcClass).modifiers(9L)).name("addSqlChange")).addParam("sqlChange", TxScope.ScopeConsumer.class.getSimpleName())).throwsList(new SrcType[]{new SrcType(SQLException.class.getSimpleName())})).body("defaultScope().addSqlChange(sqlChange);");
        srcClass.addMethod((AbstractSrcMethod)method);
    }

    private void addNewScopeMethod(SrcLinkedClass srcClass) {
        SrcMethod method = (SrcMethod)((SrcMethod)((SrcMethod)new SrcMethod((AbstractSrcClass)srcClass).modifiers(9L)).name("newScope")).returns(new SrcType(TxScope.class.getSimpleName()));
        method.body("return " + Dependencies.class.getName() + ".instance().getTxScopeProvider().newScope(" + srcClass.getName() + ".class);");
        srcClass.addMethod((AbstractSrcMethod)method);
    }

    private void addInnerTypes(SrcLinkedClass srcClass) {
        if (this.getSchema() == null) {
            return;
        }
        for (SchemaTable type : this.getSchema().getTables().values()) {
            this.addTableInterfaces(type, srcClass);
        }
    }

    private void addTableInterfaces(SchemaTable table, SrcLinkedClass enclosingType) {
        String identifier = this.getSchema().getJavaTypeName(table.getName());
        String fqn = this.getFqn() + '.' + identifier;
        SrcLinkedClass srcClass = (SrcLinkedClass)((SrcLinkedClass)new SrcLinkedClass(fqn, (AbstractSrcClass)enclosingType, AbstractSrcClass.Kind.Interface).addInterface(Entity.class.getSimpleName())).modifiers(1L);
        this.extendCustomInterface(srcClass);
        this.addCustomBaseInterface(srcClass);
        SrcLinkedClass.addActualNameAnnotation((SrcAnnotated)srcClass, (String)table.getName(), (boolean)false);
        this.addEntityClass(srcClass);
        this.addCreateMethods(srcClass, table);
        this.addReadMethods(srcClass, table);
        this.addDeleteMethods(srcClass);
        this.addBuilderType(srcClass, table);
        this.addBuilderMethod(srcClass, table);
        this.addTableInfoMethod(srcClass, table);
        this.addProperties(table, srcClass);
        this.addOneToManyMethods(table, srcClass);
        this.addManyToManyMethods(table, srcClass);
        enclosingType.addInnerClass((AbstractSrcClass)srcClass);
    }

    private void extendCustomInterface(SrcLinkedClass srcClass) {
        FqnCache javaFiles = this._model.getSchemaManifold().getModule().getPathCache().getExtensionCache("java");
        javaFiles.visitDepthFirst(file -> {
            if (file == null) {
                return true;
            }
            String customSimpleName = "Custom" + srcClass.getSimpleName();
            if (file.getBaseName().equals(customSimpleName)) {
                try {
                    String content = StreamUtil.getContent((Reader)new InputStreamReader(file.openInputStream(), StandardCharsets.UTF_8));
                    if (content.contains("public interface " + customSimpleName) && content.contains(srcClass.getName())) {
                        String fqnIface = (String)this._model.getSchemaManifold().getModule().getPathCache().getFqnForFile(file).iterator().next();
                        srcClass.addInterface(fqnIface);
                        this.addForwardingStaticMethods(fqnIface);
                        return false;
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            return true;
        });
    }

    private void addForwardingStaticMethods(String fqnIface) {
    }

    private void addCustomBaseInterface(SrcLinkedClass srcClass) {
        String customBaseInterface = this._model.getDbConfig().getCustomBaseInterface();
        if (customBaseInterface != null && !customBaseInterface.isEmpty()) {
            if (!ManClassUtil.isValidClassName((String)customBaseInterface)) {
                throw new RuntimeException("Invalid custom class name: '" + customBaseInterface + "'");
            }
            srcClass.addInterface(customBaseInterface);
        }
    }

    private void addEntityClass(SrcLinkedClass interfaceType) {
        String identifier = interfaceType.getSimpleName() + ENTITY;
        String fqn = this.getFqn() + '.' + identifier;
        SrcLinkedClass srcClass = (SrcLinkedClass)new SrcLinkedClass(fqn, (AbstractSrcClass)interfaceType, AbstractSrcClass.Kind.Class).addInterface(interfaceType.getSimpleName());
        this.setSuperClass(srcClass);
        SrcConstructor ctor = (SrcConstructor)((SrcConstructor)((SrcConstructor)new SrcConstructor((AbstractSrcClass)srcClass).modifiers(1L)).addParam((SrcParameter)new SrcParameter("bindings", TxBindings.class).addAnnotation(NotNull.class.getSimpleName()))).body("super(bindings);");
        srcClass.addConstructor(ctor);
        interfaceType.addInnerClass((AbstractSrcClass)srcClass);
    }

    private void setSuperClass(SrcLinkedClass srcClass) {
        String customBaseClass = this._model.getDbConfig().getCustomBaseClass();
        if (customBaseClass != null && !customBaseClass.isEmpty()) {
            if (!ManClassUtil.isValidClassName((String)customBaseClass)) {
                throw new RuntimeException("Invalid custom class name: '" + customBaseClass + "'");
            }
            srcClass.superClass(customBaseClass);
        } else {
            srcClass.superClass(BaseEntity.class);
        }
    }

    private void addProperties(SchemaTable table, SrcLinkedClass srcClass) {
        for (Map.Entry<SchemaTable, List<SchemaForeignKey>> entry : table.getForeignKeys().entrySet()) {
            List<SchemaForeignKey> fk = entry.getValue();
            for (SchemaForeignKey sfk : fk) {
                this.addFkProperty(srcClass, sfk);
            }
        }
        for (SchemaColumn col : table.getColumns().values()) {
            this.addProperty(srcClass, col);
        }
    }

    private void addTableInfoMethod(SrcLinkedClass srcClass, SchemaTable table) {
        SrcField tableInfoField = new SrcField("myTableInfo", new SrcType(LocklessLazyVar.class.getSimpleName()).addTypeParam(TableInfo.class));
        StringBuilder sb = new StringBuilder("LocklessLazyVar.make(() -> {\n");
        sb.append("      LinkedHashMap<String, ColumnInfo> allCols = new LinkedHashMap<>();\n");
        for (Map.Entry<String, SchemaColumn> entry : table.getColumns().entrySet()) {
            String colName = entry.getKey();
            SchemaColumn col = entry.getValue();
            int jdbcType = col.getJdbcType();
            String sqlType = col.getSqlType();
            Integer size = col.getSize();
            sb.append("      allCols.put(\"" + colName + "\", new ColumnInfo(\"" + colName + "\", " + jdbcType + ", \"" + sqlType + "\", " + size + ", " + this.isRequired(col) + "));\n");
        }
        sb.append("      HashSet<String> pkCols = new HashSet<>();\n");
        for (SchemaColumn schemaColumn : table.getPrimaryKey()) {
            String pkColName = schemaColumn.getName();
            sb.append("      pkCols.add(\"" + pkColName + "\");\n\n");
        }
        sb.append("      HashSet<String> ukCols = new HashSet<>();\n");
        Iterator<Object> iterator = table.getNonNullUniqueKeys().entrySet().iterator();
        if (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            for (SchemaColumn ukCol : (List)entry.getValue()) {
                String ukColName = ukCol.getName();
                sb.append("      ukCols.add(\"" + ukColName + "\");\n");
            }
        }
        String ddlTableName = table.getName();
        sb.append("      return new TableInfo(\"" + ddlTableName + "\", pkCols, ukCols, allCols);\n");
        sb.append("    });\n");
        tableInfoField.initializer(sb.toString());
        srcClass.addField(tableInfoField);
        SrcMethod srcMethod = (SrcMethod)((SrcMethod)((SrcMethod)new SrcMethod((AbstractSrcClass)srcClass).modifiers(0x80000000000L)).name("tableInfo")).returns(TableInfo.class);
        srcMethod.body("return myTableInfo.get();");
        srcClass.addMethod((AbstractSrcMethod)srcMethod);
    }

    private void addBuilderMethod(SrcLinkedClass srcClass, SchemaTable table) {
        if (table.getKind() != SchemaTable.Kind.Table) {
            return;
        }
        this.addBuilderMethod(srcClass, table, true);
        this.addBuilderMethod(srcClass, table, false);
    }

    private void addBuilderMethod(SrcLinkedClass srcClass, SchemaTable table, boolean fkRefs) {
        if (fkRefs && !this.hasRequiredForeignKeys(table)) {
            return;
        }
        SrcMethod method = (SrcMethod)((SrcMethod)((SrcMethod)new SrcMethod((AbstractSrcClass)srcClass).modifiers(8L)).name("builder")).returns(new SrcType("Builder"));
        if (fkRefs) {
            this.addRequiredParametersUsingFkRefs(table, (AbstractSrcMethod)method);
        } else {
            this.addRequiredParameters(table, (AbstractSrcMethod)method);
        }
        srcClass.addMethod((AbstractSrcMethod)method);
        StringBuilder sb = new StringBuilder();
        sb.append("return new Builder() {\n");
        sb.append("        " + Bindings.class.getName() + " _bindings = new DataBindings();\n");
        sb.append("        {\n");
        if (fkRefs) {
            this.initFromParametersUsingFkRefs(table, sb, "_bindings");
        } else {
            this.initFromParameters(table, sb, "_bindings");
        }
        sb.append("        }\n");
        sb.append("        @Override public " + Bindings.class.getName() + " getBindings() { return _bindings; }\n");
        sb.append("      };");
        method.body(sb.toString());
    }

    private void addCreateMethods(SrcLinkedClass srcClass, SchemaTable table) {
        this.addCreateMethods(srcClass, table, true);
        this.addCreateMethods(srcClass, table, false);
    }

    private void addCreateMethods(SrcLinkedClass srcClass, SchemaTable table, boolean fkRefs) {
        if (table.getKind() != SchemaTable.Kind.Table) {
            return;
        }
        if (fkRefs && !this.hasRequiredForeignKeys(table)) {
            return;
        }
        String tableName = this.getTableFqn(table);
        SrcMethod method = (SrcMethod)((SrcMethod)((SrcMethod)new SrcMethod((AbstractSrcClass)srcClass).modifiers(8L)).name("create")).returns(new SrcType(tableName));
        if (fkRefs) {
            this.addRequiredParametersUsingFkRefs(table, (AbstractSrcMethod)method);
        } else {
            this.addRequiredParameters(table, (AbstractSrcMethod)method);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("return create(defaultScope()");
        sb.append(method.getParameters().isEmpty() ? "" : ", ");
        method.forwardParameters(sb);
        sb.append(");");
        method.body(sb.toString());
        srcClass.addMethod((AbstractSrcMethod)method);
        method = (SrcMethod)((SrcMethod)((SrcMethod)((SrcMethod)new SrcMethod((AbstractSrcClass)srcClass).modifiers(8L)).name("create")).returns(new SrcType(tableName))).addParam((SrcParameter)new SrcParameter("txScope", new SrcType(TxScope.class.getSimpleName())).addAnnotation(NotNull.class.getSimpleName()));
        if (fkRefs) {
            this.addRequiredParametersUsingFkRefs(table, (AbstractSrcMethod)method);
        } else {
            this.addRequiredParameters(table, (AbstractSrcMethod)method);
        }
        srcClass.addMethod((AbstractSrcMethod)method);
        sb = new StringBuilder();
        sb.append("DataBindings args = new DataBindings();\n");
        if (fkRefs) {
            this.initFromParametersUsingFkRefs(table, sb, "args");
        } else {
            this.initFromParameters(table, sb, "args");
        }
        sb.append("      TxBindings bindings = new BasicTxBindings(txScope, TxKind.Insert, args);\n");
        sb.append("      " + tableName + " customRow = " + Dependencies.class.getName() + ".instance().getCustomEntityFactory().newInstance(bindings, " + tableName + ".class);\n");
        sb.append("      " + tableName + " entity = customRow != null ? customRow : new " + ManClassUtil.getShortClassName((String)tableName) + "Entity(bindings);\n");
        sb.append("      ((OperableTxBindings)entity.getBindings()).setOwner(entity);\n");
        sb.append("      ((OperableTxScope)txScope).addRow(entity);\n");
        sb.append("      return entity;");
        method.body(sb.toString());
    }

    private boolean hasRequiredForeignKeys(SchemaTable table) {
        return table.getForeignKeys().values().stream().anyMatch(sfks -> sfks.stream().anyMatch(sfk -> sfk.getColumns().stream().anyMatch(c -> this.isRequired((SchemaColumn)c))));
    }

    private void initFromParametersUsingFkRefs(SchemaTable table, StringBuilder sb, String bindingsVar) {
        HashSet<SchemaColumn> fkCovered = new HashSet<SchemaColumn>();
        for (Map.Entry<SchemaTable, List<SchemaForeignKey>> entry : table.getForeignKeys().entrySet()) {
            List<SchemaForeignKey> fk = entry.getValue();
            for (SchemaForeignKey sfk : fk) {
                List<SchemaColumn> fkCols = sfk.getColumns();
                if (!fkCols.stream().anyMatch(c -> this.isRequired((SchemaColumn)c))) continue;
                String fkParamName = ManIdentifierUtil.makePascalCaseIdentifier((String)sfk.getName(), (boolean)false);
                for (SchemaColumn fkCol : fkCols) {
                    String colName = fkCol.getName();
                    String keyColName = fkCol.getForeignKey().getName();
                    sb.append("assignFkBindingValues(" + fkParamName + ", \"" + fkParamName + "\", \"" + keyColName + "\", \"" + colName + "\", " + bindingsVar + ");");
                }
                fkCovered.addAll(fkCols);
            }
        }
        for (SchemaColumn col : table.getColumns().values()) {
            if (!this.isRequired(col) || fkCovered.contains(col)) continue;
            String colName = col.getName();
            String paramName = ManIdentifierUtil.makePascalCaseIdentifier((String)col.getName(), (boolean)false);
            sb.append(bindingsVar + ".put(\"" + colName + "\", " + paramName + ");\n");
        }
    }

    private void initFromParameters(SchemaTable table, StringBuilder sb, String bindingsVar) {
        for (SchemaColumn col : table.getColumns().values()) {
            if (!this.isRequired(col)) continue;
            String colName = col.getName();
            String paramName = ManIdentifierUtil.makePascalCaseIdentifier((String)col.getName(), (boolean)false);
            sb.append(bindingsVar + ".put(\"" + colName + "\", " + paramName + ");\n");
        }
    }

    private void addRequiredParametersUsingFkRefs(SchemaTable table, AbstractSrcMethod method) {
        HashSet<SchemaForeignKey> visited = new HashSet<SchemaForeignKey>();
        for (SchemaColumn col : table.getColumns().values()) {
            if (!this.isRequired(col)) continue;
            if (col.getForeignKey() != null) {
                Set<SchemaForeignKey> sfkSet = this.getfk(table, col);
                for (SchemaForeignKey sfk : sfkSet) {
                    if (visited.contains(sfk)) continue;
                    visited.add(sfk);
                    this.addFkParam(method, sfk);
                }
                continue;
            }
            SrcParameter param = new SrcParameter(ManIdentifierUtil.makePascalCaseIdentifier((String)col.getName(), (boolean)false), col.getType());
            if (!col.getType().isPrimitive()) {
                param.addAnnotation(NotNull.class.getSimpleName());
            }
            method.addParam(param);
        }
    }

    private void addFkParam(AbstractSrcMethod method, SchemaForeignKey sfk) {
        List<SchemaColumn> fkCols = sfk.getColumns();
        if (fkCols.stream().anyMatch(c -> this.isRequired((SchemaColumn)c))) {
            String tableFqn = this.getTableFqn(sfk.getReferencedTable());
            SrcType srcType = new SrcType(tableFqn);
            method.addParam((SrcParameter)new SrcParameter(ManIdentifierUtil.makePascalCaseIdentifier((String)sfk.getName(), (boolean)false), srcType).addAnnotation(NotNull.class.getSimpleName()));
        }
    }

    private Set<SchemaForeignKey> getfk(SchemaTable table, SchemaColumn col) {
        LinkedHashSet<SchemaForeignKey> sfkSet = new LinkedHashSet<SchemaForeignKey>();
        for (List<SchemaForeignKey> sfks : table.getForeignKeys().values()) {
            block1: for (SchemaForeignKey sfk : sfks) {
                for (SchemaColumn column : sfk.getColumns()) {
                    if (column != col) continue;
                    sfkSet.add(sfk);
                    continue block1;
                }
            }
        }
        return sfkSet;
    }

    private void addRequiredParameters(SchemaTable table, AbstractSrcMethod method) {
        for (SchemaColumn col : table.getColumns().values()) {
            if (!this.isRequired(col)) continue;
            SrcParameter param = new SrcParameter(ManIdentifierUtil.makePascalCaseIdentifier((String)col.getName(), (boolean)false), col.getType());
            if (!col.getType().isPrimitive()) {
                param.addAnnotation(NotNull.class.getSimpleName());
            }
            method.addParam(param);
        }
    }

    private void addBuilderType(SrcLinkedClass enclosingType, SchemaTable table) {
        if (table.getKind() != SchemaTable.Kind.Table) {
            return;
        }
        String fqn = enclosingType.getName() + ".Builder";
        SrcLinkedClass srcInterface = (SrcLinkedClass)new SrcLinkedClass(fqn, (AbstractSrcClass)enclosingType, AbstractSrcClass.Kind.Interface).addInterface(new SrcType(SchemaBuilder.class.getSimpleName()).addTypeParam(this.getTableFqn(table)));
        enclosingType.addInnerClass((AbstractSrcClass)srcInterface);
        this.addWithMethods(srcInterface, table);
        this.addBuildMethods(srcInterface, table);
    }

    private void addBuildMethods(SrcLinkedClass srcInterface, SchemaTable table) {
        String tableName = this.getTableFqn(table);
        SrcMethod method = (SrcMethod)((SrcMethod)((SrcMethod)((SrcMethod)new SrcMethod((AbstractSrcClass)srcInterface).modifiers(0x80000000000L)).name("build")).returns(new SrcType(tableName))).body("return build(defaultScope());");
        srcInterface.addMethod((AbstractSrcMethod)method);
        method = (SrcMethod)((SrcMethod)((SrcMethod)((SrcMethod)new SrcMethod((AbstractSrcClass)srcInterface).modifiers(0x80000000000L)).name("build")).addParam((SrcParameter)new SrcParameter("txScope", new SrcType(TxScope.class.getSimpleName())).addAnnotation(NotNull.class.getSimpleName()))).returns(new SrcType(tableName));
        srcInterface.addMethod((AbstractSrcMethod)method);
        method.body("BasicTxBindings bindings = new BasicTxBindings(txScope, TxKind.Insert, Builder.this.getBindings());\n        " + tableName + " customRow = " + Dependencies.class.getName() + ".instance().getCustomEntityFactory().newInstance(bindings, " + tableName + ".class);\n        " + tableName + " entity = customRow != null ? customRow : new " + ManClassUtil.getShortClassName((String)tableName) + "Entity(bindings);\n        ((OperableTxBindings)entity.getBindings()).setOwner(entity);\n        ((OperableTxScope)txScope).addRow(entity);\n        return entity;");
    }

    private void addWithMethods(SrcLinkedClass srcClass, SchemaTable table) {
        for (Map.Entry<SchemaTable, List<SchemaForeignKey>> entry : table.getForeignKeys().entrySet()) {
            List<SchemaForeignKey> fk = entry.getValue();
            for (SchemaForeignKey sfk : fk) {
                List<SchemaColumn> fkCols = sfk.getColumns();
                if (!fkCols.stream().noneMatch(c -> this.isRequired((SchemaColumn)c))) continue;
                String tableFqn = this.getTableFqn(sfk.getReferencedTable());
                SrcType srcType = new SrcType(tableFqn);
                String propName = ManIdentifierUtil.makePascalCaseIdentifier((String)sfk.getName(), (boolean)true);
                SrcMethod withMethod = (SrcMethod)((SrcMethod)((SrcMethod)((SrcMethod)new SrcMethod().modifiers(0x80000000000L)).name("with" + propName)).addParam("$value", srcType)).returns(new SrcType(srcClass.getSimpleName()));
                SrcLinkedClass.addActualNameAnnotation((SrcAnnotated)withMethod, (String)sfk.getActualName(), (boolean)true);
                StringBuilder sb = new StringBuilder();
                for (SchemaColumn fkCol : fkCols) {
                    String colName = fkCol.getName();
                    String keyColName = fkCol.getForeignKey().getName();
                    sb.append("assignFkBindingValues($value, \"$value\", \"" + keyColName + "\", \"" + colName + "\", getBindings());");
                }
                sb.append("return this;");
                withMethod.body(sb.toString());
                srcClass.addMethod((AbstractSrcMethod)withMethod);
            }
        }
        for (SchemaColumn col : table.getColumns().values()) {
            if (this.isRequired(col)) continue;
            String actualName = col.getName();
            String propName = ManIdentifierUtil.makePascalCaseIdentifier((String)actualName, (boolean)true);
            SrcMethod withMethod = (SrcMethod)((SrcMethod)((SrcMethod)((SrcMethod)new SrcMethod().modifiers(0x80000000000L)).name("with" + propName)).addParam("$value", col.getType())).returns(new SrcType(srcClass.getSimpleName()));
            SrcLinkedClass.addActualNameAnnotation((SrcAnnotated)withMethod, (String)actualName, (boolean)true);
            withMethod.body("getBindings().put(\"" + actualName + "\", " + '$' + "value); return this;");
            srcClass.addMethod((AbstractSrcMethod)withMethod);
        }
    }

    private boolean isRequired(SchemaColumn col) {
        return !col.isNullable() && !col.isGenerated() && !col.isAutoIncrement() && col.getDefaultValue() == null && !this.bullshit(col);
    }

    private boolean bullshit(SchemaColumn col) {
        boolean isPostgresTsvector;
        boolean isSqliteRowId;
        DriverInfo driver = col.getOwner().getSchema().getDriverInfo();
        boolean bl = isSqliteRowId = driver == DriverInfo.SQLite && col.isNonNullUniqueId() && col.isPrimaryKeyPart() && col.getJdbcType() == 4;
        if (isSqliteRowId) {
            return true;
        }
        boolean bl2 = isPostgresTsvector = driver == DriverInfo.Postgres && col.getSqlType().equalsIgnoreCase("tsvector");
        return isPostgresTsvector;
    }

    private void addImports(SrcLinkedClass srcClass) {
        srcClass.addImport(Bindings.class);
        srcClass.addImport(TxBindings.class);
        srcClass.addImport(TxScope.class);
        srcClass.addImport(TxScope.ScopeConsumer.class);
        srcClass.addImport(OperableTxScope.class);
        srcClass.addImport(OperableTxBindings.class);
        srcClass.addImport(BasicTxBindings.class);
        srcClass.addImport(TxKind.class);
        srcClass.addImport(DataBindings.class);
        srcClass.addImport(Entity.class);
        srcClass.addImport(TableInfo.class);
        srcClass.addImport(ColumnInfo.class);
        srcClass.addImport(SchemaType.class);
        srcClass.addImport(SchemaBuilder.class);
        srcClass.addImport(QueryContext.class);
        srcClass.addImport(CrudProvider.class);
        srcClass.addImport(Runner.class);
        srcClass.addImport(TxScopeProvider.class);
        srcClass.addImport(KeyRef.class);
        srcClass.addImport(LocklessLazyVar.class);
        srcClass.addImport(Collections.class);
        srcClass.addImport(LinkedHashMap.class);
        srcClass.addImport(List.class);
        srcClass.addImport(Map.class);
        srcClass.addImport(Set.class);
        srcClass.addImport(HashSet.class);
        srcClass.addImport(SQLException.class);
        srcClass.addImport(Nullable.class);
        srcClass.addImport(NotNull.class);
        srcClass.addImport(ActualName.class);
        srcClass.addImport(DisableStringLiteralTemplates.class);
    }

    private void addFkProperty(SrcLinkedClass srcClass, SchemaForeignKey sfk) {
        SchemaTable table = sfk.getReferencedTable();
        String tableFqn = this.getTableFqn(table);
        SrcType type = new SrcType(tableFqn);
        String name = sfk.getName();
        String propName = ManIdentifierUtil.makePascalCaseIdentifier((String)name, (boolean)true);
        SrcMethod fkFetchMethod = (SrcMethod)((SrcMethod)((SrcMethod)new SrcMethod((AbstractSrcClass)srcClass).name("fetch" + propName)).modifiers(0x80000000000L)).returns(type);
        boolean isNullable = sfk.getColumns().stream().allMatch(c -> c.isNullable());
        fkFetchMethod.addAnnotation(isNullable ? Nullable.class.getSimpleName() : NotNull.class.getSimpleName());
        StringBuilder sb = new StringBuilder();
        sb.append("DataBindings paramBindings = new DataBindings();\n");
        List<SchemaColumn> columns = sfk.getColumns();
        for (int i = 0; i < columns.size(); ++i) {
            SchemaColumn col = columns.get(i);
            SchemaColumn referencedCol = col.getForeignKey();
            if (i == 0) {
                sb.append("    Object maybeRef = getBindings().get(\"" + col.getName() + "\");\n").append("    if(maybeRef instanceof " + Entity.class.getSimpleName() + ") {return (" + tableFqn + ")maybeRef;}\n");
            }
            sb.append("    paramBindings.put(\"" + referencedCol.getName() + "\", getBindings().get(\"" + col.getName() + "\"));\n");
        }
        String columnInfo = this.getColumnInfo(sfk.getColumns());
        String configName = this._model.getDbConfig().getName();
        sb.append("    return " + Dependencies.class.getName() + ".instance().getCrudProvider().readOne(new QueryContext<" + tableFqn + ">(getBindings().getTxScope(), " + tableFqn + ".class, \"" + table.getName() + "\", myTableInfo.get().getAllCols(), " + columnInfo + ", paramBindings, \"" + configName + "\", rowBindings -> {  " + tableFqn + " customRow = " + Dependencies.class.getName() + ".instance().getCustomEntityFactory().newInstance(rowBindings, " + tableFqn + ".class);\n  return customRow != null ? customRow : new " + tableFqn + "." + ManClassUtil.getShortClassName((String)tableFqn) + "Entity(rowBindings);} ));");
        fkFetchMethod.body(sb.toString());
        SrcLinkedClass.addActualNameAnnotation((SrcAnnotated)fkFetchMethod, (String)name, (boolean)true);
        srcClass.addMethod((AbstractSrcMethod)fkFetchMethod);
        SrcMethod fkSetter = (SrcMethod)((SrcMethod)new SrcMethod((AbstractSrcClass)srcClass).modifiers(0x80000000000L)).name("set" + propName);
        SrcParameter param = new SrcParameter("ref", new SrcType(tableFqn));
        fkSetter.addParam(param);
        if (!isNullable) {
            param.addAnnotation(NotNull.class.getSimpleName());
        }
        for (SchemaColumn fkCol : sfk.getColumns()) {
            String colName = fkCol.getName();
            String keyColName = fkCol.getForeignKey().getName();
            fkSetter.body("assignFkBindingValues(ref, \"" + propName + "\", \"" + keyColName + "\", \"" + colName + "\", getBindings());");
        }
        SrcLinkedClass.addActualNameAnnotation((SrcAnnotated)fkSetter, (String)name, (boolean)true);
        srcClass.addMethod((AbstractSrcMethod)fkSetter);
    }

    private void addFkColAssignMethod(SrcLinkedClass srcClass) {
        SrcMethod method = (SrcMethod)((SrcMethod)((SrcMethod)((SrcMethod)((SrcMethod)((SrcMethod)((SrcMethod)new SrcMethod((AbstractSrcClass)srcClass).modifiers(10L)).name("assignFkBindingValues")).addParam("ref", new SrcType(Entity.class))).addParam("propName", new SrcType(String.class))).addParam("keyColName", new SrcType(String.class))).addParam("colName", new SrcType(String.class))).addParam("bindings", new SrcType(Bindings.class));
        method.body("if(ref == null) throw new NullPointerException(\"Expecting non-null value for: \" + propName );\n    Object keyColValue = ref.getBindings().get(keyColName);\n    bindings.put(colName, keyColValue != null ? keyColValue : new KeyRef(ref, keyColName));");
        srcClass.addMethod((AbstractSrcMethod)method);
    }

    private void addProperty(SrcLinkedClass srcInterface, SchemaColumn col) {
        Class<?> type = col.getType();
        String name = col.getName();
        SrcType propType = this.makeSrcType(type);
        String propName = ManIdentifierUtil.makePascalCaseIdentifier((String)name, (boolean)true);
        String colName = ManIdentifierUtil.makeIdentifier((String)name);
        SrcGetProperty getter = (SrcGetProperty)new SrcGetProperty(propName, propType).modifiers(0x80000000000L);
        getter.addAnnotation(col.isNullable() ? Nullable.class.getSimpleName() : NotNull.class.getSimpleName());
        StringBuilder retType = new StringBuilder();
        propType.render(retType, 0, false);
        if (col.getForeignKey() != null) {
            getter.body("Object value = getBindings().get(\"" + colName + "\");\n    return value instanceof " + Entity.class.getSimpleName() + " ? null : (" + retType + ")value;");
        } else {
            getter.body("return (" + retType + ")getBindings().get(\"" + colName + "\");");
        }
        SrcLinkedClass.addActualNameAnnotation((SrcAnnotated)getter, (String)name, (boolean)true);
        srcInterface.addGetProperty(getter);
        if (!col.isGenerated() && !col.isAutoIncrement()) {
            SrcSetProperty setter = (SrcSetProperty)new SrcSetProperty(propName, propType).modifiers(0x80000000000L);
            if (!col.isNullable()) {
                ((SrcParameter)setter.getParameters().get(0)).addAnnotation(NotNull.class.getSimpleName());
            }
            setter.body("getBindings().put(\"" + colName + "\", " + '$' + "value);");
            SrcLinkedClass.addActualNameAnnotation((SrcAnnotated)setter, (String)name, (boolean)true);
            srcInterface.addSetProperty(setter);
        }
    }

    private void addReadMethods(SrcLinkedClass srcClass, SchemaTable table) {
        this.addFetchPkParamsMethods(srcClass, table);
        this.addFetchByRequiredParamMethods(srcClass, table);
    }

    private void addFetchByRequiredParamMethods(SrcLinkedClass srcClass, SchemaTable table) {
        for (SchemaColumn col : table.getColumns().values()) {
            if (!this.isRequired(col)) continue;
            this.addFetchByRequiredParamMethod(srcClass, table, col);
        }
    }

    private void addFetchByRequiredParamMethod(SrcLinkedClass srcClass, SchemaTable table, SchemaColumn reqCol) {
        String tableFqn = this.getTableFqn(table);
        String propName = ManIdentifierUtil.makePascalCaseIdentifier((String)reqCol.getName(), (boolean)true);
        SrcMethod method = (SrcMethod)((SrcMethod)((SrcMethod)new SrcMethod((AbstractSrcClass)srcClass).modifiers(8L)).name("fetchBy" + propName)).returns(new SrcType("List<" + tableFqn + ">"));
        String paramName = ManIdentifierUtil.makePascalCaseIdentifier((String)reqCol.getName(), (boolean)false);
        SrcParameter param = new SrcParameter(paramName, reqCol.getType());
        if (!reqCol.getType().isPrimitive()) {
            param.addAnnotation(NotNull.class.getSimpleName());
        }
        method.addParam(param);
        List<SchemaColumn> whereCols = Collections.singletonList(reqCol);
        StringBuilder sb = new StringBuilder();
        sb.append("return fetchBy" + propName + "(defaultScope()");
        sb.append(method.getParameters().isEmpty() ? "" : ", ");
        method.forwardParameters(sb);
        sb.append(");");
        method.body(sb.toString());
        srcClass.addMethod((AbstractSrcMethod)method);
        method = (SrcMethod)((SrcMethod)((SrcMethod)((SrcMethod)new SrcMethod((AbstractSrcClass)srcClass).modifiers(8L)).name("fetchBy" + propName)).returns(new SrcType("List<" + tableFqn + ">"))).addParam((SrcParameter)new SrcParameter("txScope", new SrcType(TxScope.class.getSimpleName())).addAnnotation(NotNull.class.getSimpleName()));
        param = new SrcParameter(paramName, reqCol.getType());
        if (!reqCol.getType().isPrimitive()) {
            param.addAnnotation(NotNull.class.getSimpleName());
        }
        method.addParam(param);
        String columnInfo = this.getColumnInfo(whereCols);
        String configName = this._model.getDbConfig().getName();
        sb = new StringBuilder();
        sb.append("DataBindings paramBindings = new DataBindings();\n");
        sb.append("    paramBindings.put(\"" + reqCol.getName() + "\", " + paramName + ");\n");
        sb.append("    return " + Dependencies.class.getName() + ".instance().getCrudProvider().readMany(new QueryContext<" + tableFqn + ">(txScope, " + tableFqn + ".class,\n      \"" + table.getName() + "\", myTableInfo.get().getAllCols(), " + columnInfo + ", paramBindings, \"" + configName + "\",\n      rowBindings -> {        " + tableFqn + " customRow = " + Dependencies.class.getName() + ".instance().getCustomEntityFactory().newInstance(rowBindings, " + tableFqn + ".class);\n        return customRow != null ? customRow : new " + tableFqn + "." + ManClassUtil.getShortClassName((String)tableFqn) + "Entity(rowBindings);      } ));");
        method.body(sb.toString());
        srcClass.addMethod((AbstractSrcMethod)method);
    }

    private void addFetchPkParamsMethods(SrcLinkedClass srcClass, SchemaTable table) {
        String tableFqn = this.getTableFqn(table);
        SrcMethod method = (SrcMethod)((SrcMethod)((SrcMethod)new SrcMethod((AbstractSrcClass)srcClass).modifiers(8L)).name("fetch")).returns(new SrcType(tableFqn));
        List<SchemaColumn> whereCols = this.addPkParameters(table, (AbstractSrcMethod)method);
        if (whereCols.isEmpty()) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("return fetch(defaultScope()");
        sb.append(method.getParameters().isEmpty() ? "" : ", ");
        method.forwardParameters(sb);
        sb.append(");");
        method.body(sb.toString());
        srcClass.addMethod((AbstractSrcMethod)method);
        method = (SrcMethod)((SrcMethod)((SrcMethod)((SrcMethod)new SrcMethod((AbstractSrcClass)srcClass).modifiers(8L)).name("fetch")).returns(new SrcType(tableFqn))).addParam((SrcParameter)new SrcParameter("txScope", new SrcType(TxScope.class.getSimpleName())).addAnnotation(NotNull.class.getSimpleName()));
        whereCols = this.addPkParameters(table, (AbstractSrcMethod)method);
        String columnInfo = this.getColumnInfo(whereCols);
        String configName = this._model.getDbConfig().getName();
        sb = new StringBuilder();
        sb.append("DataBindings paramBindings = new DataBindings();\n");
        for (SchemaColumn col : whereCols) {
            String paramName = ManIdentifierUtil.makePascalCaseIdentifier((String)col.getName(), (boolean)false);
            sb.append("    paramBindings.put(\"" + col.getName() + "\", " + paramName + ");\n");
        }
        sb.append("    return " + Dependencies.class.getName() + ".instance().getCrudProvider().readOne(new QueryContext<" + tableFqn + ">(txScope, " + tableFqn + ".class,\n      \"" + table.getName() + "\", myTableInfo.get().getAllCols(), " + columnInfo + ", paramBindings, \"" + configName + "\",\n      rowBindings -> {        " + tableFqn + " customRow = " + Dependencies.class.getName() + ".instance().getCustomEntityFactory().newInstance(rowBindings, " + tableFqn + ".class);\n        return customRow != null ? customRow : new " + tableFqn + "." + ManClassUtil.getShortClassName((String)tableFqn) + "Entity(rowBindings);      } ));");
        method.body(sb.toString());
        srcClass.addMethod((AbstractSrcMethod)method);
    }

    private List<SchemaColumn> addPkParameters(SchemaTable table, AbstractSrcMethod method) {
        List<SchemaColumn> pk = table.getPrimaryKey();
        if (!pk.isEmpty()) {
            SchemaParentType.addParameters(method, pk);
            return pk;
        }
        Iterator<Map.Entry<String, List<SchemaColumn>>> iterator = table.getNonNullUniqueKeys().entrySet().iterator();
        if (iterator.hasNext()) {
            Map.Entry<String, List<SchemaColumn>> entry = iterator.next();
            SchemaParentType.addParameters(method, entry.getValue());
            return entry.getValue();
        }
        return Collections.emptyList();
    }

    private static void addParameters(AbstractSrcMethod method, List<SchemaColumn> keyCols) {
        for (SchemaColumn col : keyCols) {
            SrcParameter param = new SrcParameter(ManIdentifierUtil.makePascalCaseIdentifier((String)col.getName(), (boolean)false), col.getType());
            if (!col.isNullable()) {
                param.addAnnotation(NotNull.class.getSimpleName());
            }
            method.addParam(param);
        }
    }

    private void addDeleteMethods(SrcLinkedClass srcClass) {
        SrcMethod delete = (SrcMethod)((SrcMethod)new SrcMethod((AbstractSrcClass)srcClass).modifiers(0x80000000000L)).name("delete");
        delete.body("((OperableTxBindings)getBindings()).setDelete(true);");
        srcClass.addMethod((AbstractSrcMethod)delete);
        SrcMethod undelete = (SrcMethod)((SrcMethod)new SrcMethod((AbstractSrcClass)srcClass).modifiers(0x80000000000L)).name("undelete");
        undelete.body("((OperableTxBindings)getBindings()).setDelete(false);");
        srcClass.addMethod((AbstractSrcMethod)undelete);
    }

    private void addOneToManyMethods(SchemaTable table, SrcLinkedClass srcClass) {
        for (SchemaForeignKey sfk : table.getOneToMany()) {
            this.addOneToManyFetcher(srcClass, sfk);
        }
    }

    private void addOneToManyFetcher(SrcLinkedClass srcClass, SchemaForeignKey fkToThis) {
        String tableFqn = this.getTableFqn(fkToThis.getOwnTable());
        SrcType type = new SrcType(tableFqn);
        String propName = ManIdentifierUtil.makePascalCaseIdentifier((String)fkToThis.getQualifiedName(), (boolean)true);
        SrcMethod method = (SrcMethod)((SrcMethod)((SrcMethod)new SrcMethod((AbstractSrcClass)srcClass).modifiers(0x80000000000L)).name("fetch" + propName + "s")).returns(new SrcType("List<" + tableFqn + ">"));
        String configName = fkToThis.getReferencedTable().getSchema().getDbConfig().getName();
        String tableName = fkToThis.getOwnTable().getName();
        String columnInfo = this.getColumnInfo(fkToThis.getColumns());
        StringBuilder sb = new StringBuilder();
        sb.append("DataBindings paramBindings = new DataBindings();\n");
        for (SchemaColumn col : fkToThis.getColumns()) {
            SchemaColumn referencedCol = col.getForeignKey();
            sb.append("    Object value = getBindings().get(\"" + col.getName() + "\");\n").append("    if(value instanceof " + Entity.class.getSimpleName() + ") return Collections.emptyList();\n").append("    paramBindings.put(\"" + referencedCol.getName() + "\", value);\n");
        }
        sb.append("    return " + Dependencies.class.getName() + ".instance().getCrudProvider().readMany(      new QueryContext<" + tableFqn + ">(getBindings().getTxScope(), " + tableFqn + ".class, \"" + tableName + "\", myTableInfo.get().getAllCols(), " + columnInfo + ", paramBindings, \"" + configName + "\",       rowBindings -> {        " + tableFqn + " customRow = " + Dependencies.class.getName() + ".instance().getCustomEntityFactory().newInstance(rowBindings, " + tableFqn + ".class);\n        return customRow != null ? customRow : new " + tableFqn + "." + ManClassUtil.getShortClassName((String)tableFqn) + "Entity(rowBindings);      } ));");
        method.body(sb.toString());
        srcClass.addMethod((AbstractSrcMethod)method);
    }

    private void addManyToManyMethods(SchemaTable table, SrcLinkedClass srcClass) {
        for (Pair<SchemaColumn, SchemaColumn> uk : table.getManyToMany()) {
            this.addManyToManyFetcher(srcClass, table, uk);
        }
    }

    private void addManyToManyFetcher(SrcLinkedClass srcClass, SchemaTable table, Pair<SchemaColumn, SchemaColumn> uk) {
        SchemaColumn fkToOther;
        SchemaColumn fkToMe;
        if (((SchemaColumn)uk.getFirst()).getForeignKey().getOwner() == table) {
            fkToMe = (SchemaColumn)uk.getFirst();
            fkToOther = (SchemaColumn)uk.getSecond();
        } else {
            fkToMe = (SchemaColumn)uk.getSecond();
            fkToOther = (SchemaColumn)uk.getFirst();
        }
        String tableFqn = this.getTableFqn(fkToOther.getForeignKey().getOwner());
        String propName = ManIdentifierUtil.makePascalCaseIdentifier((String)(JdbcSchemaForeignKey.removeId(fkToOther.getName()) + "_ref"), (boolean)true);
        SrcMethod method = (SrcMethod)((SrcMethod)((SrcMethod)new SrcMethod((AbstractSrcClass)srcClass).modifiers(0x80000000000L)).name("fetch" + propName + "s")).returns(new SrcType("List<" + tableFqn + ">"));
        String configName = fkToOther.getForeignKey().getOwner().getSchema().getDbConfig().getName();
        String otherTable = fkToOther.getForeignKey().getOwner().getName();
        String linkTable = fkToOther.getOwner().getName();
        String sql = "select * from " + otherTable + " join " + linkTable + " on " + this.makeJoinOn(fkToOther) + " where " + this.makeJoinWhere(fkToMe);
        String columnInfo = this.getColumnInfo(Collections.singletonList(fkToMe.getForeignKey()));
        StringBuilder sb = new StringBuilder();
        sb.append("DataBindings paramBindings = new DataBindings();\n");
        SchemaColumn referencedCol = fkToMe.getForeignKey();
        sb.append("      Object value = getBindings().get(\"" + fkToMe.getName() + "\");\n").append("      if(value instanceof " + Entity.class.getSimpleName() + ") return Collections.emptyList();\n").append("      paramBindings.put(\"" + referencedCol.getName() + "\", value);\n");
        sb.append("      return new " + Runner.class.getName() + "<" + tableFqn + ">(\n          new QueryContext<" + tableFqn + ">(getBindings().getTxScope(), " + tableFqn + ".class, null, myTableInfo.get().getAllCols(), " + columnInfo + ", paramBindings, \"" + configName + "\", \n          rowBindings -> {            " + tableFqn + " customRow = " + Dependencies.class.getName() + ".instance().getCustomEntityFactory().newInstance(rowBindings, " + tableFqn + ".class);\n            return customRow != null ? customRow : new " + tableFqn + "." + ManClassUtil.getShortClassName((String)tableFqn) + "Entity(rowBindings);          } ), \"" + sql + "\")\n        .fetch().toList();");
        method.body(sb.toString());
        srcClass.addMethod((AbstractSrcMethod)method);
    }

    private String makeJoinOn(SchemaColumn fkToOther) {
        StringBuilder sb = new StringBuilder();
        SchemaColumn refCol = fkToOther.getForeignKey();
        sb.append(refCol.getOwner().getName()).append('.').append(refCol.getName()).append(" = ").append(fkToOther.getOwner().getName()).append('.').append(fkToOther.getName());
        return sb.toString();
    }

    private String makeJoinWhere(SchemaColumn fkToMe) {
        StringBuilder sb = new StringBuilder();
        SchemaColumn refCol = fkToMe.getForeignKey();
        sb.append(fkToMe.getOwner().getName()).append('.').append(fkToMe.getName()).append(" = ?");
        return sb.toString();
    }

    private String getColumnInfo(List<SchemaColumn> parameters) {
        StringBuilder sb = new StringBuilder("new ColumnInfo[]{");
        for (int i = 0; i < parameters.size(); ++i) {
            Column p = parameters.get(i);
            if (i > 0) {
                sb.append(", ");
            }
            sb.append("new ColumnInfo(\"" + p.getName() + "\", " + p.getJdbcType() + ", \"{p.getSqlType()}\", " + p.getSize() + ")");
        }
        return sb.append("}").toString();
    }

    private String getTableFqn(SchemaTable table) {
        String configName = table.getSchema().getDbConfig().getName();
        return configName + "." + this.getTableSimpleTypeName(table);
    }

    private String getTableSimpleTypeName(SchemaTable table) {
        return table.getSchema().getJavaTypeName(table.getName());
    }

    private SrcType makeSrcType(Class<?> type) {
        String typeName = this.getJavaName(type);
        SrcType srcType = new SrcType(typeName);
        srcType.setPrimitive(type.isPrimitive());
        return srcType;
    }

    private String getJavaName(Class<?> cls) {
        if (cls == String.class) {
            return String.class.getSimpleName();
        }
        return cls.getTypeName();
    }
}

