/*
 * Decompiled with CFR 0.152.
 */
package manifold.sql.schema.jdbc;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import manifold.rt.api.util.Pair;
import manifold.sql.schema.api.SchemaColumn;
import manifold.sql.schema.api.SchemaForeignKey;
import manifold.sql.schema.api.SchemaTable;
import manifold.sql.schema.jdbc.JdbcSchema;
import manifold.sql.schema.jdbc.JdbcSchemaColumn;
import manifold.sql.schema.jdbc.JdbcSchemaForeignKey;
import manifold.sql.schema.jdbc.JdbcSchemaTable;

public class JdbcForeignKeyMetadata {
    private final JdbcSchemaTable _table;
    private final List<KeyPart> _keyParts;

    public JdbcForeignKeyMetadata(JdbcSchemaTable table, List<KeyPart> keyParts) {
        this._table = table;
        this._keyParts = keyParts;
    }

    public Map<SchemaTable, List<SchemaForeignKey>> resolve(JdbcSchema schema) {
        LinkedHashMap<SchemaTable, List<SchemaForeignKey>> foreignKeys = new LinkedHashMap<SchemaTable, List<SchemaForeignKey>>();
        LinkedHashMap<Pair, List> foreignKeyColumns = new LinkedHashMap<Pair, List>();
        for (KeyPart part : this._keyParts) {
            SchemaColumn fromColumn = this._table.getColumn(part.getFromColName());
            SchemaTable toTable = schema.getTable(part.getToTableName());
            SchemaColumn toColumn = toTable.getColumn(part.getToColName());
            ((JdbcSchemaColumn)fromColumn).setForeignKey((JdbcSchemaColumn)toColumn);
            String fkName = part.getFkName();
            foreignKeyColumns.computeIfAbsent(new Pair((Object)fkName, (Object)toTable), __ -> new ArrayList()).add(fromColumn);
        }
        foreignKeyColumns.forEach((k, v) -> foreignKeys.computeIfAbsent((SchemaTable)k.getSecond(), __ -> new ArrayList()).add(new JdbcSchemaForeignKey((String)k.getFirst(), (SchemaTable)k.getSecond(), (List<SchemaColumn>)v)));
        return foreignKeys;
    }

    static class KeyPart {
        private final String _fkName;
        private final String _fromColName;
        private final String _toColName;
        private final String _toTableName;

        public KeyPart(String fkName, String fromColName, String toColName, String toTableName) {
            this._fkName = fkName;
            this._fromColName = fromColName;
            this._toColName = toColName;
            this._toTableName = toTableName;
        }

        public String getFkName() {
            return this._fkName;
        }

        public String getFromColName() {
            return this._fromColName;
        }

        public String getToColName() {
            return this._toColName;
        }

        public String getToTableName() {
            return this._toTableName;
        }
    }
}

