/*
 * Decompiled with CFR 0.152.
 */
package manifold.sql.query.jdbc;

import java.util.ArrayList;
import java.util.List;
import manifold.sql.query.jdbc.ParamInfo;

public class ParameterParser {
    private static final int EOF = -2;
    private final String _query;
    private int _pos = -1;

    public static List<ParamInfo> getParameters(String query) {
        return new ParameterParser(query).parse();
    }

    private ParameterParser(String query) {
        this._query = query;
    }

    private List<ParamInfo> parse() {
        this.next();
        return this.parseParameters();
    }

    private List<ParamInfo> parseParameters() {
        ArrayList<ParamInfo> parameters = new ArrayList<ParamInfo>();
        while (!this.isEof()) {
            while (this.eatComments() || this.eatStrings() || this.eatEverythingButParamsStringsAndComments()) {
            }
            if (!this.match(':')) continue;
            int pos = this._pos - 1;
            String word = this.matchWord();
            if (word.isEmpty()) continue;
            parameters.add(new ParamInfo(pos, ':' + word));
        }
        return parameters;
    }

    private boolean eatWhitespace() {
        boolean found = false;
        while (!this.isEof() && Character.isWhitespace(this.ch())) {
            found = true;
            this.next();
        }
        return found;
    }

    private boolean eatComments() {
        return this.eatLineComment() || this.eatMultiLineComment();
    }

    private boolean eatStrings() {
        return this.eatQStrings() || this.eatStrings('\'') || this.eatStrings('\"');
    }

    private boolean eatQStrings() {
        Character startLiteral = null;
        char endLiteral = '\u0000';
        while (!this.isEof()) {
            if (startLiteral != null) {
                if (this.match(endLiteral + "'")) {
                    return true;
                }
                this.next();
                continue;
            }
            if (!this.match("q'") && !this.match("Q'")) break;
            startLiteral = Character.valueOf(this.ch());
            endLiteral = this.endLiteralFor(this.ch());
        }
        if (startLiteral != null) {
            throw new RuntimeException("String literal missing end quote");
        }
        return false;
    }

    private char endLiteralFor(char ch) {
        switch (ch) {
            case '[': {
                return ']';
            }
            case '{': {
                return '}';
            }
            case '(': {
                return ')';
            }
            case '<': {
                return '>';
            }
        }
        return ch;
    }

    private boolean eatStrings(char quote) {
        boolean isString = false;
        while (!this.isEof()) {
            if (isString) {
                if (!this.match('\\') && this.match(quote) && !this.match(quote)) {
                    return true;
                }
                this.next();
                continue;
            }
            if (!this.match(quote)) break;
            isString = true;
        }
        if (isString) {
            throw new RuntimeException("String literal missing end quote");
        }
        return false;
    }

    private boolean eatMultiLineComment() {
        boolean comment = false;
        while (!this.isEof()) {
            if (comment) {
                if (this.match("*/")) {
                    return true;
                }
                this.next();
                continue;
            }
            if (!this.match("/*")) break;
            comment = true;
        }
        if (comment) {
            throw new RuntimeException("Comment missing `*/`");
        }
        return false;
    }

    private boolean eatLineComment() {
        boolean comment = false;
        while (!this.isEof()) {
            if (comment) {
                if (this.match('\n')) {
                    return true;
                }
                this.next();
                continue;
            }
            if (!this.match("--")) break;
            comment = true;
        }
        return false;
    }

    private boolean isEof() {
        return this._pos == -2;
    }

    private void next() {
        if (this.isEof()) {
            return;
        }
        if (++this._pos == this._query.length()) {
            this._pos = -2;
        }
    }

    private char ch() {
        return this.ch(0);
    }

    private char ch(int lookahead) {
        return this._query.charAt(this._pos + lookahead);
    }

    private boolean match(char c) {
        if (this.isEof()) {
            return false;
        }
        if (this.ch() == c) {
            this.next();
            return true;
        }
        return false;
    }

    private boolean match(String s) {
        return this.match(s, false);
    }

    private boolean match(String s, boolean peek) {
        if (this.isEof()) {
            return false;
        }
        if (this._query.startsWith(s, this._pos)) {
            if (!peek) {
                this._pos += s.length();
                if (this._pos == this._query.length()) {
                    this._pos = -2;
                }
            }
            return true;
        }
        return false;
    }

    private String matchWord() {
        if (this.isEof()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        if (Character.isJavaIdentifierStart(this.ch())) {
            sb.append(this.ch());
            this.next();
            while (!this.isEof() && Character.isJavaIdentifierPart(this.ch())) {
                sb.append(this.ch());
                this.next();
            }
        }
        return sb.toString();
    }

    private boolean eatEverythingButParamsStringsAndComments() {
        int pos = this._pos;
        while (!(this.isEof() || this.ch() == ':' || this.match("q'", true) || this.match("Q'", true) || this.ch() == '\'' || this.ch() == '\"' || this.match("--", true) || this.match("/*", true))) {
            this.next();
        }
        return pos != this._pos;
    }
}

