/*
 * Decompiled with CFR 0.152.
 */
package manifold.sql.query.jdbc;

import java.sql.Connection;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import manifold.rt.api.util.ManStringUtil;
import manifold.rt.api.util.Pair;
import manifold.sql.query.api.ForeignKeyQueryRef;
import manifold.sql.query.api.QueryColumn;
import manifold.sql.query.api.QueryParameter;
import manifold.sql.query.api.QueryTable;
import manifold.sql.query.jdbc.JdbcForeignKeyQueryRef;
import manifold.sql.query.jdbc.JdbcQueryColumn;
import manifold.sql.query.jdbc.JdbcQueryParameter;
import manifold.sql.query.jdbc.ParamInfo;
import manifold.sql.query.jdbc.ParameterParser;
import manifold.sql.query.type.SqlIssueContainer;
import manifold.sql.query.type.SqlScope;
import manifold.sql.rt.api.ConnectionProvider;
import manifold.sql.rt.api.Dependencies;
import manifold.sql.schema.api.Schema;
import manifold.sql.schema.api.SchemaColumn;
import manifold.sql.schema.api.SchemaForeignKey;
import manifold.sql.schema.api.SchemaTable;

public class JdbcQueryTable
implements QueryTable {
    private final SqlScope _scope;
    private final String _source;
    private final String _name;
    private final Map<String, QueryColumn> _columns;
    private final List<QueryParameter> _parameters;
    private final SqlIssueContainer _issues;

    public JdbcQueryTable(SqlScope scope, String simpleName, String query) {
        this._scope = scope;
        List<ParamInfo> paramNames = ParameterParser.getParameters(query);
        this._source = JdbcQueryTable.replaceNamesWithQuestion(query, paramNames);
        this._name = simpleName;
        this._columns = new LinkedHashMap<String, QueryColumn>();
        this._parameters = new ArrayList<QueryParameter>();
        Schema schema = this._scope.getSchema();
        this._issues = new SqlIssueContainer(schema == null ? null : schema.getDatabaseProductName(), new ArrayList<Exception>(), ManStringUtil.isCrLf((String)this._source));
        if (this._scope.isErrant()) {
            return;
        }
        ConnectionProvider cp = Dependencies.instance().getConnectionProvider();
        try (Connection c = cp.getConnection(scope.getDbconfig());){
            this.build(c, paramNames);
        }
        catch (SQLException e) {
            this._issues.addIssues(Collections.singletonList(e));
        }
    }

    private static String replaceNamesWithQuestion(String source, List<ParamInfo> params) {
        StringBuilder procSource = new StringBuilder(source);
        for (int i = params.size() - 1; i >= 0; --i) {
            ParamInfo param = params.get(i);
            String name = param.getName();
            procSource.replace(param.getPos(), param.getPos() + name.length(), "?");
        }
        return procSource.toString();
    }

    private void build(Connection c, List<ParamInfo> paramNames) throws SQLException {
        try (PreparedStatement preparedStatement = c.prepareStatement(this._source);){
            ResultSetMetaData rsMetaData = preparedStatement.getMetaData();
            int columnCount = rsMetaData.getColumnCount();
            for (int i = 1; i <= columnCount; ++i) {
                JdbcQueryColumn col = new JdbcQueryColumn(i, this, rsMetaData);
                this._columns.put(col.getName(), col);
            }
            ParameterMetaData paramMetaData = preparedStatement.getParameterMetaData();
            int paramCount = paramMetaData.getParameterCount();
            if (!paramNames.isEmpty() && paramCount != paramNames.size()) {
                throw new SQLException("Parameter name count does not match '?' param count. Query: " + this._name + "\n" + this._source);
            }
            for (int i = 1; i <= paramCount; ++i) {
                String name = paramNames.isEmpty() ? null : paramNames.get(i - 1).getName().substring(1);
                JdbcQueryParameter param = new JdbcQueryParameter(i, name, this, paramMetaData, preparedStatement);
                this._parameters.add(param);
            }
        }
    }

    @Override
    public Pair<SchemaTable, List<QueryColumn>> findSelectedTable() {
        Map<SchemaTable, List<QueryColumn>> map = this.queryColumnsBySchemaTable();
        for (Map.Entry<SchemaTable, List<QueryColumn>> entry : map.entrySet()) {
            List<QueryColumn> queryCols;
            SchemaTable schemaTable = entry.getKey();
            if (!this.allNonNullColumnsRepresented(schemaTable, queryCols = entry.getValue())) continue;
            return new Pair((Object)schemaTable, queryCols);
        }
        return null;
    }

    @Override
    public List<ForeignKeyQueryRef> findForeignKeyQueryRefs() {
        Map<String, QueryColumn> columns = this.getColumns();
        Pair<SchemaTable, List<QueryColumn>> coveredTable = this.findSelectedTable();
        if (coveredTable != null) {
            ((List)coveredTable.getSecond()).forEach(c -> {
                QueryColumn cfr_ignored_0 = (QueryColumn)columns.remove(c.getName());
            });
        }
        ArrayList<ForeignKeyQueryRef> fkRefs = new ArrayList<ForeignKeyQueryRef>();
        HashSet<QueryColumn> taken = new HashSet<QueryColumn>();
        for (QueryColumn col : columns.values()) {
            SchemaTable schemaTable;
            if (taken.contains(col) || (schemaTable = col.getSchemaTable()) == null) continue;
            this.findFkRefs(schemaTable, columns.values(), fkRefs, taken);
        }
        return fkRefs;
    }

    private void findFkRefs(SchemaTable schemaTable, Collection<QueryColumn> columns, List<ForeignKeyQueryRef> fkRefs, Set<QueryColumn> taken) {
        Collection<List<SchemaForeignKey>> foreignKeys = schemaTable.getForeignKeys().values();
        for (List<SchemaForeignKey> fks : foreignKeys) {
            ArrayList<QueryColumn> fkQueryCols = new ArrayList<QueryColumn>();
            block1: for (SchemaForeignKey fk : fks) {
                for (QueryColumn queryCol : columns) {
                    List<SchemaColumn> fkCols = fk.getColumns();
                    SchemaColumn schemaColumn = queryCol.getSchemaColumn();
                    if (schemaColumn == null || !fkCols.contains(schemaColumn)) continue;
                    taken.add(queryCol);
                    fkQueryCols.add(queryCol);
                    if (fkQueryCols.size() != fkCols.size()) continue;
                    fkRefs.add(new JdbcForeignKeyQueryRef(fk, fkQueryCols));
                    continue block1;
                }
            }
        }
    }

    private Map<SchemaTable, List<QueryColumn>> queryColumnsBySchemaTable() {
        LinkedHashMap<SchemaTable, List<QueryColumn>> map = new LinkedHashMap<SchemaTable, List<QueryColumn>>();
        for (QueryColumn col : this.getColumns().values()) {
            SchemaTable schemaTable = col.getSchemaTable();
            if (schemaTable == null) continue;
            map.computeIfAbsent(schemaTable, __ -> new ArrayList()).add(col);
        }
        return map;
    }

    private boolean allNonNullColumnsRepresented(SchemaTable schemaTable, List<QueryColumn> queryCols) {
        Set queriedSchemaCols = queryCols.stream().map(c -> c.getSchemaColumn()).filter(c -> c != null).collect(Collectors.toSet());
        return queriedSchemaCols.containsAll(schemaTable.getNonNullColumns());
    }

    @Override
    public String getQuerySource() {
        return this._source;
    }

    @Override
    public Schema getSchema() {
        return this._scope.getSchema();
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public Map<String, QueryColumn> getColumns() {
        return new LinkedHashMap<String, QueryColumn>(this._columns);
    }

    @Override
    public QueryColumn getColumn(String columnName) {
        return this._columns.get(columnName);
    }

    @Override
    public List<QueryParameter> getParameters() {
        return this._parameters;
    }

    @Override
    public SqlIssueContainer getIssues() {
        return this._issues;
    }
}

