/*
 * Decompiled with CFR 0.152.
 */
package manifold.sql.query.jdbc;

import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import manifold.rt.api.util.Pair;
import manifold.sql.query.api.QueryParameter;
import manifold.sql.query.jdbc.JdbcQueryTable;

public class JdbcQueryParameter
implements QueryParameter {
    private final JdbcQueryTable _queryTable;
    private final int _position;
    private final String _name;
    private final int _jdbcType;
    private final int _size;
    private final int _scale;
    private final boolean _isNullable;
    private final boolean _isSigned;
    private final String _javaClassNameForGetObject;

    public JdbcQueryParameter(int paramIndex, String name, JdbcQueryTable queryTable, ParameterMetaData paramMetaData, PreparedStatement preparedStatement) throws SQLException {
        this._position = paramIndex;
        this._name = name == null ? "p" + paramIndex : name;
        this._queryTable = queryTable;
        Pair<Integer, Boolean> types = this.getJdbcType(preparedStatement, paramMetaData, paramIndex);
        int jdbcType = (Integer)types.getFirst();
        boolean isFlakyDriver = (Boolean)types.getSecond();
        this._jdbcType = jdbcType;
        this._size = paramMetaData.getPrecision(paramIndex);
        this._scale = paramMetaData.getScale(paramIndex);
        this._isNullable = paramMetaData.isNullable(paramIndex) != 0;
        this._isSigned = paramMetaData.isSigned(paramIndex);
        this._javaClassNameForGetObject = isFlakyDriver ? Object.class.getTypeName() : paramMetaData.getParameterClassName(paramIndex);
    }

    private Pair<Integer, Boolean> getJdbcType(PreparedStatement preparedStatement, ParameterMetaData paramMetaData, int paramIndex) throws SQLException {
        int jdbcType;
        boolean isFlakyDriver = false;
        try {
            jdbcType = paramMetaData.getParameterType(paramIndex);
            if (jdbcType == 12 && "sqlite".equalsIgnoreCase(this.getTable().getSchema().getDatabaseProductName())) {
                jdbcType = 1111;
                isFlakyDriver = true;
            }
        }
        catch (SQLException se) {
            jdbcType = 1111;
            isFlakyDriver = true;
        }
        return new Pair((Object)jdbcType, (Object)isFlakyDriver);
    }

    @Override
    public int getJdbcType() {
        return this._jdbcType;
    }

    @Override
    public String getColumnClassName() {
        return this._javaClassNameForGetObject;
    }

    @Override
    public JdbcQueryTable getTable() {
        return this._queryTable;
    }

    public int getPosition() {
        return this._position;
    }

    public String getName() {
        return this._name;
    }

    public int getSize() {
        return this._size;
    }

    @Override
    public int getScale() {
        return this._scale;
    }

    public boolean isNullable() {
        return this._isNullable;
    }

    @Override
    public boolean isSigned() {
        return this._isSigned;
    }
}

