/*
 * Decompiled with CFR 0.152.
 */
package manifold.sql.schema.jdbc.oneoff;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SqliteTypeMapping {
    private static final Pattern COLUMN_TYPENAME = Pattern.compile("([^(]*)");

    public String getProductName() {
        return "sqlite";
    }

    public Integer getJdbcType(String productName, ResultSet rs) throws SQLException {
        if (!productName.equalsIgnoreCase(this.getProductName())) {
            return null;
        }
        String sqlType = rs.getString("TYPE_NAME");
        if (sqlType == null) {
            return null;
        }
        String baseName = SqliteTypeMapping.extractBaseType(sqlType);
        String string = sqlType = baseName == null ? sqlType : baseName;
        if ("BOOLEAN".equals(sqlType)) {
            return 16;
        }
        if ("TINYINT".equals(sqlType)) {
            return -6;
        }
        if ("SMALLINT".equals(sqlType) || "INT2".equals(sqlType)) {
            return 5;
        }
        if ("BIGINT".equals(sqlType) || "INT8".equals(sqlType) || "UNSIGNED BIG INT".equals(sqlType)) {
            return -5;
        }
        if ("DATE".equals(sqlType) || "DATETIME".equals(sqlType)) {
            return 91;
        }
        if ("TIMESTAMP".equals(sqlType)) {
            return 93;
        }
        if ("TIME".equals(sqlType)) {
            return 92;
        }
        if ("INT".equals(sqlType) || "INTEGER".equals(sqlType) || "MEDIUMINT".equals(sqlType)) {
            return 4;
        }
        if ("DECIMAL".equals(sqlType)) {
            return 3;
        }
        if ("DOUBLE".equals(sqlType) || "DOUBLE PRECISION".equals(sqlType)) {
            return 8;
        }
        if ("NUMERIC".equals(sqlType)) {
            return 2;
        }
        if ("REAL".equals(sqlType)) {
            return 7;
        }
        if ("FLOAT".equals(sqlType)) {
            return 6;
        }
        if ("CHARACTER".equals(sqlType) || "NCHAR".equals(sqlType) || "NATIVE CHARACTER".equals(sqlType) || "CHAR".equals(sqlType)) {
            return 1;
        }
        if ("CLOB".equals(sqlType)) {
            return 2005;
        }
        if ("VARCHAR".equals(sqlType) || "VARYING CHARACTER".equals(sqlType) || "NVARCHAR".equals(sqlType) || "TEXT".equals(sqlType)) {
            return 12;
        }
        if ("VARBINARY".equals(sqlType) || "VARYING BINARY".equals(sqlType)) {
            return -3;
        }
        if ("BINARY".equals(sqlType)) {
            return -2;
        }
        if ("BLOB".equals(sqlType)) {
            return 2004;
        }
        if ("JAVA_OBJECT".equals(sqlType)) {
            return 1111;
        }
        return null;
    }

    private static String extractBaseType(String sqlType) {
        Matcher matcher = COLUMN_TYPENAME.matcher(sqlType);
        return matcher.find() ? matcher.group(1).toUpperCase(Locale.ENGLISH) : null;
    }
}

