/*
 * Decompiled with CFR 0.152.
 */
package manifold.sql.query.type;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import manifold.internal.javac.IIssue;
import manifold.internal.javac.IIssueContainer;
import manifold.sql.query.type.SqlIssue;

public class SqlIssueContainer
implements IIssueContainer {
    private final List<IIssue> _issues;
    private final String _productName;
    private final boolean _isQueryCrLf;

    public SqlIssueContainer(String productName, List<Exception> errors, boolean isQueryCrLf) {
        this._productName = productName;
        this._issues = new ArrayList<IIssue>();
        this.addIssues(errors);
        this._isQueryCrLf = isQueryCrLf;
    }

    public List<IIssue> getIssues() {
        return this._issues;
    }

    public List<IIssue> getWarnings() {
        return this.getIssues().stream().filter(issue -> issue.getKind() == IIssue.Kind.Warning).collect(Collectors.toList());
    }

    public List<IIssue> getErrors() {
        return this.getIssues().stream().filter(issue -> issue.getKind() == IIssue.Kind.Error).collect(Collectors.toList());
    }

    public void addIssue(IIssue.Kind kind, int offset, String msg) {
        this._issues.add(new SqlIssue(kind, offset, msg));
    }

    public void addIssues(List<Exception> errors) {
        for (Exception e : errors) {
            int offset = this.findOffset(e);
            this._issues.add(new SqlIssue(IIssue.Kind.Error, offset, e.getMessage()));
        }
    }

    private int findOffset(Exception e) {
        if (this._productName == null) {
            return 0;
        }
        switch (this._productName.toLowerCase()) {
            case "h2": {
                return this.findOffset_h2(e);
            }
        }
        return 0;
    }

    private int findOffset_h2(Exception e) {
        if (e instanceof SQLException) {
            int marker;
            String msg = e.getMessage();
            if (msg == null) {
                return 0;
            }
            int start = (msg = msg.replace("\\000a", this._isQueryCrLf ? "\r\n" : "\n")).indexOf(34) + 1;
            if (start > 0 && (marker = msg.indexOf("[*]")) >= 0) {
                return marker - start;
            }
        }
        return 0;
    }

    public boolean isEmpty() {
        return this._issues == null;
    }
}

