/*
 * Decompiled with CFR 0.152.
 */
package manifold.sql.schema.jdbc;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.Map;
import manifold.rt.api.util.ManIdentifierUtil;
import manifold.sql.rt.api.ConnectionProvider;
import manifold.sql.rt.api.DbConfig;
import manifold.sql.rt.api.Dependencies;
import manifold.sql.schema.api.Schema;
import manifold.sql.schema.api.SchemaTable;
import manifold.sql.schema.jdbc.JdbcSchemaTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcSchema
implements Schema {
    private static final Logger LOGGER = LoggerFactory.getLogger(JdbcSchema.class);
    private final String _name;
    private final DbConfig _dbConfig;
    private final Map<String, SchemaTable> _tables;
    private final Map<String, String> _javaToName;
    private final Map<String, String> _nameToJava;
    private final String _dbProductName;
    private final String _dbProductVersion;

    public JdbcSchema(DbConfig dbConfig) throws SQLException {
        this._dbConfig = dbConfig;
        this._tables = new LinkedHashMap<String, SchemaTable>();
        this._javaToName = new LinkedHashMap<String, String>();
        this._nameToJava = new LinkedHashMap<String, String>();
        ConnectionProvider cp = Dependencies.instance().getConnectionProvider();
        try (Connection c = cp.getConnection(dbConfig);){
            this._dbProductName = c.getMetaData().getDatabaseProductName();
            this._dbProductVersion = c.getMetaData().getDatabaseProductVersion();
            DatabaseMetaData metaData = c.getMetaData();
            this._name = this.findSchemaName(metaData);
            this.build(c, metaData);
        }
        catch (SQLException se) {
            throw se;
        }
        catch (Exception e) {
            LOGGER.warn("Suspicious exception.", (Throwable)e);
            throw new SQLException(e);
        }
    }

    private void build(Connection c, DatabaseMetaData metaData) throws SQLException {
        try (ResultSet resultSet = metaData.getTables(this._dbConfig.getCatalogName(), this._name, null, new String[]{"TABLE", "VIEW"});){
            while (resultSet.next()) {
                JdbcSchemaTable table = new JdbcSchemaTable(this, metaData, resultSet);
                String name = table.getName();
                this._tables.put(name, table);
                String javaName = ManIdentifierUtil.makePascalCaseIdentifier((String)name, (boolean)true);
                this._javaToName.put(javaName, name);
                this._nameToJava.put(name, javaName);
            }
        }
        for (SchemaTable table : this._tables.values()) {
            table.resolveForeignKeys();
        }
        for (SchemaTable table : this._tables.values()) {
            table.resolveFkRelations();
        }
    }

    String findSchemaName(DatabaseMetaData metaData) throws SQLException {
        String defaultSchema = null;
        String catalogName = this._dbConfig.getCatalogName();
        String schemaName = this._dbConfig.getSchemaName();
        try (ResultSet schemas = catalogName != null ? metaData.getSchemas(catalogName, schemaName) : metaData.getSchemas();){
            while (schemas.next()) {
                String schem = schemas.getString("TABLE_SCHEM");
                if (schem.equalsIgnoreCase(schemaName)) {
                    String string = schem;
                    return string;
                }
                if (schem.equalsIgnoreCase(this.getDbConfig().getName())) {
                    String string = schem;
                    return string;
                }
                if (schem.equalsIgnoreCase("information_schema") || schem.equalsIgnoreCase("system_lobs") || !(defaultSchema = schem).equalsIgnoreCase("public")) continue;
                break;
            }
        }
        return defaultSchema;
    }

    @Override
    public String getCatalog() {
        return this.getDbConfig().getCatalogName();
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public DbConfig getDbConfig() {
        return this._dbConfig;
    }

    @Override
    public boolean hasTable(String name) {
        return this._tables.containsKey(name) || this._tables.containsKey(this.getOriginalName(name));
    }

    @Override
    public SchemaTable getTable(String name) {
        SchemaTable table = this._tables.get(name);
        if (table == null) {
            table = this._tables.get(this.getOriginalName(name));
        }
        return table;
    }

    @Override
    public Map<String, SchemaTable> getTables() {
        return this._tables;
    }

    @Override
    public String getJavaTypeName(String name) {
        return this._nameToJava.get(name);
    }

    @Override
    public String getOriginalName(String javaName) {
        return this._javaToName.get(javaName);
    }

    @Override
    public String getDatabaseProductName() {
        return this._dbProductName;
    }

    @Override
    public String getDatabaseProductVersion() {
        return this._dbProductVersion;
    }
}

