/*
 * Decompiled with CFR 0.152.
 */
package manifold.sql.query.type;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import manifold.api.fs.IFile;
import manifold.api.fs.IFileFragment;
import manifold.api.host.IModule;
import manifold.internal.javac.IIssue;
import manifold.sql.query.type.SqlIssue;
import manifold.sql.rt.api.DbConfig;
import manifold.sql.rt.impl.DbConfigImpl;
import manifold.sql.schema.api.Schema;
import manifold.sql.schema.type.SchemaIssueContainer;
import manifold.sql.schema.type.SchemaManifold;
import manifold.sql.schema.type.SchemaModel;

public class SqlScope {
    private final IModule _module;
    private final List<IIssue> _issues;
    private final IFile _dbConfigFile;

    SqlScope(IModule module, IFile dbConfigFile) {
        this._module = module;
        this._dbConfigFile = dbConfigFile;
        this._issues = new ArrayList<IIssue>();
    }

    private Schema findSchema(IFile dbConfigFile) {
        Set tms = this._module.findTypeManifoldsFor(dbConfigFile);
        SchemaManifold schemaManifold = (SchemaManifold)tms.stream().filter(m -> m instanceof SchemaManifold).findFirst().orElseThrow(() -> new RuntimeException("Could not find schema manifold for: " + dbConfigFile.getName()));
        this.addIssuesFromSchemaModel(dbConfigFile, schemaManifold);
        return schemaManifold.getSchema(dbConfigFile);
    }

    private void addIssuesFromSchemaModel(IFile dbConfigFile, SchemaManifold schemaManifold) {
        Set fqnForFile = schemaManifold.getModule().getPathCache().getFqnForFile(dbConfigFile);
        if (!fqnForFile.isEmpty()) {
            SchemaIssueContainer issueContainer;
            SchemaModel schemaModel = schemaManifold.getModel(schemaManifold.getTypeNameForFile((String)fqnForFile.iterator().next(), dbConfigFile));
            SchemaIssueContainer schemaIssueContainer = issueContainer = schemaModel == null ? null : schemaModel.getIssueContainer();
            if (issueContainer != null && !issueContainer.isEmpty()) {
                this._issues.addAll(issueContainer.getIssues());
            }
        }
    }

    private SqlScope(IModule module) {
        this._module = module;
        this._issues = new ArrayList<IIssue>();
        this._dbConfigFile = null;
    }

    public static SqlScope makeErrantScope(IModule module, String fqn, IFile file) {
        SqlScope errantScope = new SqlScope(module);
        errantScope._issues.add(new SqlIssue(IIssue.Kind.Error, 0, "SQL type '" + fqn + "' from file '" + file.getName() + "' is not covered in any .dbconfig files"));
        return errantScope;
    }

    boolean hasConfigErrors() {
        return this._issues.stream().anyMatch(issue -> issue.getKind() == IIssue.Kind.Error);
    }

    public DbConfig getDbconfig() {
        Schema schema = this.getSchema();
        return schema == null ? DbConfigImpl.EMPTY : this.getSchema().getDbConfig();
    }

    public Schema getSchema() {
        return this._dbConfigFile == null ? null : this.findSchema(this._dbConfigFile);
    }

    List<IIssue> getIssues() {
        return this._issues;
    }

    boolean appliesTo(IFile file) {
        if (this.hasConfigErrors() || this.getDbconfig().getName() == null) {
            return false;
        }
        String dbConfigName = SqlScope.findDbConfigName(file);
        if (dbConfigName != null) {
            return this.getDbconfig().getName().equals(dbConfigName);
        }
        return false;
    }

    public static boolean isDefaultScopeApplicable(IFile file) {
        String dbConfigName = SqlScope.findDbConfigName(file);
        return dbConfigName == null || dbConfigName.isEmpty();
    }

    static String findDbConfigName(IFile file) {
        if (file instanceof IFileFragment) {
            return ((IFileFragment)file).getScope();
        }
        String fileBaseName = file.getBaseName();
        int dbconfigName = fileBaseName.lastIndexOf(46);
        if (dbconfigName < 0) {
            return null;
        }
        return fileBaseName.substring(dbconfigName + 1);
    }

    public boolean isErrant() {
        return this.getDbconfig().getBuildUrlOtherwiseRuntimeUrl() == null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SqlScope)) {
            return false;
        }
        SqlScope sqlScope = (SqlScope)o;
        return this._dbConfigFile != null && sqlScope._dbConfigFile != null && Objects.equals(this._dbConfigFile.getPath(), sqlScope._dbConfigFile.getPath());
    }

    public int hashCode() {
        return Objects.hash(this._dbConfigFile);
    }
}

