/*
 * Decompiled with CFR 0.152.
 */
package manifold.sql.schema.type;

import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.tools.DiagnosticListener;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import manifold.api.fs.IFile;
import manifold.api.host.IModule;
import manifold.api.type.JavaTypeManifold;
import manifold.json.rt.Json;
import manifold.rt.api.Bindings;
import manifold.rt.api.util.ManClassUtil;
import manifold.rt.api.util.StreamUtil;
import manifold.sql.schema.api.Schema;
import manifold.sql.schema.api.SchemaTable;
import manifold.sql.schema.type.SchemaModel;

public class SchemaManifold
extends JavaTypeManifold<SchemaModel> {
    public static final String DBCONFIG_EXT = "dbconfig";
    public static final List<String> EXTS = Collections.singletonList("dbconfig");

    public void init(IModule module) {
        this.init(module, (fqn, files) -> new SchemaModel(this, (String)fqn, (Set<IFile>)files));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getTypeNameForFile(String defaultFqn, IFile file) {
        try (InputStreamReader reader = new InputStreamReader(file.openInputStream());){
            Bindings bindings = (Bindings)Json.fromJson((String)StreamUtil.getContent((Reader)reader));
            String schemaPackage = (String)bindings.get((Object)"schemaPackage");
            if (schemaPackage == null) {
                throw new RuntimeException("Missing 'schemaPackage' from DbConfig file: " + file);
            }
            String simpleName = ManClassUtil.getShortClassName((String)defaultFqn);
            String string = super.getTypeNameForFile(schemaPackage + '.' + simpleName, file);
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean handlesFileExtension(String fileExtension) {
        return EXTS.contains(fileExtension);
    }

    public boolean isInnerType(String topLevel, String relativeInner) {
        Schema type;
        SchemaModel model = this.getModel(topLevel);
        Schema schema = type = model == null ? null : model.getSchema();
        if (type == null) {
            return false;
        }
        SchemaTable table = model.getTable(relativeInner);
        return table != null;
    }

    public SchemaModel getModel(String fqn) {
        return (SchemaModel)super.getModel(fqn);
    }

    public Schema getSchema(IFile file) {
        Set fqns = this.getModule().getPathCache().getFqnForFile(file);
        if (fqns.isEmpty()) {
            return null;
        }
        SchemaModel model = fqns.stream().map(fqn -> this.getModel(this.getTypeNameForFile((String)fqn, file))).filter(m -> m != null).findFirst().orElse(null);
        return model == null ? null : model.getSchema();
    }

    protected String contribute(JavaFileManager.Location location, String topLevelFqn, boolean genStubs, String existing, SchemaModel model, DiagnosticListener<JavaFileObject> errorHandler) {
        StringBuilder sb = new StringBuilder();
        model.getType().render(sb, location, this.getModule(), errorHandler);
        model.report(errorHandler);
        return sb.toString();
    }
}

