/*
 * Decompiled with CFR 0.152.
 */
package manifold.sql.query.jdbc;

import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import manifold.sql.query.api.QueryParameter;
import manifold.sql.query.jdbc.JdbcQueryTable;

public class JdbcQueryParameter
implements QueryParameter {
    private final JdbcQueryTable _queryTable;
    private final int _position;
    private final String _name;
    private final int _jdbcType;
    private final int _size;
    private final int _scale;
    private final boolean _isNullable;
    private final boolean _isSigned;

    public JdbcQueryParameter(int paramIndex, String name, JdbcQueryTable queryTable, ParameterMetaData paramMetaData, PreparedStatement preparedStatement) throws SQLException {
        int jdbcType;
        this._position = paramIndex;
        this._name = name == null ? "p" + paramIndex : name;
        this._queryTable = queryTable;
        try {
            jdbcType = paramMetaData.getParameterType(paramIndex);
        }
        catch (SQLException se) {
            preparedStatement.setString(paramIndex, "");
            jdbcType = 1111;
        }
        this._jdbcType = this.handleUnknownType(jdbcType);
        this._size = paramMetaData.getPrecision(paramIndex);
        this._scale = paramMetaData.getScale(paramIndex);
        this._isNullable = paramMetaData.isNullable(paramIndex) != 0;
        this._isSigned = paramMetaData.isSigned(paramIndex);
    }

    private int handleUnknownType(int jdbcType) {
        String databaseProductName = this._queryTable.getSchema().getDatabaseProductName();
        if ("SQLite".equalsIgnoreCase(databaseProductName)) {
            return 1111;
        }
        return jdbcType;
    }

    @Override
    public int getJdbcType() {
        return this._jdbcType;
    }

    @Override
    public JdbcQueryTable getTable() {
        return this._queryTable;
    }

    public int getPosition() {
        return this._position;
    }

    public String getName() {
        return this._name;
    }

    public int getSize() {
        return this._size;
    }

    @Override
    public int getScale() {
        return this._scale;
    }

    public boolean isNullable() {
        return this._isNullable;
    }

    @Override
    public boolean isSigned() {
        return this._isSigned;
    }
}

