/*
 * Decompiled with CFR 0.152.
 */
package manifold.sql.query.jdbc;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import manifold.sql.query.api.QueryColumn;
import manifold.sql.query.api.QueryTable;
import manifold.sql.query.jdbc.JdbcQueryTable;
import manifold.sql.schema.api.SchemaColumn;
import manifold.sql.schema.api.SchemaTable;

public class JdbcQueryColumn
implements QueryColumn {
    private final QueryTable _queryTable;
    private final SchemaTable _schemaTable;
    private final SchemaColumn _schemaColumn;
    private final int _position;
    private final String _name;
    private final int _jdbcType;
    private final int _size;
    private final int _scale;
    private final int _displaySize;
    private final boolean _isNullable;
    private final boolean _isCurrency;
    private final boolean _isReadOnly;
    private final boolean _isSigned;

    public JdbcQueryColumn(int colIndex, JdbcQueryTable queryTable, ResultSetMetaData rsMetaData) throws SQLException {
        this._position = colIndex;
        this._queryTable = queryTable;
        String tableName = rsMetaData.getTableName(colIndex);
        this._schemaTable = tableName == null || tableName.isEmpty() ? null : this._queryTable.getSchema().getTable(tableName);
        this._name = rsMetaData.getColumnLabel(colIndex);
        this._schemaColumn = this._schemaTable == null ? null : this._schemaTable.getColumn(rsMetaData.getColumnName(colIndex));
        this._jdbcType = rsMetaData.getColumnType(colIndex);
        this._isNullable = rsMetaData.isNullable(colIndex) == 1;
        this._size = rsMetaData.getPrecision(colIndex);
        this._scale = rsMetaData.getScale(colIndex);
        this._displaySize = rsMetaData.getColumnDisplaySize(colIndex);
        this._isCurrency = rsMetaData.isCurrency(colIndex);
        this._isReadOnly = rsMetaData.isReadOnly(colIndex);
        this._isSigned = rsMetaData.isSigned(colIndex);
    }

    @Override
    public QueryTable getTable() {
        return this._queryTable;
    }

    @Override
    public SchemaTable getSchemaTable() {
        return this._schemaTable;
    }

    @Override
    public int getJdbcType() {
        return this._jdbcType;
    }

    @Override
    public SchemaColumn getSchemaColumn() {
        return this._schemaColumn;
    }

    public int getPosition() {
        return this._position;
    }

    @Override
    public String getName() {
        return this._name;
    }

    public boolean isNullable() {
        return this._isNullable;
    }

    public int getSize() {
        return this._size;
    }

    @Override
    public int getScale() {
        return this._scale;
    }

    @Override
    public QueryTable getQueryTable() {
        return this._queryTable;
    }

    @Override
    public int getDisplaySize() {
        return this._displaySize;
    }

    @Override
    public boolean isCurrency() {
        return this._isCurrency;
    }

    @Override
    public boolean isReadOnly() {
        return this._isReadOnly;
    }

    @Override
    public boolean isSigned() {
        return this._isSigned;
    }
}

