/*
 * Decompiled with CFR 0.152.
 */
package manifold.sql.schema.jdbc;

import java.util.List;
import manifold.sql.schema.api.SchemaColumn;
import manifold.sql.schema.api.SchemaForeignKey;
import manifold.sql.schema.api.SchemaTable;

public class JdbcSchemaForeignKey
implements SchemaForeignKey {
    private final String _name;
    private final SchemaTable _referencedTable;
    private final List<SchemaColumn> _columns;

    public JdbcSchemaForeignKey(String fkName, SchemaTable referencedTable, List<SchemaColumn> columns) {
        this._referencedTable = referencedTable;
        this._columns = columns;
        this._name = this.assignName();
    }

    private String assignName() {
        return this._columns.size() == 1 ? this.removeId(this._columns.get(0).getName()) : this._referencedTable.getName() + "_ref";
    }

    private String removeId(String name) {
        if (name.toLowerCase().endsWith("_id")) {
            name = name.substring(0, name.length() - "_id".length()) + "_ref";
        }
        return name;
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public SchemaTable getReferencedTable() {
        return this._referencedTable;
    }

    @Override
    public List<SchemaColumn> getColumns() {
        return this._columns;
    }
}

