/*
 * Decompiled with CFR 0.152.
 */
package manifold.sql.schema.jdbc;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import manifold.sql.schema.api.SchemaColumn;
import manifold.sql.schema.api.SchemaForeignKey;
import manifold.sql.schema.api.SchemaTable;
import manifold.sql.schema.jdbc.JdbcForeignKeyMetadata;
import manifold.sql.schema.jdbc.JdbcSchema;
import manifold.sql.schema.jdbc.JdbcSchemaColumn;

public class JdbcSchemaTable
implements SchemaTable {
    private final JdbcSchema _schema;
    private final String _name;
    private final String _description;
    private final SchemaTable.Kind _kind;
    private final Map<String, SchemaColumn> _columns;
    private final JdbcSchemaColumn _nonNullUniqueId;
    private final ArrayList<SchemaColumn> _primaryKeys;
    private final Map<String, List<SchemaColumn>> _nonNullUniqueKeys;
    private final JdbcForeignKeyMetadata _foreignKeyData;
    private Map<SchemaTable, List<SchemaForeignKey>> _foreignKeys;

    public JdbcSchemaTable(JdbcSchema owner, DatabaseMetaData metaData, ResultSet resultSet) throws SQLException {
        this._schema = owner;
        this._name = resultSet.getString("TABLE_NAME");
        this._description = resultSet.getString("REMARKS");
        this._kind = SchemaTable.Kind.get(resultSet.getString("TABLE_TYPE"));
        if (this._kind == null) {
            throw new IllegalStateException("Unexpected table kind for: " + this._name);
        }
        ArrayList<String> primaryKey = new ArrayList<String>();
        String catalogName = this._schema.getDbConfig().getCatalogName();
        String schemaName = this._schema.getName();
        try (ResultSet primaryKeys = metaData.getPrimaryKeys(catalogName, schemaName, this._name);){
            while (primaryKeys.next()) {
                String columnName = primaryKeys.getString("COLUMN_NAME");
                primaryKey.add(columnName);
            }
        }
        LinkedHashMap<String, Set<String>> uniqueKeys = new LinkedHashMap<String, Set<String>>();
        try (ResultSet indexInfo = metaData.getIndexInfo(catalogName, schemaName, this._name, true, true);){
            while (indexInfo.next()) {
                String indexName = indexInfo.getString("INDEX_NAME");
                uniqueKeys.computeIfAbsent(indexName, __ -> new LinkedHashSet()).add(indexInfo.getString("COLUMN_NAME"));
            }
        }
        var9_9 = null;
        try (ResultSet foreignKeys = metaData.getImportedKeys(catalogName, schemaName, this._name);){
            ArrayList<JdbcForeignKeyMetadata.KeyPart> keyParts = new ArrayList<JdbcForeignKeyMetadata.KeyPart>();
            while (foreignKeys.next()) {
                String fkName = foreignKeys.getString("FK_NAME");
                String fkColumnName = foreignKeys.getString("FKCOLUMN_NAME");
                String pkColumnName = foreignKeys.getString("PKCOLUMN_NAME");
                String pkTableName = foreignKeys.getString("PKTABLE_NAME");
                keyParts.add(new JdbcForeignKeyMetadata.KeyPart(fkName, fkColumnName, pkColumnName, pkTableName));
            }
            this._foreignKeyData = new JdbcForeignKeyMetadata(this, keyParts);
        }
        catch (Throwable keyParts) {
            var9_9 = keyParts;
            throw keyParts;
        }
        this._columns = new LinkedHashMap<String, SchemaColumn>();
        this._primaryKeys = new ArrayList();
        this._nonNullUniqueKeys = new LinkedHashMap<String, List<SchemaColumn>>();
        var9_9 = null;
        try (ResultSet colResults = metaData.getColumns(catalogName, schemaName, this._name, null);){
            int i = 0;
            JdbcSchemaColumn id = null;
            while (colResults.next()) {
                JdbcSchemaColumn col = new JdbcSchemaColumn(++i, this, colResults, primaryKey, uniqueKeys);
                this._columns.put(col.getName(), col);
                if (col.isNonNullUniqueId() && (id == null || id.isPrimaryKeyPart())) {
                    id = col;
                }
                if (col.isPrimaryKeyPart()) {
                    this._primaryKeys.add(col);
                }
                this.buildNonNullUniqueKeys(col);
            }
            this._nonNullUniqueId = id;
        }
        catch (Throwable throwable) {
            var9_9 = throwable;
            throw throwable;
        }
    }

    private void buildNonNullUniqueKeys(JdbcSchemaColumn col) {
        String nonNullUniqueKeyName = col.getNonNullUniqueKeyName();
        if (nonNullUniqueKeyName != null) {
            this._nonNullUniqueKeys.computeIfAbsent(nonNullUniqueKeyName, __ -> new ArrayList()).add(col);
        }
        HashSet<String> removeKeys = new HashSet<String>();
        for (String keyName : this._nonNullUniqueKeys.keySet()) {
            List<SchemaColumn> cols = this._nonNullUniqueKeys.get(keyName);
            for (SchemaColumn schemaColumn : cols) {
                if (!schemaColumn.isNullable()) continue;
                removeKeys.add(keyName);
                break;
            }
            if (removeKeys.contains(keyName) || !cols.stream().allMatch(c -> c.isPrimaryKeyPart())) continue;
            removeKeys.add(keyName);
        }
        removeKeys.forEach(key -> this._nonNullUniqueKeys.remove(key));
    }

    @Override
    public JdbcSchema getSchema() {
        return this._schema;
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public SchemaTable.Kind getKind() {
        return this._kind;
    }

    @Override
    public Map<String, SchemaColumn> getColumns() {
        return this._columns;
    }

    @Override
    public SchemaColumn getColumn(String columnName) {
        return this._columns.get(columnName);
    }

    @Override
    public JdbcSchemaColumn getId() {
        return this._nonNullUniqueId;
    }

    @Override
    public Map<SchemaTable, List<SchemaForeignKey>> getForeignKeys() {
        return this._foreignKeys;
    }

    @Override
    public List<SchemaColumn> getPrimaryKey() {
        return this._primaryKeys;
    }

    @Override
    public Map<String, List<SchemaColumn>> getNonNullUniqueKeys() {
        return this._nonNullUniqueKeys;
    }

    @Override
    public String getDescription() {
        return this._description;
    }

    @Override
    public void resolve() {
        this._foreignKeys = this._foreignKeyData.resolve(this._schema);
    }

    @Override
    public List<SchemaColumn> getNonNullColumns() {
        return this.getColumns().values().stream().filter(c -> !c.isNullable()).collect(Collectors.toList());
    }
}

