/*
 * Decompiled with CFR 0.152.
 */
package manifold.sql.schema.type;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.tools.DiagnosticListener;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import manifold.api.gen.AbstractSrcClass;
import manifold.api.gen.AbstractSrcMethod;
import manifold.api.gen.SrcAnnotated;
import manifold.api.gen.SrcAnnotationExpression;
import manifold.api.gen.SrcField;
import manifold.api.gen.SrcGetProperty;
import manifold.api.gen.SrcLinkedClass;
import manifold.api.gen.SrcMethod;
import manifold.api.gen.SrcSetProperty;
import manifold.api.gen.SrcType;
import manifold.api.host.IModule;
import manifold.json.rt.api.DataBindings;
import manifold.rt.api.ActualName;
import manifold.rt.api.Bindings;
import manifold.rt.api.DisableStringLiteralTemplates;
import manifold.rt.api.util.ManIdentifierUtil;
import manifold.rt.api.util.Pair;
import manifold.sql.api.Column;
import manifold.sql.rt.api.BasicTxBindings;
import manifold.sql.rt.api.CrudProvider;
import manifold.sql.rt.api.OperableTxScope;
import manifold.sql.rt.api.QueryContext;
import manifold.sql.rt.api.SchemaBuilder;
import manifold.sql.rt.api.SchemaType;
import manifold.sql.rt.api.TableInfo;
import manifold.sql.rt.api.TableRow;
import manifold.sql.rt.api.TxBindings;
import manifold.sql.rt.api.TxScope;
import manifold.sql.schema.api.Schema;
import manifold.sql.schema.api.SchemaColumn;
import manifold.sql.schema.api.SchemaForeignKey;
import manifold.sql.schema.api.SchemaTable;
import manifold.sql.schema.type.SchemaModel;
import manifold.util.concurrent.LocklessLazyVar;

class SchemaParentType {
    private final SchemaModel _model;

    SchemaParentType(SchemaModel model) {
        this._model = model;
    }

    private String getFqn() {
        return this._model.getFqn();
    }

    boolean hasChild(String childName) {
        return this.getSchema() != null && this.getSchema().hasTable(childName);
    }

    private Schema getSchema() {
        return this._model.getSchema();
    }

    SchemaTable getChild(String childName) {
        return this.getSchema() == null ? null : this.getSchema().getTable(childName);
    }

    void render(StringBuilder sb, JavaFileManager.Location location, IModule module, DiagnosticListener<JavaFileObject> errorHandler) {
        SrcLinkedClass srcClass = (SrcLinkedClass)((SrcLinkedClass)((SrcLinkedClass)new SrcLinkedClass(this.getFqn(), AbstractSrcClass.Kind.Class, this._model.getFile(), location, module, errorHandler).addAnnotation(new SrcAnnotationExpression(DisableStringLiteralTemplates.class.getSimpleName()))).modifiers(1L)).addInterface(SchemaType.class);
        this.addImports(srcClass);
        this.addInnerTypes(srcClass);
        this.addFkColAssignMethod(srcClass);
        srcClass.render(sb, 0);
    }

    private void addInnerTypes(SrcLinkedClass srcClass) {
        if (this.getSchema() == null) {
            return;
        }
        for (SchemaTable type : this.getSchema().getTables().values()) {
            this.addInnerObjectType(type, srcClass);
        }
    }

    private void addInnerObjectType(SchemaTable table, SrcLinkedClass enclosingType) {
        String identifier = this.getSchema().getJavaTypeName(table.getName());
        String fqn = this.getFqn() + '.' + identifier;
        SrcLinkedClass srcClass = (SrcLinkedClass)((SrcLinkedClass)new SrcLinkedClass(fqn, (AbstractSrcClass)enclosingType, AbstractSrcClass.Kind.Interface).addInterface(TableRow.class.getSimpleName())).modifiers(1L);
        SrcLinkedClass.addActualNameAnnotation((SrcAnnotated)srcClass, (String)table.getName(), (boolean)false);
        this.addCreateMethod(srcClass, table);
        this.addReadMethod(srcClass, table);
        this.addDeleteMethod(srcClass);
        this.addBuilderType(srcClass, table);
        this.addBuilderMethod(srcClass, table);
        this.addTableInfoMethod(srcClass, table);
        this.addProperties(table, srcClass);
        enclosingType.addInnerClass((AbstractSrcClass)srcClass);
    }

    private void addProperties(SchemaTable table, SrcLinkedClass srcClass) {
        for (Map.Entry<SchemaTable, List<SchemaForeignKey>> entry : table.getForeignKeys().entrySet()) {
            List<SchemaForeignKey> fk = entry.getValue();
            for (SchemaForeignKey sfk : fk) {
                this.addFkProperty(srcClass, sfk);
            }
        }
        for (SchemaColumn col : table.getColumns().values()) {
            if (col.getForeignKey() != null) continue;
            this.addProperty(srcClass, col);
        }
    }

    private void addTableInfoMethod(SrcLinkedClass srcClass, SchemaTable table) {
        SrcField tableInfoField = new SrcField("myTableInfo", new SrcType(LocklessLazyVar.class).addTypeParam(TableInfo.class));
        StringBuilder sb = new StringBuilder("LocklessLazyVar.make(() -> {\n");
        sb.append("      Map<String, Integer> allCols = new LinkedHashMap<>();\n");
        for (Map.Entry<String, SchemaColumn> entry : table.getColumns().entrySet()) {
            String colName = entry.getKey();
            int jdbcType = entry.getValue().getJdbcType();
            sb.append("      allCols.put(\"" + colName + "\", " + jdbcType + ");\n");
        }
        sb.append("      Set<String> pkCols = new HashSet<>();\n");
        for (SchemaColumn schemaColumn : table.getPrimaryKey()) {
            String pkColName = schemaColumn.getName();
            sb.append("      pkCols.add(\"" + pkColName + "\");\n\n");
        }
        sb.append("      Set<String> ukCols = new HashSet<>();\n");
        Iterator<Object> iterator = table.getNonNullUniqueKeys().entrySet().iterator();
        if (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            for (SchemaColumn ukCol : (List)entry.getValue()) {
                String ukColName = ukCol.getName();
                sb.append("      ukCols.add(\"" + ukColName + "\");\n\n");
            }
        }
        String ddlTableName = table.getName();
        sb.append("      return new TableInfo(\"" + ddlTableName + "\", pkCols, ukCols, allCols);\n");
        sb.append("    });\n");
        tableInfoField.initializer(sb.toString());
        srcClass.addField(tableInfoField);
        SrcMethod srcMethod = (SrcMethod)((SrcMethod)((SrcMethod)new SrcMethod((AbstractSrcClass)srcClass).modifiers(0x80000000000L)).name("tableInfo")).returns(TableInfo.class);
        srcMethod.body("return myTableInfo.get();");
        srcClass.addMethod((AbstractSrcMethod)srcMethod);
    }

    private void addBuilderMethod(SrcLinkedClass srcClass, SchemaTable table) {
        SrcMethod method = (SrcMethod)((SrcMethod)((SrcMethod)new SrcMethod((AbstractSrcClass)srcClass).modifiers(8L)).name("builder")).returns(new SrcType("Builder"));
        this.addRequiredParameters(srcClass, table, (AbstractSrcMethod)method);
        srcClass.addMethod((AbstractSrcMethod)method);
        StringBuilder sb = new StringBuilder();
        sb.append("return new Builder() {\n");
        sb.append("        Bindings _bindings = new DataBindings(new ConcurrentHashMap<>());\n");
        sb.append("        {\n");
        this.initFromParameters(table, sb, "_bindings");
        sb.append("        }\n");
        sb.append("        @Override public Bindings getBindings() { return _bindings; }\n");
        sb.append("      };");
        method.body(sb.toString());
    }

    private void addCreateMethod(SrcLinkedClass srcClass, SchemaTable table) {
        String tableName = this.getTableFqn(table);
        SrcMethod method = (SrcMethod)((SrcMethod)((SrcMethod)((SrcMethod)new SrcMethod((AbstractSrcClass)srcClass).modifiers(8L)).name("create")).returns(new SrcType(tableName))).addParam("txScope", TxScope.class);
        this.addRequiredParameters(srcClass, table, (AbstractSrcMethod)method);
        srcClass.addMethod((AbstractSrcMethod)method);
        StringBuilder sb = new StringBuilder();
        sb.append("DataBindings args = new DataBindings(new ConcurrentHashMap<>());\n");
        this.initFromParameters(table, sb, "args");
        sb.append("      TxBindings bindings = new BasicTxBindings(txScope, TxKind.Insert, args);\n");
        sb.append("      " + tableName + " tableRow = new " + tableName + "() { @Override public TxBindings getBindings() { return bindings; } };\n");
        sb.append("      tableRow.getBindings().setOwner(tableRow);\n");
        sb.append("      ((OperableTxScope)txScope).addRow(tableRow);\n");
        sb.append("      return tableRow;");
        method.body(sb.toString());
    }

    private void initFromParameters(SchemaTable table, StringBuilder sb, String bindingsVar) {
        HashSet<SchemaColumn> fkCovered = new HashSet<SchemaColumn>();
        for (Map.Entry<SchemaTable, List<SchemaForeignKey>> entry : table.getForeignKeys().entrySet()) {
            List<SchemaForeignKey> fk = entry.getValue();
            for (SchemaForeignKey sfk : fk) {
                List<SchemaColumn> fkCols = sfk.getColumns();
                if (!fkCols.stream().anyMatch(c -> this.isRequired((SchemaColumn)c))) continue;
                String fkParamName = ManIdentifierUtil.makePascalCaseIdentifier((String)sfk.getName(), (boolean)false);
                for (SchemaColumn fkCol : fkCols) {
                    String colName = fkCol.getName();
                    String keyColName = fkCol.getForeignKey().getName();
                    sb.append("assignFkBindingValues(" + fkParamName + ", \"" + fkParamName + "\", \"" + keyColName + "\", \"" + colName + "\", " + bindingsVar + ");");
                }
                fkCovered.addAll(fkCols);
            }
        }
        for (SchemaColumn col : table.getColumns().values()) {
            if (!this.isRequired(col) || fkCovered.contains(col)) continue;
            String colName = col.getName();
            String paramName = ManIdentifierUtil.makePascalCaseIdentifier((String)col.getName(), (boolean)false);
            sb.append(bindingsVar + ".put(\"" + colName + "\", " + paramName + ");\n");
        }
    }

    private void addRequiredParameters(SrcLinkedClass owner, SchemaTable table, AbstractSrcMethod method) {
        HashSet<SchemaColumn> fkCovered = new HashSet<SchemaColumn>();
        for (Map.Entry<SchemaTable, List<SchemaForeignKey>> entry : table.getForeignKeys().entrySet()) {
            List<SchemaForeignKey> fk = entry.getValue();
            for (SchemaForeignKey sfk : fk) {
                List<SchemaColumn> fkCols = sfk.getColumns();
                if (!fkCols.stream().anyMatch(c -> this.isRequired((SchemaColumn)c))) continue;
                fkCovered.addAll(fkCols);
                String tableFqn = this.getTableFqn(sfk.getReferencedTable());
                SrcType srcType = new SrcType(tableFqn);
                method.addParam(ManIdentifierUtil.makePascalCaseIdentifier((String)sfk.getName(), (boolean)false), srcType);
            }
        }
        for (SchemaColumn col : table.getColumns().values()) {
            if (!this.isRequired(col) || fkCovered.contains(col)) continue;
            SrcType srcType = this.makeSrcType(owner, col.getType(), false, true);
            method.addParam(ManIdentifierUtil.makePascalCaseIdentifier((String)col.getName(), (boolean)false), srcType);
        }
    }

    private void addBuilderType(SrcLinkedClass enclosingType, SchemaTable table) {
        String fqn = enclosingType.getName() + ".Builder";
        SrcLinkedClass srcInterface = (SrcLinkedClass)new SrcLinkedClass(fqn, (AbstractSrcClass)enclosingType, AbstractSrcClass.Kind.Interface).addInterface(new SrcType(SchemaBuilder.class.getSimpleName()).addTypeParam(this.getTableFqn(table)));
        enclosingType.addInnerClass((AbstractSrcClass)srcInterface);
        this.addWithMethods(srcInterface, table);
        this.addBuildMethod(enclosingType, srcInterface, table);
    }

    private void addBuildMethod(SrcLinkedClass enclosingType, SrcLinkedClass srcInterface, SchemaTable table) {
        String tableName = this.getTableFqn(table);
        SrcMethod method = (SrcMethod)((SrcMethod)((SrcMethod)((SrcMethod)new SrcMethod((AbstractSrcClass)srcInterface).modifiers(0x80000000000L)).name("build")).addParam("txScope", TxScope.class)).returns(new SrcType(tableName));
        srcInterface.addMethod((AbstractSrcMethod)method);
        method.body("BasicTxBindings bindings = new BasicTxBindings(txScope, TxKind.Insert, Builder.this.getBindings());\n" + tableName + " tableRow = new " + tableName + "() { @Override public TxBindings getBindings() { return bindings; } };\ntableRow.getBindings().setOwner(tableRow);\n((OperableTxScope)txScope).addRow(tableRow);\nreturn tableRow;");
    }

    private void addWithMethods(SrcLinkedClass srcClass, SchemaTable table) {
        for (SchemaColumn col : table.getColumns().values()) {
            if (this.isRequired(col)) continue;
            this.addWithMethod(srcClass, col, table);
        }
    }

    private void addWithMethod(SrcLinkedClass srcClass, SchemaColumn col, SchemaTable table) {
        String actualName = col.getName();
        SrcType type = this.makeSrcType(srcClass, col.getType(), false, true);
        String propName = ManIdentifierUtil.makePascalCaseIdentifier((String)actualName, (boolean)true);
        SrcMethod withMethod = (SrcMethod)((SrcMethod)((SrcMethod)((SrcMethod)new SrcMethod().modifiers(0x80000000000L)).name("with" + propName)).addParam("$value", type)).returns(new SrcType(srcClass.getSimpleName()));
        SrcLinkedClass.addActualNameAnnotation((SrcAnnotated)withMethod, (String)actualName, (boolean)true);
        withMethod.body("getBindings().put(\"" + actualName + "\", " + '$' + "value); return this;");
        srcClass.addMethod((AbstractSrcMethod)withMethod);
    }

    private boolean isRequired(SchemaColumn col) {
        return !col.isNullable() && !col.isGenerated() && !col.isAutoIncrement() && col.getDefaultValue() == null;
    }

    private void addImports(SrcLinkedClass srcClass) {
        srcClass.addImport(Bindings.class);
        srcClass.addImport(TxBindings.class);
        srcClass.addImport(OperableTxScope.class);
        srcClass.addImport(BasicTxBindings.class);
        srcClass.addImport(BasicTxBindings.TxKind.class);
        srcClass.addImport(DataBindings.class);
        srcClass.addImport(TableRow.class);
        srcClass.addImport(TableInfo.class);
        srcClass.addImport(SchemaBuilder.class);
        srcClass.addImport(QueryContext.class);
        srcClass.addImport(CrudProvider.class);
        srcClass.addImport(ConcurrentHashMap.class);
        srcClass.addImport(LinkedHashMap.class);
        srcClass.addImport(Pair.class);
        srcClass.addImport(Map.class);
        srcClass.addImport(Set.class);
        srcClass.addImport(HashSet.class);
        srcClass.addImport(LocklessLazyVar.class);
        srcClass.addImport(ActualName.class);
        srcClass.addImport(DisableStringLiteralTemplates.class);
    }

    private void addFkProperty(SrcLinkedClass srcClass, SchemaForeignKey sfk) {
        SchemaTable table = sfk.getReferencedTable();
        String tableFqn = this.getTableFqn(table);
        SrcType type = new SrcType(tableFqn);
        String name = sfk.getName();
        String propName = ManIdentifierUtil.makePascalCaseIdentifier((String)name, (boolean)true);
        SrcMethod fkFetchMethod = (SrcMethod)((SrcMethod)((SrcMethod)new SrcMethod((AbstractSrcClass)srcClass).name("get" + propName)).modifiers(0x80000000000L)).returns(type);
        StringBuilder sb = new StringBuilder();
        sb.append("DataBindings paramBindings = new DataBindings(new ConcurrentHashMap<>());\n");
        for (SchemaColumn col : sfk.getColumns()) {
            SchemaColumn referencedCol = col.getForeignKey();
            sb.append("    paramBindings.put(\"" + referencedCol.getName() + "\", getBindings().get(\"" + col.getName() + "\"));\n");
        }
        String jdbcParamTypes = this.getJdbcParamTypes(sfk.getColumns());
        String configName = this._model.getDbConfig().getName();
        sb.append("    return CrudProvider.instance().read(new QueryContext<" + tableFqn + ">(getBindings().getTxScope(), " + tableFqn + ".class, \"" + table.getName() + "\", " + jdbcParamTypes + ", paramBindings, \"" + configName + "\", rowBindings -> new " + tableFqn + "() {public TxBindings getBindings() { return rowBindings; }}));");
        fkFetchMethod.body(sb.toString());
        SrcLinkedClass.addActualNameAnnotation((SrcAnnotated)fkFetchMethod, (String)name, (boolean)true);
        srcClass.addMethod((AbstractSrcMethod)fkFetchMethod);
        SrcMethod fkSetter = (SrcMethod)((SrcMethod)((SrcMethod)new SrcMethod((AbstractSrcClass)srcClass).modifiers(0x80000000000L)).name("set" + propName)).addParam("ref", new SrcType(tableFqn));
        for (SchemaColumn fkCol : sfk.getColumns()) {
            String colName = fkCol.getName();
            String keyColName = fkCol.getForeignKey().getName();
            fkSetter.body("assignFkBindingValues(ref, \"" + propName + "\", \"" + keyColName + "\", \"" + colName + "\", getBindings());");
        }
        SrcLinkedClass.addActualNameAnnotation((SrcAnnotated)fkSetter, (String)name, (boolean)true);
        srcClass.addMethod((AbstractSrcMethod)fkSetter);
    }

    private void addFkColAssignMethod(SrcLinkedClass srcClass) {
        SrcMethod method = (SrcMethod)((SrcMethod)((SrcMethod)((SrcMethod)((SrcMethod)((SrcMethod)((SrcMethod)new SrcMethod((AbstractSrcClass)srcClass).modifiers(10L)).name("assignFkBindingValues")).addParam("ref", new SrcType(TableRow.class))).addParam("propName", new SrcType(String.class))).addParam("keyColName", new SrcType(String.class))).addParam("colName", new SrcType(String.class))).addParam("Bdings", new SrcType(Bindings.class));
        method.body("if(ref == null) throw new NullPointerException(\"Expecting non-null value for: \" + propName );\nObject kyColValue = ref.getBindings().get(keyColName);\nBdings.put(colName, kyColValue != null ? kyColValue : new Pair<>(ref, keyColName));");
        srcClass.addMethod((AbstractSrcMethod)method);
    }

    private void addProperty(SrcLinkedClass srcInterface, SchemaColumn col) {
        Class<?> type = col.getType();
        String name = col.getName();
        SrcType propType = this.makeSrcType(srcInterface, type, false);
        String propName = ManIdentifierUtil.makePascalCaseIdentifier((String)name, (boolean)true);
        String colName = ManIdentifierUtil.makeIdentifier((String)name);
        SrcGetProperty getter = new SrcGetProperty(propName, propType);
        getter.modifiers(0x80000000000L);
        StringBuilder retType = new StringBuilder();
        propType.render(retType, 0, false);
        getter.body("return (" + retType + ")getBindings().get(\"" + colName + "\");");
        SrcLinkedClass.addActualNameAnnotation((SrcAnnotated)getter, (String)name, (boolean)true);
        srcInterface.addGetProperty(getter);
        if (!col.isGenerated() && !col.isAutoIncrement()) {
            SrcSetProperty setter = (SrcSetProperty)new SrcSetProperty(propName, propType).modifiers(0x80000000000L);
            setter.body("getBindings().put(\"" + colName + "\", " + '$' + "value);");
            SrcLinkedClass.addActualNameAnnotation((SrcAnnotated)setter, (String)name, (boolean)true);
            srcInterface.addSetProperty(setter);
        }
    }

    private void addReadMethod(SrcLinkedClass srcClass, SchemaTable table) {
        String tableFqn = this.getTableFqn(table);
        SrcMethod method = (SrcMethod)((SrcMethod)((SrcMethod)((SrcMethod)new SrcMethod((AbstractSrcClass)srcClass).modifiers(8L)).name("read")).returns(new SrcType(tableFqn))).addParam("txScope", TxScope.class);
        List<SchemaColumn> whereCols = this.addSelectParameters(srcClass, table, (AbstractSrcMethod)method);
        if (whereCols.isEmpty()) {
            return;
        }
        String jdbcParamTypes = this.getJdbcParamTypes(whereCols);
        String configName = this._model.getDbConfig().getName();
        StringBuilder sb = new StringBuilder();
        sb.append("DataBindings paramBindings = new DataBindings(new ConcurrentHashMap<>());\n");
        for (SchemaColumn col : whereCols) {
            String paramName = ManIdentifierUtil.makePascalCaseIdentifier((String)col.getName(), (boolean)false);
            sb.append("    paramBindings.put(\"" + col.getName() + "\", " + paramName + ");\n");
        }
        sb.append("    return CrudProvider.instance().read(new QueryContext<" + tableFqn + ">(txScope, " + tableFqn + ".class,\n\"" + table.getName() + "\", " + jdbcParamTypes + ", paramBindings, \"" + configName + "\",\nrowBindings -> new " + tableFqn + "() {public TxBindings getBindings() { return rowBindings; }}));");
        method.body(sb.toString());
        srcClass.addMethod((AbstractSrcMethod)method);
    }

    private List<SchemaColumn> addSelectParameters(SrcLinkedClass owner, SchemaTable table, AbstractSrcMethod method) {
        List<SchemaColumn> pk = table.getPrimaryKey();
        if (!pk.isEmpty()) {
            for (SchemaColumn col : pk) {
                SrcType srcType = this.makeSrcType(owner, col.getType(), false, true);
                method.addParam(ManIdentifierUtil.makePascalCaseIdentifier((String)col.getName(), (boolean)false), srcType);
            }
            return pk;
        }
        Iterator<Map.Entry<String, List<SchemaColumn>>> iterator = table.getNonNullUniqueKeys().entrySet().iterator();
        if (iterator.hasNext()) {
            Map.Entry<String, List<SchemaColumn>> entry = iterator.next();
            for (SchemaColumn col : entry.getValue()) {
                SrcType srcType = this.makeSrcType(owner, col.getType(), false, true);
                method.addParam(ManIdentifierUtil.makePascalCaseIdentifier((String)col.getName(), (boolean)false), srcType);
            }
            return entry.getValue();
        }
        return Collections.emptyList();
    }

    private void addDeleteMethod(SrcLinkedClass srcClass) {
        SrcMethod method = (SrcMethod)((SrcMethod)((SrcMethod)new SrcMethod((AbstractSrcClass)srcClass).modifiers(0x80000000000L)).name("delete")).addParam("delete", Boolean.TYPE);
        method.body("getBindings().setDelete(delete);");
        srcClass.addMethod((AbstractSrcMethod)method);
    }

    private void addOneToManyFetcher(SrcLinkedClass srcClass, SchemaForeignKey fkToThis) {
    }

    private String getJdbcParamTypes(List<SchemaColumn> parameters) {
        StringBuilder sb = new StringBuilder("new int[]{");
        for (int i = 0; i < parameters.size(); ++i) {
            Column p = parameters.get(i);
            if (i > 0) {
                sb.append(",");
            }
            sb.append(p.getJdbcType());
        }
        return sb.append("}").toString();
    }

    private String getTableFqn(SchemaTable table) {
        String configName = table.getSchema().getDbConfig().getName();
        return configName + "." + this.getTableSimpleTypeName(table);
    }

    private String getTableSimpleTypeName(SchemaTable table) {
        return table.getSchema().getJavaTypeName(table.getName());
    }

    private SrcType makeSrcType(SrcLinkedClass owner, Class<?> type, boolean typeParam) {
        return this.makeSrcType(owner, type, typeParam, false);
    }

    private SrcType makeSrcType(SrcLinkedClass owner, Class<?> type, boolean typeParam, boolean isParameter) {
        String typeName = this.getJavaName(type);
        SrcType srcType = new SrcType(typeName);
        if (!typeParam) {
            srcType.setPrimitive(type.isPrimitive());
        }
        return srcType;
    }

    private String getJavaName(Class<?> cls) {
        if (cls == String.class) {
            return String.class.getSimpleName();
        }
        return cls.getTypeName();
    }
}

