/*
 * Decompiled with CFR 0.152.
 */
package manifold.sql.schema.type;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticListener;
import javax.tools.JavaFileObject;
import manifold.api.fs.IFile;
import manifold.api.fs.IFileFragment;
import manifold.api.type.AbstractSingleFileModel;
import manifold.api.util.JavacDiagnostic;
import manifold.api.util.cache.FqnCache;
import manifold.internal.javac.IIssue;
import manifold.internal.javac.SourceJavaFileObject;
import manifold.json.rt.Json;
import manifold.rt.api.Bindings;
import manifold.rt.api.util.StreamUtil;
import manifold.sql.rt.api.ConnectionProvider;
import manifold.sql.rt.api.DbConfig;
import manifold.sql.rt.api.DbLocationProvider;
import manifold.sql.rt.connection.DbConfigImpl;
import manifold.sql.schema.api.Schema;
import manifold.sql.schema.api.SchemaProvider;
import manifold.sql.schema.api.SchemaTable;
import manifold.sql.schema.type.SchemaIssueContainer;
import manifold.sql.schema.type.SchemaManifold;
import manifold.sql.schema.type.SchemaParentType;
import manifold.util.concurrent.LocklessLazyVar;

public class SchemaModel
extends AbstractSingleFileModel {
    private final SchemaManifold _schemaManifold;
    private LocklessLazyVar<Schema> _schema;
    private DbConfigImpl _dbConfig;
    private SchemaParentType _type;
    private SchemaIssueContainer _issues;

    public SchemaModel(SchemaManifold schemaManifold, String fqn, Set<IFile> files) {
        super(schemaManifold.getModule().getHost(), fqn, files);
        this._schemaManifold = schemaManifold;
        this.init();
    }

    private void init() {
        this._issues = null;
        this._schema = LocklessLazyVar.make(() -> this.loadSchema());
        this._type = new SchemaParentType(this);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Schema loadSchema() {
        try (InputStreamReader reader = new InputStreamReader(this.getFile().openInputStream());){
            Bindings bindings = (Bindings)Json.fromJson((String)StreamUtil.getContent((Reader)reader));
            bindings.put((Object)"name", (Object)this.getFile().getBaseName());
            bindings.put((Object)"path", (Object)this.getFile().getPath().getFileSystemPathString());
            Function<String, FqnCache> resByExt = ext -> this._schemaManifold.getModule().getPathCache().getExtensionCache(ext);
            this._dbConfig = new DbConfigImpl(resByExt, bindings, DbLocationProvider.Mode.CompileTime);
            this.validate();
            Iterator iterator = ((Set)SchemaProvider.PROVIDERS.get()).iterator();
            while (iterator.hasNext()) {
                SchemaProvider sp = (SchemaProvider)iterator.next();
                try {
                    Schema schema = sp.getSchema((DbConfig)this._dbConfig);
                    if (schema == null) continue;
                    Schema schema2 = schema;
                    return schema2;
                }
                catch (Exception e) {
                    this._issues = new SchemaIssueContainer(Collections.singletonList(e));
                }
            }
            return null;
        }
        catch (IOException e) {
            this._issues = new SchemaIssueContainer(Collections.singletonList(e));
        }
        return null;
    }

    private void validate() {
        String schemaPackage;
        this._issues = new SchemaIssueContainer();
        String url = this._dbConfig.getUrl();
        if (url == null || url.isEmpty()) {
            this._issues.addIssue(IIssue.Kind.Error, "Required \"url\" entry is missing from dbconfig: " + this.getFile().getName());
        }
        if ((schemaPackage = this._dbConfig.getSchemaPackage()) == null || schemaPackage.isEmpty()) {
            this._issues.addIssue(IIssue.Kind.Error, "Required \"schemaPackage\" entry is missing from dbconfig: " + this.getFile().getName());
        }
    }

    DbConfig getDbConfig() {
        return this._dbConfig;
    }

    Schema getSchema() {
        return (Schema)this._schema.get();
    }

    SchemaParentType getType() {
        return this._type;
    }

    public void updateFile(IFile file) {
        super.updateFile(file);
        ConnectionProvider.findFirst().closeDataSource((DbConfig)this._dbConfig);
        this.init();
    }

    SchemaTable getTable(String simpleName) {
        Schema schema = this.getSchema();
        return schema.getTable(schema.getOriginalName(simpleName));
    }

    void report(DiagnosticListener<JavaFileObject> errorHandler) {
        if (errorHandler == null) {
            return;
        }
        List<IIssue> issues = this._issues.getIssues();
        if (!issues.isEmpty()) {
            SourceJavaFileObject file = new SourceJavaFileObject(this.getFile().toURI());
            for (IIssue issue : issues) {
                int offset = issue.getStartOffset();
                if (this.getFile() instanceof IFileFragment) {
                    offset += ((IFileFragment)this.getFile()).getOffset();
                }
                Diagnostic.Kind kind = issue.getKind() == IIssue.Kind.Error ? Diagnostic.Kind.ERROR : Diagnostic.Kind.WARNING;
                errorHandler.report((Diagnostic<JavaFileObject>)new JavacDiagnostic((JavaFileObject)file, kind, (long)offset, (long)issue.getLine(), (long)issue.getColumn(), issue.getMessage()));
            }
        }
    }

    public SchemaIssueContainer getIssueContainer() {
        return this._issues;
    }
}

