/*
 * Decompiled with CFR 0.152.
 */
package manifold.sql.schema.jdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import manifold.sql.schema.api.SchemaColumn;
import manifold.sql.schema.jdbc.JdbcSchemaTable;
import manifold.sql.schema.jdbc.oneoff.SqliteTypeMapping;

public class JdbcSchemaColumn
implements SchemaColumn {
    private final JdbcSchemaTable _table;
    private final int _position;
    private final String _name;
    private final int _jdbcType;
    private final boolean _isNullable;
    private final boolean _isAutoIncrement;
    private final boolean _isGenerated;
    private final boolean _isPrimaryKeyPart;
    private final String _nonNullUniqueKeyName;
    private final boolean _isNonNullUniqueId;
    private final String _defaultValue;
    private final int _decimalDigits;
    private final int _numPrecRadix;
    private JdbcSchemaColumn _fk;
    private final int _size;

    public JdbcSchemaColumn(int colIndex, JdbcSchemaTable jdbcSchemaTable, ResultSet rs, List<String> primaryKey, Map<String, Set<String>> uniqueKeys) throws SQLException {
        this._position = colIndex;
        this._table = jdbcSchemaTable;
        this._name = rs.getString("COLUMN_NAME");
        this._jdbcType = this.oneOffCorrections(rs.getInt("DATA_TYPE"), rs, this._table.getSchema().getDatabaseProductName());
        this._isNullable = rs.getInt("NULLABLE") == 1;
        this._isAutoIncrement = "YES".equals(rs.getString("IS_AUTOINCREMENT"));
        this._isGenerated = "YES".equals(rs.getString("IS_GENERATEDCOLUMN"));
        this._isPrimaryKeyPart = primaryKey.contains(this._name);
        this._nonNullUniqueKeyName = uniqueKeys.entrySet().stream().filter(e -> ((Set)e.getValue()).contains(this._name)).map(e -> (String)e.getKey()).findFirst().orElse(null);
        boolean isNonNullUniqueSoloKey = uniqueKeys.values().stream().anyMatch(cols -> cols.contains(this._name) && cols.size() == 1);
        this._isNonNullUniqueId = this._isPrimaryKeyPart && primaryKey.size() == 1 || isNonNullUniqueSoloKey;
        this._defaultValue = rs.getString("COLUMN_DEF");
        this._size = rs.getInt("COLUMN_SIZE");
        this._decimalDigits = rs.getInt("DECIMAL_DIGITS");
        this._numPrecRadix = rs.getInt("NUM_PREC_RADIX");
    }

    private int oneOffCorrections(int jdbcType, ResultSet rs, String productName) throws SQLException {
        Integer corrected = new SqliteTypeMapping().getJdbcType(productName, rs);
        return corrected != null ? corrected : jdbcType;
    }

    @Override
    public JdbcSchemaTable getTable() {
        return this._table;
    }

    public int getPosition() {
        return this._position;
    }

    @Override
    public String getName() {
        return this._name;
    }

    public boolean isNullable() {
        return this._isNullable;
    }

    @Override
    public int getJdbcType() {
        return this._jdbcType;
    }

    @Override
    public boolean isNonNullUniqueId() {
        return this._isNonNullUniqueId;
    }

    @Override
    public boolean isPrimaryKeyPart() {
        return this._isPrimaryKeyPart;
    }

    @Override
    public String getNonNullUniqueKeyName() {
        return this._nonNullUniqueKeyName;
    }

    @Override
    public boolean isAutoIncrement() {
        return this._isAutoIncrement;
    }

    @Override
    public boolean isGenerated() {
        return this._isGenerated;
    }

    @Override
    public String getDefaultValue() {
        return this._defaultValue;
    }

    @Override
    public JdbcSchemaColumn getForeignKey() {
        return this._fk;
    }

    void setForeignKey(JdbcSchemaColumn fk) {
        this._fk = fk;
    }

    public int getSize() {
        return this._size;
    }

    @Override
    public int getScale() {
        return this._decimalDigits;
    }

    @Override
    public int getNumPrecRadix() {
        return this._numPrecRadix;
    }
}

