/*
 * Decompiled with CFR 0.152.
 */
package manifold.sql.query.type;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import manifold.api.fs.IFile;
import manifold.api.host.IModule;
import manifold.api.util.cache.FqnCache;
import manifold.internal.javac.IIssue;
import manifold.sql.query.type.SqlIssue;
import manifold.sql.query.type.SqlScope;

public class SqlScopeFinder {
    private final IModule _module;

    SqlScopeFinder(IModule module) {
        this._module = module;
    }

    SqlScope findScope(IFile sqlFile) {
        SqlScope sqlScope = this.findScopes().stream().filter(scope -> scope.appliesTo(sqlFile)).findFirst().orElse(null);
        if (sqlScope != null) {
            return sqlScope;
        }
        if (SqlScope.isDefaultScopeApplicable(sqlFile)) {
            return this.findDefaultScope();
        }
        return null;
    }

    private SqlScope findDefaultScope() {
        Set<SqlScope> scopes = this.findScopes();
        if (scopes.size() == 1) {
            return (SqlScope)scopes.stream().findFirst().get();
        }
        for (SqlScope scope : scopes) {
            if (!scope.getDbconfig().isDefault()) continue;
            return scope;
        }
        return null;
    }

    private Set<SqlScope> findScopes() {
        FqnCache extensionCache = this._module.getPathCache().getExtensionCache("dbconfig");
        HashSet<SqlScope> scopes = new HashSet<SqlScope>();
        extensionCache.visitDepthFirst(file -> {
            if (file != null) {
                scopes.add(this.makeScope((IFile)file));
            }
            return true;
        });
        this.validate(scopes);
        return scopes;
    }

    private void validate(Set<SqlScope> scopes) {
        SqlScopeFinder.validateZeroOrOneDefaultScopes(scopes);
    }

    private static void validateZeroOrOneDefaultScopes(Set<SqlScope> scopes) {
        List defaultScopes = scopes.stream().filter(s -> s.getDbconfig().isDefault()).map(s -> s.getDbconfig().getName()).collect(Collectors.toList());
        if (defaultScopes.size() > 1) {
            StringBuilder defaultNamesList = new StringBuilder();
            for (String name : defaultScopes) {
                if (defaultNamesList.length() > 0) {
                    defaultNamesList.append(", ");
                }
                defaultNamesList.append(name);
            }
            for (SqlScope s2 : scopes) {
                s2.getIssues().add(new SqlIssue(IIssue.Kind.Warning, "Multiple default scopes found: " + defaultNamesList));
            }
        }
    }

    private SqlScope makeScope(IFile configFile) {
        return new SqlScope(this._module, configFile);
    }
}

