/*
 * Decompiled with CFR 0.152.
 */
package manifold.sql.query.type;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.tools.DiagnosticListener;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import manifold.api.fs.IFileFragment;
import manifold.api.gen.AbstractSrcClass;
import manifold.api.gen.AbstractSrcMethod;
import manifold.api.gen.SrcAnnotated;
import manifold.api.gen.SrcAnnotationExpression;
import manifold.api.gen.SrcGetProperty;
import manifold.api.gen.SrcLinkedClass;
import manifold.api.gen.SrcMethod;
import manifold.api.gen.SrcParameter;
import manifold.api.gen.SrcType;
import manifold.api.host.IModule;
import manifold.internal.javac.HostKind;
import manifold.internal.javac.IIssue;
import manifold.json.rt.api.DataBindings;
import manifold.rt.api.ActualName;
import manifold.rt.api.Bindings;
import manifold.rt.api.DisableStringLiteralTemplates;
import manifold.rt.api.FragmentValue;
import manifold.rt.api.util.ManClassUtil;
import manifold.rt.api.util.ManEscapeUtil;
import manifold.rt.api.util.ManIdentifierUtil;
import manifold.rt.api.util.Pair;
import manifold.sql.api.Column;
import manifold.sql.api.DataElement;
import manifold.sql.query.api.ForeignKeyQueryRef;
import manifold.sql.query.api.QueryColumn;
import manifold.sql.query.api.QueryParameter;
import manifold.sql.query.api.QueryTable;
import manifold.sql.query.type.SqlModel;
import manifold.sql.rt.api.BasicTxBindings;
import manifold.sql.rt.api.CrudProvider;
import manifold.sql.rt.api.DbConfig;
import manifold.sql.rt.api.Query;
import manifold.sql.rt.api.QueryContext;
import manifold.sql.rt.api.ResultRow;
import manifold.sql.rt.api.Runner;
import manifold.sql.rt.api.TxBindings;
import manifold.sql.rt.api.TxScope;
import manifold.sql.schema.api.SchemaColumn;
import manifold.sql.schema.api.SchemaTable;

class SqlParentType {
    private static final String ANONYMOUS_TYPE = "Anonymous_";
    private final SqlModel _model;
    private int _anonCount;

    SqlParentType(SqlModel model) {
        this._model = model;
    }

    private String getFqn() {
        return this._model.getFqn();
    }

    void render(StringBuilder sb, JavaFileManager.Location location, IModule module, DiagnosticListener<JavaFileObject> errorHandler) {
        String name = this.getQueryName();
        String identifier = SrcLinkedClass.makeIdentifier((String)name, (boolean)false);
        SrcLinkedClass srcClass = (SrcLinkedClass)((SrcLinkedClass)((SrcLinkedClass)new SrcLinkedClass(this.getFqn(), AbstractSrcClass.Kind.Interface, this._model.getFile(), location, module, errorHandler).addAnnotation(new SrcAnnotationExpression(DisableStringLiteralTemplates.class.getSimpleName()))).addInterface(new SrcType("Query"))).modifiers(1L);
        SrcLinkedClass.addActualNameAnnotation((SrcAnnotated)srcClass, (String)name, (boolean)false);
        this.addImports(srcClass);
        this.addFlatRowType(srcClass);
        this.addRunMethods(srcClass);
        this.addFragmentValueMethod(srcClass);
        srcClass.render(sb, 0);
    }

    private void addRunMethods(SrcLinkedClass srcClass) {
        String rowType;
        Pair<SchemaTable, List<QueryColumn>> selectedTable = this.getQuery().findSelectedTable();
        if (selectedTable != null && ((List)selectedTable.getSecond()).size() == this.getQuery().getColumns().size()) {
            SchemaTable table = (SchemaTable)selectedTable.getFirst();
            rowType = this.getTableFqn(table);
        } else {
            rowType = "Row";
            this.addRowType(srcClass);
        }
        this.addRunMethod(srcClass, "run", rowType);
    }

    private QueryTable getQuery() {
        return this._model.getQuery();
    }

    private void addFragmentValueMethod(SrcLinkedClass srcClass) {
        if (!(this._model.getFile() instanceof IFileFragment)) {
            return;
        }
        if (!this.isValueFragment(((IFileFragment)this._model.getFile()).getHostKind())) {
            return;
        }
        this.addValueMethodForOperation(srcClass);
    }

    private void addValueMethodForOperation(SrcLinkedClass srcClass) {
        srcClass.addAnnotation(new SrcAnnotationExpression(FragmentValue.class.getSimpleName()).addArgument("methodName", String.class, (Object)"fragmentValue").addArgument("type", String.class, (Object)this.getFqn()));
        String simpleName = srcClass.getSimpleName();
        SrcMethod valueMethod = (SrcMethod)((SrcMethod)((SrcMethod)((SrcMethod)new SrcMethod((AbstractSrcClass)srcClass).modifiers(8L)).name("fragmentValue")).returns(simpleName)).body("return new " + simpleName + "() {};");
        srcClass.addMethod((AbstractSrcMethod)valueMethod);
    }

    private String getQueryName() {
        if (this.getQuery() == null) {
            return ManClassUtil.getShortClassName((String)this.getFqn());
        }
        String name = this.getQuery().getName();
        return name == null || name.isEmpty() ? ANONYMOUS_TYPE + this._anonCount++ : name;
    }

    private void addRunMethod(SrcLinkedClass srcClass, String methodName, String rowType) {
        SrcMethod method = (SrcMethod)((SrcMethod)((SrcMethod)new SrcMethod((AbstractSrcClass)srcClass).name(methodName)).addParam("txScope", TxScope.class)).returns(new SrcType("Iterable<" + rowType + ">"));
        if (this._model.getFile() instanceof IFileFragment && this.isValueFragment(((IFileFragment)this._model.getFile()).getHostKind())) {
            method.modifiers(0x80000000000L);
        } else {
            method.modifiers(8L);
        }
        this.addRequiredParameters((AbstractSrcMethod)method);
        StringBuilder sb = new StringBuilder();
        sb.append("DataBindings paramBindings = new DataBindings(new ConcurrentHashMap<>());\n");
        int i = 0;
        for (SrcParameter param : method.getParameters()) {
            if (i++ == 0) continue;
            String paramName = SrcLinkedClass.makeIdentifier((String)param.getSimpleName(), (boolean)false);
            sb.append("    paramBindings.put(\"" + paramName + "\", " + paramName + ");\n");
        }
        String query = this.getQuery() == null ? "<errant query>" : this.getQuery().getQuerySource();
        query = ManEscapeUtil.escapeForJavaStringLiteral((String)query);
        String configName = this._model.getScope().getDbconfig().getName();
        String simpleName = srcClass.getSimpleName();
        String jdbcParamTypes = this.getJdbcParamTypes();
        sb.append("    return new Runner<" + rowType + ">(new QueryContext<>(txScope, " + rowType + ".class, null, " + this.getJdbcParamTypes() + ", paramBindings, \"" + configName + "\",\n      rowBindings -> new " + rowType + "() {public TxBindings getBindings() { return rowBindings; }}),\n      \"" + query + "\"\n    ).run();");
        method.body(sb.toString());
        srcClass.addMethod((AbstractSrcMethod)method);
    }

    private String getJdbcParamTypes() {
        StringBuilder sb = new StringBuilder("new int[]{");
        List<QueryParameter> parameters = this.getQuery().getParameters();
        for (int i = 0; i < parameters.size(); ++i) {
            QueryParameter p = parameters.get(i);
            if (i > 0) {
                sb.append(",");
            }
            sb.append(p.getJdbcType());
        }
        return sb.append("}").toString();
    }

    private String getJdbcParamTypes(List<QueryColumn> parameters) {
        StringBuilder sb = new StringBuilder("new int[]{");
        for (int i = 0; i < parameters.size(); ++i) {
            Column p = parameters.get(i);
            if (i > 0) {
                sb.append(",");
            }
            sb.append(p.getJdbcType());
        }
        return sb.append("}").toString();
    }

    private boolean isValueFragment(HostKind hostKind) {
        switch (hostKind) {
            case DOUBLE_QUOTE_LITERAL: 
            case TEXT_BLOCK_LITERAL: {
                return true;
            }
        }
        return false;
    }

    private void addRequiredParameters(AbstractSrcMethod method) {
        if (this.getQuery() == null) {
            return;
        }
        for (QueryParameter param : this.getQuery().getParameters()) {
            Class<Object> type = this.getType(param);
            if (type == null) {
                type = Object.class;
            }
            method.addParam(SrcLinkedClass.makeIdentifier((String)param.getName(), (boolean)false), new SrcType(type));
        }
    }

    private void addFlatRowType(SrcLinkedClass enclosingType) {
        String fqn = enclosingType.getName() + ".FlatRow";
        SrcLinkedClass srcClass = (SrcLinkedClass)((SrcLinkedClass)new SrcLinkedClass(fqn, (AbstractSrcClass)enclosingType, AbstractSrcClass.Kind.Interface).addInterface(ResultRow.class.getSimpleName())).modifiers(1L);
        if (this.getQuery() != null) {
            for (QueryColumn column : this.getQuery().getColumns().values()) {
                this.addQueryGetter(srcClass, column);
            }
            for (ForeignKeyQueryRef fkRef : this.getQuery().findForeignKeyQueryRefs()) {
                this.addFkFetcher(srcClass, fkRef);
            }
        }
        enclosingType.addInnerClass((AbstractSrcClass)srcClass);
    }

    private void addRowType(SrcLinkedClass enclosingType) {
        String fqn = enclosingType.getName() + ".Row";
        SrcLinkedClass srcClass = (SrcLinkedClass)((SrcLinkedClass)new SrcLinkedClass(fqn, (AbstractSrcClass)enclosingType, AbstractSrcClass.Kind.Interface).addInterface(ResultRow.class.getSimpleName())).modifiers(1L);
        if (this.getQuery() != null) {
            Map<String, QueryColumn> columns = this.getQuery().getColumns();
            Pair<SchemaTable, List<QueryColumn>> selectedTable = this.getQuery().findSelectedTable();
            if (selectedTable != null) {
                this.addSelectedTableAccessor(srcClass, selectedTable);
                List selectedCols = (List)selectedTable.getSecond();
                selectedCols.forEach(c -> {
                    QueryColumn cfr_ignored_0 = (QueryColumn)columns.remove(c.getName());
                });
            }
            for (ForeignKeyQueryRef fkRef : this.getQuery().findForeignKeyQueryRefs()) {
                this.addFkFetcher(srcClass, fkRef);
            }
            for (QueryColumn column : columns.values()) {
                this.addQueryGetter(srcClass, column);
            }
            this.addFlatRowMethod(srcClass);
        }
        enclosingType.addInnerClass((AbstractSrcClass)srcClass);
    }

    private void addFlatRowMethod(SrcLinkedClass srcClass) {
        SrcType type = new SrcType("FlatRow");
        SrcMethod flatRowMethod = (SrcMethod)((SrcMethod)((SrcMethod)((SrcMethod)new SrcMethod((AbstractSrcClass)srcClass).modifiers(0x80000000000L)).name("flatRow")).returns(type)).body("return new FlatRow() {public TxBindings getBindings() { return Row.this.getBindings(); }};");
        srcClass.addMethod((AbstractSrcMethod)flatRowMethod);
    }

    private void addFkFetcher(SrcLinkedClass srcClass, ForeignKeyQueryRef fkRef) {
        SchemaTable table = fkRef.getFk().getReferencedTable();
        String tableFqn = this.getTableFqn(table);
        SrcType type = new SrcType(tableFqn);
        String name = fkRef.getName();
        String propName = ManIdentifierUtil.makePascalCaseIdentifier((String)name, (boolean)true);
        SrcMethod fkFetchMethod = (SrcMethod)((SrcMethod)((SrcMethod)new SrcMethod((AbstractSrcClass)srcClass).name("fetch" + propName)).modifiers(0x80000000000L)).returns(type);
        String jdbcParamTypes = this.getJdbcParamTypes(fkRef.getQueryCols());
        String configName = this._model.getScope().getDbconfig().getName();
        StringBuilder sb = new StringBuilder();
        sb.append("DataBindings paramBindings = new DataBindings(new ConcurrentHashMap<>());\n");
        for (QueryColumn col : fkRef.getQueryCols()) {
            SchemaColumn referencedCol = col.getSchemaColumn().getForeignKey();
            sb.append("    paramBindings.put(\"" + referencedCol.getName() + "\", getBindings().get(" + col.getName() + "));\n");
        }
        sb.append("    return CrudProvider.instance().read(new QueryContext<" + tableFqn + ">(getBindings().getTxScope(), " + tableFqn + ".class,\n\"" + table.getName() + "\", " + jdbcParamTypes + ", paramBindings, \"" + configName + "\",\nrowBindings -> new " + tableFqn + "() {public TxBindings getBindings() { return rowBindings; }}));");
        fkFetchMethod.body(sb.toString());
        SrcLinkedClass.addActualNameAnnotation((SrcAnnotated)fkFetchMethod, (String)name, (boolean)true);
        srcClass.addMethod((AbstractSrcMethod)fkFetchMethod);
    }

    private void addSelectedTableAccessor(SrcLinkedClass srcClass, Pair<SchemaTable, List<QueryColumn>> selectedTable) {
        String tableSimpleName;
        SchemaTable table = (SchemaTable)selectedTable.getFirst();
        String propName = tableSimpleName = this.getTableSimpleTypeName(table);
        boolean tableNameMatchesColumnNameOfRemainingColumns = this.getQuery().getColumns().values().stream().filter(c -> !((List)selectedTable.getSecond()).contains(c)).map(c -> ManIdentifierUtil.makePascalCaseIdentifier((String)c.getName(), (boolean)true)).anyMatch(name -> name.equalsIgnoreCase(tableSimpleName));
        if (tableNameMatchesColumnNameOfRemainingColumns) {
            propName = propName + "Ref";
        }
        String tableType = this.getTableFqn(table);
        SrcType type = new SrcType(tableType);
        SrcGetProperty getter = (SrcGetProperty)new SrcGetProperty(propName, type).modifiers(0x80000000000L);
        StringBuilder sb = new StringBuilder();
        sb.append("DataBindings initialState = new DataBindings();\n");
        sb.append("    TxBindings rowBindings = Row.this.getBindings();\n");
        for (QueryColumn queryColumn : (List)selectedTable.getSecond()) {
            String schemaName = queryColumn.getSchemaColumn().getName();
            String queryName = queryColumn.getName();
            sb.append("    initialState.put(\"" + schemaName + "\", rowBindings.get(\"" + queryName + "\"));\n");
        }
        sb.append("    BasicTxBindings tableBindings = new BasicTxBindings(rowBindings.getTxScope(), TxKind.Update, initialState);\n");
        sb.append("    " + tableType + " tablePart = new " + tableType + "() {@Override public TxBindings getBindings() {return tableBindings; }};\n");
        sb.append("    rowBindings.setOwner(tablePart);\n");
        sb.append("    return tablePart;");
        getter.body(sb.toString());
        ((SrcLinkedClass)srcClass.addGetProperty(getter)).modifiers(1L);
    }

    private String getTableSimpleTypeName(SchemaTable table) {
        return table.getSchema().getJavaTypeName(table.getName());
    }

    private String getTableFqn(SchemaTable table) {
        String configName = table.getSchema().getDbConfig().getName();
        return configName + "." + this.getTableSimpleTypeName(table);
    }

    private void addImports(SrcLinkedClass srcClass) {
        srcClass.addImport(Query.class);
        srcClass.addImport(ResultRow.class);
        srcClass.addImport(Runner.class);
        srcClass.addImport(Bindings.class);
        srcClass.addImport(TxScope.class);
        srcClass.addImport(TxBindings.class);
        srcClass.addImport(BasicTxBindings.class);
        srcClass.addImport(BasicTxBindings.TxKind.class);
        srcClass.addImport(DataBindings.class);
        srcClass.addImport(CrudProvider.class);
        srcClass.addImport(QueryContext.class);
        srcClass.addImport(ConcurrentHashMap.class);
        srcClass.addImport(ActualName.class);
        srcClass.addImport(DisableStringLiteralTemplates.class);
        srcClass.addImport(FragmentValue.class);
        this.importSchemaType(srcClass);
    }

    private void importSchemaType(SrcLinkedClass srcClass) {
        DbConfig dbconfig = this._model.getScope().getDbconfig();
        srcClass.addImport(dbconfig.getSchemaPackage() + '.' + dbconfig.getName());
    }

    private void addQueryGetter(SrcLinkedClass srcClass, QueryColumn column) {
        Class<?> colType = this.getType(column);
        if (colType == null) {
            return;
        }
        SrcType type = new SrcType(colType);
        StringBuilder retType = new StringBuilder();
        type.render(retType, 0, false);
        String name = column.getName();
        String propName = ManIdentifierUtil.makePascalCaseIdentifier((String)column.getName(), (boolean)true);
        SrcGetProperty getter = (SrcGetProperty)((SrcGetProperty)new SrcGetProperty(propName, type).modifiers(0x80000000000L)).body("return (" + retType + ")getBindings().get(\"" + name + "\");");
        SrcLinkedClass.addActualNameAnnotation((SrcAnnotated)getter, (String)name, (boolean)true);
        ((SrcLinkedClass)srcClass.addGetProperty(getter)).modifiers(1L);
    }

    private Class<?> getType(DataElement elem) {
        Class<?> colType = elem.getType();
        if (colType == null) {
            String label = elem instanceof QueryColumn ? "column" : "parameter";
            this._model.addIssue(IIssue.Kind.Error, label + " type unknown for query '" + this.getQueryName() + "', " + label + " '" + elem.getName() + "', jdbcType '" + elem.getJdbcType() + "'");
            return null;
        }
        return colType;
    }
}

