/*
 * Decompiled with CFR 0.152.
 */
package manifold.sql.query.type;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import manifold.internal.javac.IIssue;
import manifold.internal.javac.IIssueContainer;
import manifold.sql.query.type.SqlIssue;

public class SqlIssueContainer
implements IIssueContainer {
    private final List<IIssue> _issues = new ArrayList<IIssue>();

    public SqlIssueContainer(List<Exception> errors) {
        this.addIssues(errors);
    }

    public List<IIssue> getIssues() {
        return this._issues;
    }

    public List<IIssue> getWarnings() {
        return this.getIssues().stream().filter(issue -> issue.getKind() == IIssue.Kind.Warning).collect(Collectors.toList());
    }

    public List<IIssue> getErrors() {
        return this.getIssues().stream().filter(issue -> issue.getKind() == IIssue.Kind.Error).collect(Collectors.toList());
    }

    public void addIssue(IIssue.Kind kind, String msg) {
        this._issues.add(new SqlIssue(kind, msg));
    }

    public void addIssues(List<Exception> errors) {
        for (Exception e : errors) {
            this._issues.add(new SqlIssue(IIssue.Kind.Error, e.getMessage()));
        }
    }

    public boolean isEmpty() {
        return this._issues == null;
    }
}

