/*
 * Decompiled with CFR 0.152.
 */
package manifold.sql.rt.impl.accessors;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDateTime;
import manifold.sql.rt.api.BaseElement;
import manifold.sql.rt.api.ValueAccessor;

public class TimestampValueAccessor
implements ValueAccessor {
    @Override
    public int getJdbcType() {
        return 93;
    }

    @Override
    public Class<?> getJavaType(BaseElement elem) {
        return LocalDateTime.class;
    }

    @Override
    public LocalDateTime getRowValue(ResultSet rs, BaseElement elem) throws SQLException {
        Timestamp timestamp = rs.getTimestamp(elem.getPosition());
        return timestamp == null ? null : timestamp.toLocalDateTime();
    }

    @Override
    public void setParameter(PreparedStatement ps, int pos, Object value) throws SQLException {
        if (value == null) {
            ps.setNull(pos, this.getJdbcType());
        } else if (value instanceof LocalDateTime) {
            ps.setTimestamp(pos, Timestamp.valueOf((LocalDateTime)value));
        } else if (value instanceof Instant) {
            ps.setTimestamp(pos, Timestamp.from((Instant)value));
        } else {
            ps.setObject(pos, value, this.getJdbcType());
        }
    }
}

