/*
 * Decompiled with CFR 0.152.
 */
package manifold.sql.rt.impl.accessors;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.util.Calendar;
import java.util.LinkedHashMap;
import java.util.Map;
import manifold.sql.rt.api.BaseElement;
import manifold.sql.rt.api.ValueAccessor;
import manifold.util.PrimitiveUtil;

public class ArrayValueAccessor
implements ValueAccessor {
    private static final Map<Class<?>, String> COMPONENT_TYPES = new LinkedHashMap<Class<?>, String>(){
        {
            this.put(Boolean.class, "BOOLEAN");
            this.put(Byte.class, "TINYINT");
            this.put(Short.class, "SMALLINT");
            this.put(Integer.class, "INTEGER");
            this.put(Long.class, "BIGINT");
            this.put(Float.class, "REAL");
            this.put(Double.class, "DOUBLE");
            this.put(BigInteger.class, "NUMERIC");
            this.put(BigDecimal.class, "NUMERIC");
            this.put(Timestamp.class, "TIMESTAMP");
            this.put(Instant.class, "TIMESTAMP");
            this.put(LocalDateTime.class, "TIMESTAMP");
            this.put(java.util.Date.class, "TIMESTAMP");
            this.put(Calendar.class, "TIMESTAMP");
            this.put(OffsetDateTime.class, "TIMESTAMP_WITH_TIMEZONE");
            this.put(Time.class, "TIME");
            this.put(LocalTime.class, "TIME");
            this.put(OffsetTime.class, "TIME_WITH_TIMEZONE");
            this.put(Date.class, "DATE");
            this.put(LocalDate.class, "DATE");
            this.put(URL.class, "DATALINK");
            this.put(String.class, "VARCHAR");
            this.put(byte[].class, "VARBINARY");
        }
    };

    @Override
    public int getJdbcType() {
        return 2003;
    }

    @Override
    public Class<?> getJavaType(BaseElement elem) {
        return Object.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getRowValue(ResultSet rs, BaseElement elem) throws SQLException {
        java.sql.Array array = rs.getArray(elem.getPosition());
        if (array == null) {
            return null;
        }
        try {
            Object object = array.getArray();
            return object;
        }
        finally {
            array.free();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setParameter(PreparedStatement ps, int pos, Object array) throws SQLException {
        if (array == null) {
            ps.setNull(pos, this.getJdbcType());
        } else if (array instanceof java.sql.Array) {
            ps.setArray(pos, (java.sql.Array)array);
        } else {
            Class<?> arrayType = array.getClass();
            if (!arrayType.isArray()) {
                throw new SQLException("Expecting array type, but found: " + arrayType.getTypeName());
            }
            if (arrayType.isPrimitive()) {
                array = this.makeBoxedArray(array, arrayType);
                arrayType = array.getClass();
            }
            Class<?> componentType = arrayType.getComponentType();
            String jdbcType = COMPONENT_TYPES.get(componentType);
            java.sql.Array jdbcArray = ps.getConnection().createArrayOf(jdbcType, array);
            try {
                ps.setArray(pos, jdbcArray);
            }
            finally {
                jdbcArray.free();
            }
        }
    }

    private Object[] makeBoxedArray(Object primitiveArray, Class<?> valueClass) {
        Class boxedType = PrimitiveUtil.getBoxedType(valueClass);
        int len = Array.getLength(primitiveArray);
        Object[] boxedArray = (Object[])Array.newInstance(boxedType, len);
        for (int i = 0; i < len; ++i) {
            boxedArray[i] = Array.get(primitiveArray, i);
        }
        return boxedArray;
    }
}

