/*
 * Decompiled with CFR 0.152.
 */
package manifold.sql.rt.impl;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import manifold.api.fs.IFile;
import manifold.api.util.cache.FqnCache;
import manifold.json.rt.api.DataBindings;
import manifold.rt.api.Bindings;
import manifold.rt.api.util.StreamUtil;
import manifold.sql.rt.api.DbConfig;
import manifold.sql.rt.api.ExecutionEnv;
import manifold.sql.rt.impl.ResourceDbLocationProvider;
import manifold.sql.rt.util.DriverInfo;
import manifold.sql.rt.util.PropertyExpressionProcessor;
import manifold.sql.rt.util.SqlScriptRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbConfigImpl
implements DbConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(DbConfigImpl.class);
    public static final DbConfig EMPTY = new DbConfigImpl(null, (Bindings)DataBindings.EMPTY_BINDINGS, ExecutionEnv.Unknown);
    private static final Set<String> DDL = new LinkedHashSet<String>();
    private final Bindings _bindings;
    private final Map<String, List<Consumer<Connection>>> _initializers = new HashMap<String, List<Consumer<Connection>>>();
    private final transient Function<String, FqnCache<IFile>> _resByExt;

    public DbConfigImpl(Function<String, FqnCache<IFile>> resByExt, Bindings bindings, ExecutionEnv executionEnv) {
        this(resByExt, bindings, executionEnv, null);
    }

    public DbConfigImpl(Function<String, FqnCache<IFile>> resByExt, Bindings bindings, ExecutionEnv executionEnv, Function<String, String> exprHandler) {
        this.processUrl(resByExt, bindings, executionEnv, "url", exprHandler);
        this.processUrl(resByExt, bindings, executionEnv, "buildUrl", exprHandler);
        this._bindings = bindings;
        this._resByExt = resByExt;
        this.assignDefaults();
    }

    public DbConfigImpl(Bindings bindings, ExecutionEnv executionEnv) {
        this(null, bindings, executionEnv);
    }

    private void assignDefaults() {
        if (this._bindings.isEmpty()) {
            return;
        }
        String schemaPackage = this.getSchemaPackage();
        if (schemaPackage == null || schemaPackage.isEmpty()) {
            this._bindings.put((Object)"schemaPackage", (Object)"sql.schema.types");
            LOGGER.info("No 'schemaPackage' defined in DbConfig: '" + this.getName() + "'. Using default: '" + schemaPackage + "'.");
        }
    }

    private void processUrl(Function<String, FqnCache<IFile>> resByExt, Bindings bindings, ExecutionEnv executionEnv, String key, Function<String, String> exprHandler) {
        String url = (String)bindings.get((Object)key);
        if (url == null) {
            return;
        }
        PropertyExpressionProcessor.Result result = PropertyExpressionProcessor.process(resByExt, url, executionEnv, exprHandler);
        bindings.put((Object)key, (Object)result.url);
        this._initializers.put(result.url, result.initializers);
    }

    @Override
    public void init(Connection connection, ExecutionEnv env) throws SQLException {
        List<Consumer<Connection>> consumers = this._initializers.get(env == ExecutionEnv.Compiler || env == ExecutionEnv.IDE ? this.getBuildUrlOtherwiseRuntimeUrl() : this.getUrl());
        for (Consumer<Connection> consumer : consumers) {
            consumer.accept(connection);
        }
        String schemaName = this.getSchemaName();
        if (schemaName != null && !schemaName.isEmpty()) {
            connection.setSchema(schemaName);
        }
        if (env == ExecutionEnv.Compiler || env == ExecutionEnv.IDE) {
            this.execDdl(connection, this.getDbDdl());
        }
    }

    private void execDdl(Connection connection, String ddl) throws SQLException {
        if (ddl == null || ddl.isEmpty() || !this.isInMemory() && DDL.contains(ddl)) {
            return;
        }
        DDL.add(ddl);
        if (!ddl.startsWith("/") && !ddl.startsWith("\\")) {
            ddl = "/" + ddl;
        }
        IFile ddlFile = null;
        if (this._resByExt != null) {
            ddlFile = ResourceDbLocationProvider.maybeGetCompileTimeResource(this._resByExt, ExecutionEnv.Compiler, ddl);
        }
        try (InputStream stream = ddlFile == null ? this.getClass().getResourceAsStream(ddl) : ddlFile.openInputStream();){
            if (stream == null) {
                throw new RuntimeException("No resource file found matching: " + ddl);
            }
            String script = StreamUtil.getContent((Reader)new InputStreamReader(stream));
            DriverInfo driver = DriverInfo.lookup(connection.getMetaData());
            SqlScriptRunner.runScript(connection, script, driver == DriverInfo.Oracle ? (s, e) -> s.toLowerCase().contains("drop user ") : null);
        }
        catch (Exception e2) {
            if (this.isInMemory() && e2.getMessage().contains("already exists")) {
                return;
            }
            throw new SQLException(e2);
        }
    }

    @Override
    public String getName() {
        return (String)this._bindings.get((Object)"name");
    }

    @Override
    public String getCatalogName() {
        return (String)this._bindings.get((Object)"catalogName");
    }

    @Override
    public String getSchemaName() {
        return (String)this._bindings.get((Object)"schemaName");
    }

    @Override
    public String getPath() {
        return (String)this._bindings.get((Object)"path");
    }

    @Override
    public String getUrl() {
        return (String)this._bindings.get((Object)"url");
    }

    @Override
    public String getBuildUrl() {
        return (String)this._bindings.get((Object)"buildUrl");
    }

    @Override
    public String getUser() {
        return (String)this._bindings.get((Object)"user");
    }

    @Override
    public String getPassword() {
        return (String)this._bindings.get((Object)"password");
    }

    @Override
    public boolean isDefault() {
        Boolean isDefault = (Boolean)this._bindings.get((Object)"isDefault");
        return isDefault != null && isDefault != false;
    }

    @Override
    public String getSchemaPackage() {
        return (String)this._bindings.get((Object)"schemaPackage");
    }

    @Override
    public Bindings getProperties() {
        return (Bindings)this._bindings.get((Object)"properties");
    }

    @Override
    public String getDbDdl() {
        return (String)this._bindings.get((Object)"dbDdl");
    }

    @Override
    public String getCustomBaseInterface() {
        return (String)this._bindings.get((Object)"customBaseInterface");
    }

    @Override
    public String getCustomBaseClass() {
        return (String)this._bindings.get((Object)"customBaseClass");
    }

    @Override
    public boolean isInMemory() {
        Boolean inMemory = (Boolean)this._bindings.get((Object)"inMemory");
        return inMemory != null && inMemory != false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DbConfigImpl)) {
            return false;
        }
        DbConfigImpl dbConfig = (DbConfigImpl)o;
        return this._bindings.equals(dbConfig._bindings);
    }

    public int hashCode() {
        return this._bindings.hashCode();
    }
}

