/*
 * Decompiled with CFR 0.152.
 */
package manifold.sql.rt.util;

import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum DriverInfo {
    DuckDB("DuckDB", false, true),
    H2("H2", false, false),
    MySQL("MySQL", false, true),
    Oracle("Oracle", true, false),
    Postgres("PostgreSQL", false, false),
    SQLite("SQLite", false, true),
    SqlServer("SQL Server", true, false),
    UNTESTED(null, false, false),
    ERRANT(null, false, false);

    public static final Logger LOGGER;
    private final String _productName;
    private final boolean _requiresQueryExecForTableName;
    private final boolean _flakyParameterMetadata;
    private final Map<String, Set<String>> _driversInUse;

    private DriverInfo(String productName, boolean requiresQueryExecForTableName, boolean flakyParameterMetadata) {
        this._productName = productName;
        this._requiresQueryExecForTableName = requiresQueryExecForTableName;
        this._flakyParameterMetadata = flakyParameterMetadata;
        this._driversInUse = new LinkedHashMap<String, Set<String>>();
    }

    public String getDriverBaseName() {
        return this._productName;
    }

    public Map<String, Set<String>> getDriversInUse() {
        return this._driversInUse;
    }

    private void addDriver(DatabaseMetaData metadata) throws SQLException {
        String name = metadata.getDriverName();
        String version = metadata.getDriverVersion();
        if (this._driversInUse.computeIfAbsent(name, __ -> new LinkedHashSet()).add(version)) {
            LOGGER.info("Driver in use: '" + name + "' version: " + version + " DB: " + metadata.getDatabaseProductName() + " DB version: " + metadata.getDatabaseProductVersion());
        }
    }

    public boolean requiresQueryExecForTableName() {
        return this._requiresQueryExecForTableName;
    }

    public boolean flakyParameterMetadata() {
        return this._flakyParameterMetadata;
    }

    public static DriverInfo lookup(DatabaseMetaData metadata) throws SQLException {
        DriverInfo driver = DriverInfo.lookup(metadata.getDriverName());
        if (driver != ERRANT) {
            driver.addDriver(metadata);
        }
        return driver;
    }

    private static DriverInfo lookup(String name) {
        if (name == null) {
            return ERRANT;
        }
        DriverInfo result = UNTESTED;
        for (DriverInfo di : DriverInfo.values()) {
            String baseName = di.getDriverBaseName();
            if (baseName == null || !name.contains(baseName)) continue;
            result = di;
            break;
        }
        return result;
    }

    static {
        LOGGER = LoggerFactory.getLogger(DriverInfo.class);
    }
}

