/*
 * Decompiled with CFR 0.152.
 */
package manifold.sql.rt.impl.accessors;

import java.sql.DatabaseMetaData;
import java.sql.ParameterMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import manifold.sql.rt.api.TypeProvider;
import manifold.sql.rt.util.DriverInfo;
import manifold.sql.rt.util.SqliteTypeMapping;

public class DefaultTypeProvider
implements TypeProvider {
    @Override
    public int getSchemaColumnType(boolean isNonNullUniqueId, ResultSet rs, DatabaseMetaData metaData) throws SQLException {
        int jdbcType = rs.getInt("DATA_TYPE");
        if ((jdbcType = this.oneOffCorrections(jdbcType, rs, metaData)) == 2) {
            jdbcType = this.findNumberType(jdbcType, rs.getInt("COLUMN_SIZE"), rs.getInt("DECIMAL_DIGITS"));
        }
        return jdbcType;
    }

    private int oracleGreatness(boolean isNonNullUniqueId, int jdbcType) {
        if (isNonNullUniqueId && jdbcType == 2) {
            return -5;
        }
        return jdbcType;
    }

    @Override
    public int getQueryColumnType(int pos, ResultSetMetaData rm, DatabaseMetaData metaData) throws SQLException {
        int jdbcType = rm.getColumnType(pos);
        if (jdbcType == 2) {
            jdbcType = this.findNumberType(jdbcType, rm.getPrecision(pos), rm.getScale(pos));
        }
        return jdbcType;
    }

    @Override
    public int getQueryParameterType(int pos, ParameterMetaData pm, DatabaseMetaData metaData) throws SQLException {
        int jdbcType = pm.getParameterType(pos);
        if (jdbcType == 0 || jdbcType == 12 && DriverInfo.lookup(metaData).flakyParameterMetadata()) {
            throw new SQLException();
        }
        if (jdbcType == 2) {
            jdbcType = this.findNumberType(jdbcType, pm.getPrecision(pos), pm.getScale(pos));
        }
        return jdbcType;
    }

    private int findNumberType(int jdbcType, int size, int decimalDigits) {
        if (decimalDigits > 0) {
            return jdbcType;
        }
        switch (size) {
            case 1: {
                return 16;
            }
            case 2: {
                return -6;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                return 4;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                return -5;
            }
        }
        return jdbcType;
    }

    private int oneOffCorrections(int jdbcType, ResultSet rs, DatabaseMetaData metadata) throws SQLException {
        Integer newType = new SqliteTypeMapping().getJdbcType(metadata, rs);
        return newType != null ? newType : jdbcType;
    }
}

