/*
 * Decompiled with CFR 0.152.
 */
package manifold.sql.rt.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.function.BiPredicate;
import manifold.rt.api.util.StreamUtil;
import manifold.sql.rt.api.ConnectionProvider;
import manifold.sql.rt.api.DbConfig;
import manifold.sql.rt.api.Dependencies;
import manifold.sql.rt.util.DriverInfo;
import manifold.sql.rt.util.SqlScriptParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlScriptRunner {
    private static final Logger LOGGER = LoggerFactory.getLogger(SqlScriptRunner.class);

    public static void runScript(Connection connection, String script) throws SQLException {
        SqlScriptRunner.runScript(connection, script, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runScript(Connection connection, String script, BiPredicate<String, SQLException> exceptionHandler) throws SQLException {
        boolean autoCommit = connection.getAutoCommit();
        try {
            connection.setAutoCommit(false);
            try (Statement stmt = connection.createStatement();){
                List<String> commands = SqlScriptParser.getCommands(script, SqlScriptRunner.extraSeparator(connection));
                for (String command : commands) {
                    if (exceptionHandler == null) {
                        stmt.addBatch(command);
                        continue;
                    }
                    try {
                        stmt.execute(command);
                    }
                    catch (SQLException e) {
                        if (exceptionHandler.test(command, e)) continue;
                        throw e;
                    }
                }
                if (exceptionHandler == null) {
                    stmt.executeBatch();
                }
            }
            connection.commit();
        }
        finally {
            connection.setAutoCommit(autoCommit);
        }
    }

    public static void runScript(String dataResourcePath, DbConfig dbconfig, Class<?> ctxClass) throws IOException {
        InputStream is = ctxClass.getResourceAsStream(dataResourcePath);
        if (is == null) {
            throw new IOException("Could not find resource file: '" + dataResourcePath + "'");
        }
        try (InputStreamReader reader = new InputStreamReader(is);){
            ConnectionProvider cp = Dependencies.instance().getConnectionProvider();
            try (Connection c = cp.getConnection(dbconfig.getName(), ctxClass);){
                String script = StreamUtil.getContent((Reader)reader);
                SqlScriptRunner.runScript(c, script);
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
            LOGGER.info("SQL script run successful: '" + dataResourcePath + "'");
        }
    }

    private static SqlScriptParser.ExtraSeparator extraSeparator(Connection c) throws SQLException {
        DriverInfo driver = DriverInfo.lookup(c.getMetaData());
        if (driver == DriverInfo.SqlServer) {
            return SqlScriptParser.ExtraSeparator.Go;
        }
        if (driver == DriverInfo.Oracle) {
            return SqlScriptParser.ExtraSeparator.Slash;
        }
        return null;
    }
}

