/*
 * Decompiled with CFR 0.152.
 */
package manifold.sql.rt.impl;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import manifold.rt.api.util.ServiceUtil;
import manifold.sql.rt.api.ConnectionProvider;
import manifold.sql.rt.api.DbConfig;
import manifold.sql.rt.api.Dependencies;
import manifold.sql.rt.api.ExecutionEnv;
import manifold.util.ManExceptionUtil;

public class HikariConnectionProvider
implements ConnectionProvider {
    private final Map<String, HikariDataSource> _dataSources = new ConcurrentHashMap<String, HikariDataSource>();

    public HikariConnectionProvider() {
        HashSet drivers = new HashSet();
        ServiceUtil.loadRegisteredServices(drivers, Driver.class, (ClassLoader)ConnectionProvider.class.getClassLoader());
    }

    @Override
    public Connection getConnection(String configName, Class<?> classContext) {
        DbConfig[] dbConfig = new DbConfig[]{null};
        HikariDataSource ds = this._dataSources.computeIfAbsent(configName, __ -> {
            dbConfig[0] = Dependencies.instance().getDbConfigProvider().loadDbConfig(configName, classContext);
            if (dbConfig[0] == null) {
                throw ManExceptionUtil.unchecked((Throwable)new SQLException("Could not find DbConfig for \"" + configName + "\", class context: " + classContext.getTypeName()));
            }
            return this.makeDataSource(dbConfig[0], dbConfig[0].getUrl());
        });
        try {
            Connection connection = ds.getConnection();
            if (dbConfig[0] != null) {
                dbConfig[0].init(connection, ExecutionEnv.Runtime);
            }
            return connection;
        }
        catch (SQLException e) {
            throw ManExceptionUtil.unchecked((Throwable)e);
        }
    }

    @Override
    public Connection getConnection(DbConfig dbConfig) throws SQLException {
        HikariDataSource ds = this._dataSources.computeIfAbsent(dbConfig.getName(), __ -> this.makeDataSource(dbConfig, dbConfig.getBuildUrlOtherwiseRuntimeUrl()));
        Connection connection = ds.getConnection();
        try {
            dbConfig.init(connection, ExecutionEnv.Compiler);
        }
        catch (Throwable t) {
            connection.close();
            throw t;
        }
        return connection;
    }

    @Override
    public void closeDataSource(DbConfig dbConfig) {
        HikariDataSource dropped = this._dataSources.remove(dbConfig.getName());
        if (dropped != null) {
            dropped.close();
        }
    }

    private HikariDataSource makeDataSource(DbConfig dbConfig, String url) {
        HikariConfig config = new HikariConfig();
        config.setJdbcUrl(url);
        config.setDataSourceProperties(dbConfig.toProperties());
        return new HikariDataSource(config);
    }

    @Override
    public void closeAll() {
        this._dataSources.values().forEach(ds -> ds.close());
        this._dataSources.clear();
    }
}

