/*
 * Decompiled with CFR 0.152.
 */
package manifold.sql.rt.impl;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import manifold.ext.rt.api.IBindingsBacked;
import manifold.json.rt.api.DataBindings;
import manifold.rt.api.Bindings;
import manifold.sql.rt.api.ColumnInfo;
import manifold.sql.rt.api.ConnectionProvider;
import manifold.sql.rt.api.CrudProvider;
import manifold.sql.rt.api.Dependencies;
import manifold.sql.rt.api.Entity;
import manifold.sql.rt.api.KeyRef;
import manifold.sql.rt.api.OperableTxBindings;
import manifold.sql.rt.api.OperableTxScope;
import manifold.sql.rt.api.QueryContext;
import manifold.sql.rt.api.Result;
import manifold.sql.rt.api.UpdateContext;
import manifold.sql.rt.api.ValueAccessor;
import manifold.sql.rt.api.ValueAccessorProvider;
import manifold.sql.rt.util.DbUtil;
import manifold.sql.rt.util.DriverInfo;
import manifold.util.ManExceptionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicCrudProvider
implements CrudProvider {
    private final Logger LOGGER = LoggerFactory.getLogger(BasicCrudProvider.class);
    public static final String SQLITE_LAST_INSERT_ROWID = "last_insert_rowid()";

    @Override
    public <T extends Entity> void create(Connection c, UpdateContext<T> ctx) {
        try {
            HashSet<String> skipParams = new HashSet<String>();
            String sql = this.makeInsertStmt(c.getMetaData(), ctx, skipParams);
            int[] reflectedColumnCount = new int[]{0};
            try (PreparedStatement ps = BasicCrudProvider.prepareStatement(c, ctx, sql, reflectedColumnCount);){
                this.setInsertParameters(ctx, ps, skipParams);
                this.executeAndFetchRow(c, ctx, ps, reflectedColumnCount[0] > 0);
            }
        }
        catch (SQLException e) {
            throw ManExceptionUtil.unchecked((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T extends Entity> PreparedStatement prepareStatement(Connection c, UpdateContext<T> ctx, String sql, int[] reflectedColumnCount) throws SQLException {
        String[] reflectedColumns = BasicCrudProvider.reflectedColumns(c, ctx, true);
        try {
            PreparedStatement preparedStatement = c.prepareStatement(sql, reflectedColumns);
            return preparedStatement;
        }
        catch (SQLException e) {
            if (DriverInfo.lookup(c.getMetaData()) == DriverInfo.DuckDB) {
                if (((Entity)ctx.getTable()).getBindings().isForInsert()) {
                    if ((sql = sql.trim()).endsWith(";")) {
                        sql = sql.substring(0, sql.length() - 1);
                    }
                    sql = sql + " RETURNING *";
                }
                PreparedStatement preparedStatement = c.prepareStatement(sql);
                return preparedStatement;
            }
            reflectedColumns = BasicCrudProvider.reflectedColumns(c, ctx, false);
            if (reflectedColumns.length == 0) {
                PreparedStatement preparedStatement = c.prepareStatement(sql);
                return preparedStatement;
            }
            PreparedStatement preparedStatement = c.prepareStatement(sql, reflectedColumns);
            return preparedStatement;
        }
        finally {
            reflectedColumnCount[0] = reflectedColumns.length;
        }
    }

    private static <T extends Entity> String[] reflectedColumns(Connection c, UpdateContext<T> ctx, boolean allColumns) throws SQLException {
        ColumnInfo pkColumnInfo;
        Boolean required;
        String[] reflectedColumnNames = new String[]{};
        if (allColumns && DriverInfo.lookup(c.getMetaData()) != DriverInfo.Oracle) {
            reflectedColumnNames = ctx.getAllCols().keySet().toArray(new String[0]);
        } else if (ctx.getPkCols().size() == 1 && (required = (pkColumnInfo = ctx.getAllCols().get(ctx.getPkCols().iterator().next())).isRequired()) != null && !required.booleanValue()) {
            reflectedColumnNames = ctx.getPkCols().toArray(new String[0]);
        }
        return reflectedColumnNames;
    }

    private <T extends Entity> void setInsertParameters(UpdateContext<T> ctx, PreparedStatement ps, Set<String> skipParams) throws SQLException {
        int i = 0;
        ValueAccessorProvider accProvider = Dependencies.instance().getValueAccessorProvider();
        for (Map.Entry entry : ((Entity)ctx.getTable()).getBindings().entrySet()) {
            if (skipParams.contains(entry.getKey())) continue;
            int jdbcType = ctx.getAllCols().get(entry.getKey()).getJdbcType();
            ValueAccessor accessor = accProvider.get(jdbcType);
            Object value = entry.getValue();
            value = BasicCrudProvider.patchFk(value, (String)entry.getKey(), ctx.getBindings());
            accessor.setParameter(ps, ++i, value);
        }
    }

    private static Object patchFk(Object value, String colName, OperableTxBindings bindings) {
        if (value instanceof KeyRef) {
            Object heldFkValue = bindings.getHeldValue(colName);
            value = heldFkValue != null ? heldFkValue : Integer.valueOf(0);
        }
        return value;
    }

    private <T extends Entity> String makeInsertStmt(DatabaseMetaData metaData, UpdateContext<T> ctx, Set<String> skipParams) throws SQLException {
        StringBuilder sql = new StringBuilder();
        sql.append("INSERT INTO ").append(DbUtil.enquoteIdentifier(ctx.getDdlTableName(), metaData)).append("(");
        int i = 0;
        Set entries = ((Entity)ctx.getTable()).getBindings().entrySet();
        for (Map.Entry entry : entries) {
            String colName = (String)entry.getKey();
            if (i++ > 0) {
                sql.append(", ");
            }
            sql.append(DbUtil.enquoteIdentifier(colName, metaData));
        }
        sql.append(")").append(" VALUES (");
        ValueAccessorProvider accProvider = Dependencies.instance().getValueAccessorProvider();
        i = 0;
        for (Map.Entry entry : entries) {
            if (i++ > 0) {
                sql.append(",");
            }
            ValueAccessor accessor = accProvider.get(ctx.getAllCols().get(entry.getKey()).getJdbcType());
            String expr = accessor.getParameterExpression(metaData, entry.getValue(), ctx.getAllCols().get(entry.getKey()));
            sql.append(expr);
            if (expr.contains("?")) continue;
            skipParams.add((String)entry.getKey());
        }
        sql.append(")");
        return sql.toString();
    }

    @Override
    public <T extends Entity> T readOne(QueryContext<T> ctx) {
        return (T)this.runQueryWithConnection(ctx, c -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        });
    }

    @Override
    public <T extends Entity> List<T> readMany(QueryContext<T> ctx) {
        return this.runQueryWithConnection(ctx, c -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T extends Entity, RT> RT runQueryWithConnection(QueryContext<T> ctx, Function<Connection, RT> query) {
        OperableTxScope txScope = (OperableTxScope)ctx.getTxScope();
        Connection activeConnection = txScope.getActiveConnection();
        if (activeConnection != null) {
            try {
                txScope.newSqlChangeCtx(activeConnection).doCrud();
                return query.apply(activeConnection);
            }
            catch (Exception e) {
                throw ManExceptionUtil.unchecked((Throwable)e);
            }
        }
        ConnectionProvider cp = Dependencies.instance().getConnectionProvider();
        try (Connection c = cp.getConnection(ctx.getConfigName(), ctx.getQueryClass());){
            RT RT = query.apply(c);
            return RT;
        }
        catch (Exception e) {
            throw ManExceptionUtil.unchecked((Throwable)e);
        }
    }

    private <T extends Entity> String makeReadStatement(DatabaseMetaData metaData, QueryContext<T> ctx, Set<String> skipParams) throws SQLException {
        ValueAccessorProvider accProvider = Dependencies.instance().getValueAccessorProvider();
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT * FROM ").append(DbUtil.enquoteIdentifier(ctx.getDdlTableName(), metaData)).append(" WHERE ");
        int i = 0;
        for (Map.Entry entry : ctx.getParams().entrySet()) {
            if (i > 0) {
                sql.append(" AND ");
            }
            ColumnInfo paramInfo = ctx.getParamInfo()[i];
            ValueAccessor accessor = accProvider.get(paramInfo.getJdbcType());
            String expr = accessor.getParameterExpression(metaData, entry.getValue(), paramInfo);
            sql.append(DbUtil.enquoteIdentifier((String)entry.getKey(), metaData)).append(" = ").append(expr);
            ++i;
            if (expr.contains("?")) continue;
            skipParams.add((String)entry.getKey());
        }
        return sql.toString();
    }

    @Override
    public <T extends Entity> void update(Connection c, UpdateContext<T> ctx) {
        try {
            StringBuilder sql = new StringBuilder();
            sql.append("UPDATE ").append(DbUtil.enquoteIdentifier(ctx.getDdlTableName(), c.getMetaData())).append(" SET\n");
            int i = 0;
            Map<String, Object> changeEntries = ctx.getBindings().uncommittedChangesEntrySet();
            if (changeEntries.isEmpty()) {
                throw new SQLException("Expecting changed entries.");
            }
            HashSet<String> skipParams = new HashSet<String>();
            ValueAccessorProvider accProvider = Dependencies.instance().getValueAccessorProvider();
            for (Map.Entry<String, Object> entry : changeEntries.entrySet()) {
                if (i > 0) {
                    sql.append(",\n");
                }
                String colName = entry.getKey();
                ValueAccessor accessor = accProvider.get(ctx.getAllCols().get(colName).getJdbcType());
                String expr = accessor.getParameterExpression(c.getMetaData(), entry.getValue(), ctx.getAllCols().get(colName));
                String qcolName = DbUtil.enquoteIdentifier(colName, c.getMetaData());
                sql.append(qcolName + " = ").append(expr);
                ++i;
                if (expr.contains("?")) continue;
                skipParams.add(entry.getKey());
            }
            sql.append("\nWHERE ");
            Set<String> allColNames = ctx.getAllCols().keySet();
            Set<String> whereColumns = !ctx.getPkCols().isEmpty() ? ctx.getPkCols() : (!ctx.getUkCols().isEmpty() ? ctx.getUkCols() : allColNames);
            if (!whereColumns.isEmpty()) {
                i = 0;
                for (String whereCol : whereColumns) {
                    if (i++ > 0) {
                        sql.append(", ");
                    }
                    ColumnInfo columnInfo = ctx.getAllCols().get(whereCol);
                    ValueAccessor accessor = accProvider.get(columnInfo.getJdbcType());
                    String expr = accessor.getParameterExpression(c.getMetaData(), ctx.getBindings().getPersistedStateValue(whereCol), columnInfo);
                    String qwhereCol = DbUtil.enquoteIdentifier(whereCol, c.getMetaData());
                    sql.append(qwhereCol + " = ").append(expr);
                    if (expr.contains("?")) continue;
                    skipParams.add(whereCol);
                }
            } else {
                throw new SQLException("Expecting primary key, unique key, or provided columns for WHERE clause.");
            }
            int[] reflectedColumnCount = new int[]{0};
            try (PreparedStatement ps = BasicCrudProvider.prepareStatement(c, ctx, sql.toString(), reflectedColumnCount);){
                this.setUpdateParameters(ctx, whereColumns, ps, skipParams);
                this.executeAndFetchRow(c, ctx, ps, reflectedColumnCount[0] > 0);
            }
        }
        catch (SQLException e) {
            throw ManExceptionUtil.unchecked((Throwable)e);
        }
    }

    private <T extends Entity> void setUpdateParameters(UpdateContext<T> ctx, Set<String> whereColumns, PreparedStatement ps, Set<String> skipParams) throws SQLException {
        Object value;
        ValueAccessor accessor;
        Map<String, Object> changeEntries = ctx.getBindings().uncommittedChangesEntrySet();
        if (changeEntries.isEmpty()) {
            throw new SQLException("Expecting changed entries.");
        }
        ValueAccessorProvider accProvider = Dependencies.instance().getValueAccessorProvider();
        int i = 0;
        for (Map.Entry<String, Object> entry : changeEntries.entrySet()) {
            if (skipParams.contains(entry.getKey())) continue;
            accessor = accProvider.get(ctx.getAllCols().get(entry.getKey()).getJdbcType());
            value = entry.getValue();
            accessor.setParameter(ps, ++i, value);
        }
        if (!whereColumns.isEmpty()) {
            for (String whereColumn : whereColumns) {
                if (skipParams.contains(whereColumn)) continue;
                accessor = accProvider.get(ctx.getAllCols().get(whereColumn).getJdbcType());
                value = ctx.getBindings().getPersistedStateValue(whereColumn);
                accessor.setParameter(ps, ++i, value);
            }
        } else {
            throw new SQLException("Expecting primary key, unique key, or provided columns for WHERE clause.");
        }
    }

    private <T extends Entity> void setDeleteParameters(UpdateContext<T> ctx, Set<String> whereColumns, PreparedStatement ps, Set<String> skipParams) throws SQLException {
        int i = 0;
        if (!whereColumns.isEmpty()) {
            ValueAccessorProvider accProvider = Dependencies.instance().getValueAccessorProvider();
            for (String whereColumn : whereColumns) {
                ValueAccessor accessor = accProvider.get(ctx.getAllCols().get(whereColumn).getJdbcType());
                Object value = ctx.getBindings().getPersistedStateValue(whereColumn);
                if (skipParams.contains(whereColumn)) continue;
                accessor.setParameter(ps, ++i, value);
            }
        } else {
            throw new SQLException("Expecting primary key, unique key, or provided columns for WHERE clause.");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T extends Entity> void executeAndFetchRow(Connection c, UpdateContext<T> ctx, PreparedStatement ps, boolean hasReflectedColumns) throws SQLException {
        DataBindings reflectedRow = DataBindings.EMPTY_BINDINGS;
        if (DriverInfo.lookup(c.getMetaData()) == DriverInfo.DuckDB) {
            boolean hasResultSet = ps.execute();
            if (hasResultSet) {
                try (ResultSet resultSet = ps.getResultSet();){
                    Result<IBindingsBacked> resultRow = new Result<IBindingsBacked>(ctx.getAllCols(), resultSet, rowBindings -> () -> rowBindings);
                    Iterator<IBindingsBacked> iterator = resultRow.iterator();
                    if (iterator.hasNext()) {
                        reflectedRow = iterator.next().getBindings();
                        if (iterator.hasNext()) {
                            throw new SQLException("Expecting a single row, found more.");
                        }
                    }
                }
            }
        } else {
            int result = ps.executeUpdate();
            if (result != 1) {
                throw new SQLException("Expecting a single row result for Update/Insert, got " + result);
            }
            if (hasReflectedColumns) {
                try (ResultSet resultSet = ps.getGeneratedKeys();){
                    Result<IBindingsBacked> resultRow = new Result<IBindingsBacked>(ctx.getAllCols(), resultSet, rowBindings -> () -> rowBindings);
                    Iterator<IBindingsBacked> iterator = resultRow.iterator();
                    if (iterator.hasNext()) {
                        reflectedRow = iterator.next().getBindings();
                        if (iterator.hasNext()) {
                            throw new SQLException("Expecting a single row, found more.");
                        }
                    }
                }
                catch (SQLFeatureNotSupportedException e) {
                    this.LOGGER.warn("getGeneratedKeys() is not supported, attempting to fetch updated row.", (Throwable)e);
                }
            }
        }
        if (BasicCrudProvider.isReflectedRowEmpty((Bindings)reflectedRow) && ctx.getPkCols().isEmpty()) {
            return;
        }
        if (BasicCrudProvider.isReflectedRowEmpty((Bindings)(reflectedRow = this.maybeFetchInsertedRow(c, ctx, (Bindings)reflectedRow)))) {
            throw new SQLException("Failed to reflect newly inserted row.");
        }
        ctx.getBindings().holdValues((Bindings)reflectedRow);
    }

    private <T extends Entity> Bindings maybeFetchInsertedRow(Connection c, UpdateContext<T> ctx, Bindings reflectedRow) throws SQLException {
        DataBindings params = new DataBindings();
        ColumnInfo[] ci = null;
        if (reflectedRow.containsKey((Object)SQLITE_LAST_INSERT_ROWID)) {
            params.put("_rowid_", reflectedRow.get((Object)SQLITE_LAST_INSERT_ROWID));
            ci = new ColumnInfo[]{new ColumnInfo("_rowid_", 4, "integer", null)};
        } else if (BasicCrudProvider.isReflectedRowEmpty(reflectedRow) && !ctx.getPkCols().isEmpty()) {
            Set<String> pkCols = ctx.getPkCols();
            Map<String, ColumnInfo> allCols = ctx.getAllCols();
            ci = new ColumnInfo[pkCols.size()];
            int i = 0;
            for (String pkCol : pkCols) {
                Object pkValue = ctx.getBindings().get(pkCol);
                if (pkValue == null) {
                    return reflectedRow;
                }
                if (pkValue instanceof Entity && (pkValue = ctx.getBindings().getHeldValue(pkCol)) == null) {
                    return reflectedRow;
                }
                params.put(pkCol, pkValue);
                ci[i] = (ColumnInfo)allCols.get(pkCol);
                ++i;
            }
        } else if (reflectedRow.size() == 1 && ctx.getAllCols().size() > 1 && ctx.getPkCols().size() == 1) {
            boolean i = false;
            for (Map.Entry entry : reflectedRow.entrySet()) {
                String pkCol = ctx.getPkCols().iterator().next();
                ColumnInfo pkColumnInfo = ctx.getAllCols().get(pkCol);
                if (pkColumnInfo == null) continue;
                ci = new ColumnInfo[]{pkColumnInfo};
                params.put(pkCol, entry.getValue());
                break;
            }
            if (ci == null) {
                throw new SQLException("Failed to retrieve generated primary key");
            }
        } else {
            return reflectedRow;
        }
        QueryContext queryContext = new QueryContext(ctx.getTxScope(), null, ctx.getDdlTableName(), null, ci, (Bindings)params, ctx.getConfigName(), null);
        HashSet<String> skipParams = new HashSet<String>();
        String sql = this.makeReadStatement(c.getMetaData(), queryContext, skipParams);
        try (PreparedStatement ps = c.prepareStatement(sql);){
            this.setQueryParameters(queryContext, ps, skipParams);
            try (ResultSet resultSet = ps.executeQuery();){
                Result<IBindingsBacked> resultRow = new Result<IBindingsBacked>(ctx.getAllCols(), resultSet, rowBindings -> () -> rowBindings);
                Iterator<IBindingsBacked> iterator = resultRow.iterator();
                if (!iterator.hasNext()) {
                    throw new SQLException("Expecting a single row, found none.");
                }
                reflectedRow = iterator.next().getBindings();
                if (iterator.hasNext()) {
                    throw new SQLException("Expecting a single row, found more.");
                }
            }
        }
        return reflectedRow;
    }

    private static boolean isReflectedRowEmpty(Bindings reflectedRow) {
        return reflectedRow.isEmpty() || reflectedRow.size() == 1 && ((Map.Entry)reflectedRow.entrySet().iterator().next()).getValue() == null;
    }

    @Override
    public <T extends Entity> void delete(Connection c, UpdateContext<T> ctx) {
        try {
            StringBuilder sql = new StringBuilder();
            sql.append("DELETE FROM ").append(DbUtil.enquoteIdentifier(ctx.getDdlTableName(), c.getMetaData())).append(" WHERE\n");
            Set<String> allColNames = ctx.getAllCols().keySet();
            Set<String> whereColumns = !ctx.getPkCols().isEmpty() ? ctx.getPkCols() : (!ctx.getUkCols().isEmpty() ? ctx.getUkCols() : allColNames);
            HashSet<String> skipParams = new HashSet<String>();
            if (!whereColumns.isEmpty()) {
                ValueAccessorProvider accProvider = Dependencies.instance().getValueAccessorProvider();
                int i = 0;
                for (String whereCol : whereColumns) {
                    if (i++ > 0) {
                        sql.append(" AND ");
                    }
                    ValueAccessor accessor = accProvider.get(ctx.getAllCols().get(whereCol).getJdbcType());
                    String expr = accessor.getParameterExpression(c.getMetaData(), ctx.getBindings().getPersistedStateValue(whereCol), ctx.getAllCols().get(whereCol));
                    String qwhereCol = DbUtil.enquoteIdentifier(whereCol, c.getMetaData());
                    sql.append(qwhereCol + " = ").append(expr);
                    if (expr.contains("?")) continue;
                    skipParams.add(whereCol);
                }
            } else {
                throw new SQLException("Expecting primary key, unique key, or provided columns for WHERE clause.");
            }
            try (PreparedStatement ps = c.prepareStatement(sql.toString());){
                this.setDeleteParameters(ctx, whereColumns, ps, skipParams);
                int result = ps.executeUpdate();
                if (result != 1) {
                    throw new SQLException("Expecting a single row result for Delete, got " + result);
                }
            }
        }
        catch (SQLException e) {
            throw ManExceptionUtil.unchecked((Throwable)e);
        }
    }

    private <T extends Entity> void setQueryParameters(QueryContext<T> ctx, PreparedStatement ps, Set<String> skipParams) throws SQLException {
        int i = 0;
        ValueAccessorProvider accProvider = Dependencies.instance().getValueAccessorProvider();
        for (Map.Entry entry : ctx.getParams().entrySet()) {
            if (skipParams.contains(entry.getKey())) continue;
            ValueAccessor accessor = accProvider.get(ctx.getParamInfo()[i].getJdbcType());
            accessor.setParameter(ps, ++i, entry.getValue());
        }
    }
}

