/*
 * Decompiled with CFR 0.152.
 */
package manifold.sql.rt.api;

import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import manifold.sql.rt.api.BaseElement;
import manifold.sql.rt.api.ColumnInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface ValueAccessor {
    public static final Logger LOGGER = LoggerFactory.getLogger(ValueAccessor.class);

    public int getJdbcType();

    public Class<?> getJavaType(BaseElement var1);

    public Object getRowValue(ResultSet var1, BaseElement var2) throws SQLException;

    public void setParameter(PreparedStatement var1, int var2, Object var3) throws SQLException;

    default public String getParameterExpression(DatabaseMetaData metaData, Object value, ColumnInfo ci) {
        return "?";
    }

    default public Class<?> getClassForColumnClassName(String className, Class<?> defaultClass) {
        if (className != null && !className.equals(Object.class.getTypeName())) {
            try {
                return Class.forName(className);
            }
            catch (ClassNotFoundException cnfe) {
                LOGGER.warn("Failed to access class '" + className + "' for '" + this.getClass().getSimpleName() + "'", (Throwable)cnfe);
            }
        }
        return defaultClass;
    }
}

