/*
 * Decompiled with CFR 0.152.
 */
package manifold.sql.rt.api;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.SQLException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.util.Map;
import java.util.function.Consumer;
import manifold.json.rt.api.DataBindings;
import manifold.util.ManExceptionUtil;
import org.duckdb.DuckDBAppender;
import org.duckdb.DuckDBConnection;

public abstract class SchemaAppender {
    private final String _schema;
    private final String _table;
    private DuckDBAppender _appender;

    public SchemaAppender(String schema, String table) {
        this._schema = schema;
        this._table = table;
    }

    protected void appendRow(DataBindings bindings) {
        try {
            this._appender.beginRow();
            this.appendBindings(this._appender, bindings);
            this._appender.endRow();
        }
        catch (SQLException e) {
            throw ManExceptionUtil.unchecked((Throwable)e);
        }
    }

    public <T extends SchemaAppender> void execute(Connection c, Consumer<T> consumer) throws SQLException {
        DuckDBConnection duckdbConnection = c.unwrap(DuckDBConnection.class);
        try (DuckDBAppender appender = duckdbConnection.createAppender(this._schema, this._table);){
            this._appender = appender;
            consumer.accept(this);
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
    }

    private void appendBindings(DuckDBAppender appender, DataBindings bindings) throws SQLException {
        for (Map.Entry entry : bindings.entrySet()) {
            Object value = entry.getValue();
            if (value == null) {
                appender.append(null);
                continue;
            }
            if (value instanceof BigDecimal) {
                appender.appendBigDecimal((BigDecimal)value);
                continue;
            }
            if (value instanceof BigInteger) {
                appender.append(((BigInteger)value).longValueExact());
                continue;
            }
            if (value instanceof Long) {
                appender.append(((Long)value).longValue());
                continue;
            }
            if (value instanceof Integer) {
                appender.append(((Integer)value).intValue());
                continue;
            }
            if (value instanceof Short) {
                appender.append(((Short)value).shortValue());
                continue;
            }
            if (value instanceof Byte) {
                appender.append(((Byte)value).byteValue());
                continue;
            }
            if (value instanceof Double) {
                appender.append(((Double)value).doubleValue());
                continue;
            }
            if (value instanceof Float) {
                appender.append(((Float)value).floatValue());
                continue;
            }
            if (value instanceof Boolean) {
                appender.append(((Boolean)value).booleanValue());
                continue;
            }
            if (value instanceof LocalDateTime) {
                appender.appendLocalDateTime((LocalDateTime)value);
                continue;
            }
            if (value instanceof OffsetDateTime) {
                appender.appendLocalDateTime(((OffsetDateTime)value).toLocalDateTime());
                continue;
            }
            if (value instanceof LocalDate) {
                appender.appendLocalDateTime(((LocalDate)value).atStartOfDay());
                continue;
            }
            appender.append(value.toString());
        }
    }
}

