/*
 * Decompiled with CFR 0.152.
 */
package manifold.sql.rt.api;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import manifold.json.rt.api.DataBindings;
import manifold.sql.rt.api.ColumnInfo;
import manifold.sql.rt.api.Dependencies;
import manifold.sql.rt.api.OperableTxScope;
import manifold.sql.rt.api.TxScope;
import manifold.sql.rt.api.ValueAccessor;
import manifold.sql.rt.api.ValueAccessorProvider;
import manifold.util.ManExceptionUtil;

public class Executor {
    private final String _sqlCommand;
    private final TxScope.SqlChangeCtx _ctx;
    private final ColumnInfo[] _paramInfo;
    private final DataBindings _paramBindings;

    public Executor(TxScope.SqlChangeCtx ctx, ColumnInfo[] paramInfo, DataBindings paramBindings, String sqlCommand) {
        this._ctx = ctx;
        this._paramInfo = paramInfo;
        this._paramBindings = paramBindings;
        this._sqlCommand = sqlCommand;
    }

    public int execute() throws SQLException {
        Connection txConnextion = this._ctx.getConnection();
        if (txConnextion == null) {
            throw new SQLException("Connection is null. Raw commands must execute using `addSqlChange()`.");
        }
        this._ctx.doCrud();
        if (this._ctx instanceof TxScope.BatchSqlChangeCtx) {
            if (this._paramBindings.isEmpty()) {
                ((OperableTxScope)this._ctx.getTxScope()).addBatch(this, stmt -> this.addBatchStatement((Statement)stmt));
            } else {
                ((OperableTxScope)this._ctx.getTxScope()).addBatch(this, ps -> this.setParameters((PreparedStatement)ps));
            }
            return 0;
        }
        try (PreparedStatement ps2 = txConnextion.prepareStatement(this._sqlCommand);){
            this.setParameters(ps2);
            int n = ps2.executeUpdate();
            return n;
        }
    }

    private void addBatchStatement(Statement stmt) {
        try {
            stmt.addBatch(this._sqlCommand);
        }
        catch (SQLException e) {
            throw ManExceptionUtil.unchecked((Throwable)e);
        }
    }

    public TxScope.SqlChangeCtx getCtx() {
        return this._ctx;
    }

    public String getSqlCommand() {
        return this._sqlCommand;
    }

    private void setParameters(PreparedStatement ps) {
        int i = 0;
        ValueAccessorProvider accProvider = Dependencies.instance().getValueAccessorProvider();
        for (Object param : this._paramBindings.values()) {
            ValueAccessor accessor = accProvider.get(this._paramInfo[i].getJdbcType());
            try {
                accessor.setParameter(ps, ++i, param);
            }
            catch (SQLException e) {
                throw ManExceptionUtil.unchecked((Throwable)e);
            }
        }
    }
}

