/*
 * Decompiled with CFR 0.152.
 */
package manifold.sql.rt.impl.accessors;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLXML;
import manifold.sql.rt.api.BaseElement;
import manifold.sql.rt.api.ValueAccessor;

public class SqlXmlValueAccessor
implements ValueAccessor {
    @Override
    public int getJdbcType() {
        return 2009;
    }

    @Override
    public Class<?> getJavaType(BaseElement elem) {
        return String.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getRowValue(ResultSet rs, BaseElement elem) throws SQLException {
        SQLXML sqlxml = rs.getSQLXML(elem.getPosition());
        if (sqlxml == null) {
            return null;
        }
        try {
            String string = sqlxml.getString();
            return string;
        }
        finally {
            sqlxml.free();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setParameter(PreparedStatement ps, int pos, Object value) throws SQLException {
        if (value == null) {
            ps.setNull(pos, this.getJdbcType());
        } else {
            SQLXML sqlxml = ps.getConnection().createSQLXML();
            try {
                sqlxml.setString(value.toString());
                ps.setSQLXML(pos, sqlxml);
            }
            finally {
                sqlxml.free();
            }
        }
    }
}

