/*
 * Decompiled with CFR 0.152.
 */
package manifold.sql.rt.impl.accessors;

import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import manifold.sql.rt.api.BaseElement;
import manifold.sql.rt.api.ColumnInfo;
import manifold.sql.rt.api.ValueAccessor;
import manifold.sql.rt.util.DriverInfo;

public class OtherValueAccessor
implements ValueAccessor {
    private static final Object NONE = new Object(){};

    @Override
    public int getJdbcType() {
        return 1111;
    }

    @Override
    public Class<?> getJavaType(BaseElement elem) {
        return this.getClassForColumnClassName(elem.getColumnClassName(), Object.class);
    }

    @Override
    public Object getRowValue(ResultSet rs, BaseElement elem) throws SQLException {
        Object postgresStrangeness = OtherValueAccessor.postgresStrangeness(rs, elem);
        if (postgresStrangeness != NONE) {
            return postgresStrangeness;
        }
        return rs.getObject(elem.getPosition());
    }

    @Override
    public void setParameter(PreparedStatement ps, int pos, Object value) throws SQLException {
        if (value == null) {
            ps.setNull(pos, this.getJdbcType());
        } else {
            ps.setObject(pos, value);
        }
    }

    @Override
    public String getParameterExpression(DatabaseMetaData metaData, Object value, ColumnInfo ci) {
        try {
            DriverInfo driver = DriverInfo.lookup(metaData);
            if (driver == DriverInfo.Postgres) {
                String lcSqlType;
                switch (lcSqlType = ci.getSqlType().toLowerCase()) {
                    case "cidr": 
                    case "inet": 
                    case "macaddr": 
                    case "macaddr8": 
                    case "money": 
                    case "varbit": 
                    case "bit varying": {
                        return this.castParam(value, ci);
                    }
                }
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return ValueAccessor.super.getParameterExpression(metaData, value, ci);
    }

    private String castParam(Object value, ColumnInfo ci) {
        return "CAST(? AS " + ci.getSqlType() + ")";
    }

    private static Object postgresStrangeness(ResultSet rs, BaseElement elem) throws SQLException {
        String lcSqlType;
        switch (lcSqlType = elem.getSqlType().toLowerCase()) {
            case "cidr": 
            case "inet": 
            case "macaddr": 
            case "macaddr8": 
            case "varbit": 
            case "bit varying": {
                return rs.getString(elem.getPosition());
            }
            case "money": {
                return rs.getDouble(elem.getPosition());
            }
        }
        return NONE;
    }
}

