/*
 * Decompiled with CFR 0.152.
 */
package manifold.sql.rt.impl;

import java.io.File;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Comparator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import manifold.api.fs.IFile;
import manifold.api.util.cache.FqnCache;
import manifold.rt.api.util.Pair;
import manifold.rt.api.util.TempFileUtil;
import manifold.sql.rt.api.DbLocationProvider;
import manifold.sql.rt.api.ExecutionEnv;
import manifold.sql.rt.util.SqlScriptRunner;
import org.jetbrains.annotations.NotNull;

public class ResourceDbLocationProvider
implements DbLocationProvider {
    public static final String RESOURCE = "resource";
    public static final String RESOURCE_SCRIPT = "resource_script";

    @Override
    public Pair<Object, Consumer<Connection>> getLocation(Function<String, FqnCache<IFile>> resByExt, ExecutionEnv executionEnv, String tag, String ... args) {
        if (tag.equals(RESOURCE)) {
            return this.resource(false, resByExt, executionEnv, args);
        }
        if (tag.equals(RESOURCE_SCRIPT)) {
            return this.resourceScript(resByExt, executionEnv, args);
        }
        return new Pair(UNHANDLED, null);
    }

    private Pair<Object, Consumer<Connection>> resourceScript(Function<String, FqnCache<IFile>> resByExt, ExecutionEnv executionEnv, String[] args) {
        if (args.length < 2) {
            throw new RuntimeException("Expecting at least two arguments: <resource path>, <file name>");
        }
        return this.resource(true, resByExt, executionEnv, args);
    }

    /*
     * Exception decompiling
     */
    private Pair<Object, Consumer<Connection>> resource(boolean isScript, Function<String, FqnCache<IFile>> resByExt, ExecutionEnv executionEnv, String[] args) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @NotNull
    public static String makeTempDirName(String dbFileResourcePath) {
        int slashPos = dbFileResourcePath.lastIndexOf("/");
        if (slashPos < 0) {
            slashPos = dbFileResourcePath.lastIndexOf("\\");
        }
        String tempDir = slashPos >= 0 ? dbFileResourcePath.substring(slashPos + 1) : dbFileResourcePath;
        return tempDir;
    }

    public static void deleteTempDbDir(ExecutionEnv executionEnv, String dbFileResourcePath) {
        File file = TempFileUtil.makeTempFile((String)("/" + (Object)((Object)executionEnv) + "/" + ResourceDbLocationProvider.makeTempDirName(dbFileResourcePath)));
        if (!file.exists()) {
            return;
        }
        try (Stream<Path> pathStream = Files.walk(file.toPath(), new FileVisitOption[0]);){
            pathStream.sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
            long now = System.nanoTime();
            Path path = Paths.get(file.toURI());
            while (!Files.notExists(path, new LinkOption[0])) {
                if (System.nanoTime() - now > 10000000000L) {
                    throw new RuntimeException("Could not delete temp db directory: " + path);
                }
                Thread.sleep(100L);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static IFile maybeGetCompileTimeResource(Function<String, FqnCache<IFile>> resByExt, ExecutionEnv executionEnv, String dbFileResourcePath) {
        if (executionEnv == ExecutionEnv.Compiler || executionEnv == ExecutionEnv.IDE) {
            IFile[] resFile = new IFile[]{null};
            int idot = dbFileResourcePath.lastIndexOf(46);
            if (idot <= 0) {
                throw new RuntimeException("Expecting a file extension: " + dbFileResourcePath);
            }
            String ext = dbFileResourcePath.substring(idot + 1);
            FqnCache<IFile> extensionCache = resByExt.apply(ext);
            extensionCache.visitDepthFirst(file -> {
                if (file != null && file.getPath().getPathString("/").endsWith(dbFileResourcePath)) {
                    resFile[0] = file;
                    return false;
                }
                return true;
            });
            return resFile[0];
        }
        return null;
    }

    private static class Initializer
    implements Consumer<Connection> {
        private final String _script;
        private boolean _initialized;

        public Initializer(String script) {
            this._script = script;
        }

        @Override
        public void accept(Connection connection) {
            if (this._initialized) {
                return;
            }
            try {
                SqlScriptRunner.runScript(connection, this._script);
                this._initialized = true;
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

