/*
 * Decompiled with CFR 0.152.
 */
package manifold.sql.rt.impl.accessors;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import manifold.sql.rt.api.BaseElement;
import manifold.sql.rt.api.ValueAccessor;

public class TinyIntValueAccessor
implements ValueAccessor {
    @Override
    public int getJdbcType() {
        return -6;
    }

    @Override
    public Class<?> getJavaType(BaseElement elem) {
        return elem.canBeNull() ? Byte.class : Byte.TYPE;
    }

    @Override
    public Byte getRowValue(ResultSet rs, BaseElement elem) throws SQLException {
        byte value = rs.getByte(elem.getPosition());
        return value == 0 && rs.wasNull() ? null : Byte.valueOf(value);
    }

    @Override
    public void setParameter(PreparedStatement ps, int pos, Object value) throws SQLException {
        if (value == null) {
            ps.setNull(pos, this.getJdbcType());
        } else if (value instanceof Number) {
            ps.setByte(pos, ((Number)value).byteValue());
        } else {
            ps.setObject(pos, value, this.getJdbcType());
        }
    }
}

