/*
 * Decompiled with CFR 0.152.
 */
package manifold.sql.rt.impl.accessors;

import java.util.LinkedHashMap;
import java.util.Map;
import manifold.sql.rt.api.ValueAccessor;
import manifold.sql.rt.api.ValueAccessorProvider;
import manifold.sql.rt.impl.accessors.ArrayValueAccessor;
import manifold.sql.rt.impl.accessors.BigIntValueAccessor;
import manifold.sql.rt.impl.accessors.BinaryValueAccessor;
import manifold.sql.rt.impl.accessors.BitValueAccessor;
import manifold.sql.rt.impl.accessors.BlobValueAccessor;
import manifold.sql.rt.impl.accessors.BooleanValueAccessor;
import manifold.sql.rt.impl.accessors.CharValueAccessor;
import manifold.sql.rt.impl.accessors.ClobValueAccessor;
import manifold.sql.rt.impl.accessors.DataLinkValueAccessor;
import manifold.sql.rt.impl.accessors.DateValueAccessor;
import manifold.sql.rt.impl.accessors.DecimalValueAccessor;
import manifold.sql.rt.impl.accessors.DistinctValueAccessor;
import manifold.sql.rt.impl.accessors.DoubleValueAccessor;
import manifold.sql.rt.impl.accessors.FloatValueAccessor;
import manifold.sql.rt.impl.accessors.IntegerValueAccessor;
import manifold.sql.rt.impl.accessors.JavaObjectValueAccessor;
import manifold.sql.rt.impl.accessors.LongNvarcharValueAccessor;
import manifold.sql.rt.impl.accessors.LongVarBinaryValueAccessor;
import manifold.sql.rt.impl.accessors.LongVarcharValueAccessor;
import manifold.sql.rt.impl.accessors.NcharValueAccessor;
import manifold.sql.rt.impl.accessors.NclobValueAccessor;
import manifold.sql.rt.impl.accessors.NumericValueAccessor;
import manifold.sql.rt.impl.accessors.NvarcharValueAccessor;
import manifold.sql.rt.impl.accessors.Oracle_IntervalDsValueAccessor;
import manifold.sql.rt.impl.accessors.Oracle_IntervalYmValueAccessor;
import manifold.sql.rt.impl.accessors.Oracle_TimestampLtzValueAccessor;
import manifold.sql.rt.impl.accessors.Oracle_TimestampTzValueAccessor;
import manifold.sql.rt.impl.accessors.OtherValueAccessor;
import manifold.sql.rt.impl.accessors.RealValueAccessor;
import manifold.sql.rt.impl.accessors.RowIdValueAccessor;
import manifold.sql.rt.impl.accessors.SmallIntValueAccessor;
import manifold.sql.rt.impl.accessors.SqlXmlValueAccessor;
import manifold.sql.rt.impl.accessors.TimeValueAccessor;
import manifold.sql.rt.impl.accessors.TimeWithTimeZoneValueAccessor;
import manifold.sql.rt.impl.accessors.TimestampValueAccessor;
import manifold.sql.rt.impl.accessors.TimestampWithTimeZoneValueAccessor;
import manifold.sql.rt.impl.accessors.TinyIntValueAccessor;
import manifold.sql.rt.impl.accessors.VarBinaryValueAccessor;
import manifold.sql.rt.impl.accessors.VarcharValueAccessor;
import manifold.util.concurrent.LocklessLazyVar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultValueAccessorProvider
implements ValueAccessorProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultValueAccessorProvider.class);
    private final LocklessLazyVar<Map<Integer, ValueAccessor>> _byJdbcType = LocklessLazyVar.make(() -> {
        LinkedHashMap<Integer, ValueAccessor> map = new LinkedHashMap<Integer, ValueAccessor>();
        for (Class<? extends ValueAccessor> accClass : this.getAll()) {
            try {
                ValueAccessor acc = accClass.newInstance();
                int jdbcType = acc.getJdbcType();
                map.put(jdbcType, acc);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return map;
    });

    public Class<? extends ValueAccessor>[] getAll() {
        return new Class[]{ArrayValueAccessor.class, BinaryValueAccessor.class, BitValueAccessor.class, BlobValueAccessor.class, BooleanValueAccessor.class, CharValueAccessor.class, ClobValueAccessor.class, DataLinkValueAccessor.class, DateValueAccessor.class, DecimalValueAccessor.class, DoubleValueAccessor.class, FloatValueAccessor.class, IntegerValueAccessor.class, JavaObjectValueAccessor.class, DistinctValueAccessor.class, LongNvarcharValueAccessor.class, BigIntValueAccessor.class, LongVarBinaryValueAccessor.class, LongVarcharValueAccessor.class, NcharValueAccessor.class, NclobValueAccessor.class, NumericValueAccessor.class, NvarcharValueAccessor.class, OtherValueAccessor.class, RealValueAccessor.class, RowIdValueAccessor.class, SmallIntValueAccessor.class, SqlXmlValueAccessor.class, TimestampValueAccessor.class, TimestampWithTimeZoneValueAccessor.class, TimeValueAccessor.class, TimeWithTimeZoneValueAccessor.class, TinyIntValueAccessor.class, VarBinaryValueAccessor.class, VarcharValueAccessor.class, Oracle_IntervalYmValueAccessor.class, Oracle_IntervalDsValueAccessor.class, Oracle_TimestampLtzValueAccessor.class, Oracle_TimestampTzValueAccessor.class};
    }

    @Override
    public ValueAccessor get(int jdbcType) {
        ValueAccessor valueAccessor = (ValueAccessor)((Map)this._byJdbcType.get()).get(jdbcType);
        if (valueAccessor == null) {
            LOGGER.warn("No direct ValueAccessor implementation found for JDBC type: " + jdbcType + ".\nUsing default '" + DistinctValueAccessor.class.getSimpleName() + "'.");
            valueAccessor = (ValueAccessor)((Map)this._byJdbcType.get()).get(2001);
        }
        return valueAccessor;
    }
}

