/*
 * Decompiled with CFR 0.152.
 */
package manifold.sql.rt.impl;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import manifold.rt.api.util.ManClassUtil;
import manifold.sql.rt.api.ConnectionProvider;
import manifold.sql.rt.api.CrudProvider;
import manifold.sql.rt.api.DbConfig;
import manifold.sql.rt.api.Dependencies;
import manifold.sql.rt.api.Entity;
import manifold.sql.rt.api.KeyRef;
import manifold.sql.rt.api.OperableTxBindings;
import manifold.sql.rt.api.OperableTxScope;
import manifold.sql.rt.api.SchemaType;
import manifold.sql.rt.api.TableInfo;
import manifold.sql.rt.api.TxScope;
import manifold.sql.rt.api.UpdateContext;
import manifold.util.concurrent.ConcurrentHashSet;

class BasicTxScope
implements OperableTxScope {
    private final DbConfig _dbConfig;
    private final Set<Entity> _rows;
    private final Set<Entity> _processedRows;
    private final ReentrantReadWriteLock _lock;
    private final List<TxScope.ScopeConsumer> _sqlChanges;
    private Connection _connection;

    public BasicTxScope(Class<? extends SchemaType> schemaClass) {
        this._dbConfig = Dependencies.instance().getDbConfigProvider().loadDbConfig(ManClassUtil.getShortClassName(schemaClass), schemaClass);
        this._rows = new LinkedHashSet<Entity>();
        this._processedRows = new ConcurrentHashSet();
        this._sqlChanges = new ArrayList<TxScope.ScopeConsumer>();
        this._lock = new ReentrantReadWriteLock();
    }

    @Override
    public DbConfig getDbConfig() {
        return this._dbConfig;
    }

    @Override
    public Set<Entity> getRows() {
        this._lock.readLock().lock();
        try {
            HashSet<Entity> hashSet = new HashSet<Entity>(this._rows);
            return hashSet;
        }
        finally {
            this._lock.readLock().unlock();
        }
    }

    @Override
    public void addRow(Entity item) {
        if (item == null) {
            throw new IllegalArgumentException("Item is null");
        }
        if (this._processedRows.remove(item)) {
            ((OperableTxBindings)item.getBindings()).reuse();
        }
        if (this.containsRow(item)) {
            return;
        }
        this._lock.writeLock().lock();
        try {
            this._rows.add(item);
        }
        finally {
            this._lock.writeLock().unlock();
        }
    }

    @Override
    public void removeRow(Entity item) {
        this._lock.writeLock().lock();
        try {
            this._rows.remove(item);
        }
        finally {
            this._lock.writeLock().unlock();
        }
    }

    @Override
    public boolean containsRow(Entity item) {
        this._lock.readLock().lock();
        try {
            boolean bl = this._rows.contains(item);
            return bl;
        }
        finally {
            this._lock.readLock().unlock();
        }
    }

    @Override
    public void addSqlChange(TxScope.ScopeConsumer change) {
        if (change == null) {
            throw new IllegalArgumentException("'change' is null");
        }
        this._lock.writeLock().lock();
        try {
            this._sqlChanges.add(change);
        }
        finally {
            this._lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit() throws SQLException {
        this._lock.writeLock().lock();
        try {
            if (this._rows.isEmpty() && this._sqlChanges.isEmpty()) {
                return;
            }
            TxScope.ScopeConsumer commitItem = this._rows.isEmpty() ? this._sqlChanges.get(0) : this._rows.stream().findFirst().get();
            ConnectionProvider cp = Dependencies.instance().getConnectionProvider();
            try (Connection c = cp.getConnection(this.getDbConfig().getName(), commitItem.getClass());){
                this._connection = c;
                try {
                    c.setAutoCommit(false);
                    HashSet<Entity> visited = new HashSet<Entity>();
                    for (Entity row : this._rows) {
                        this.doCrud(c, row, new LinkedHashMap<Entity, Set<FkDep>>(), visited);
                    }
                    for (TxScope.ScopeConsumer sqlChange : this._sqlChanges) {
                        this.executeSqlChange(c, sqlChange);
                    }
                    c.commit();
                    for (Entity row : this._rows) {
                        ((OperableTxBindings)row.getBindings()).commit();
                    }
                    this._rows.clear();
                    this._sqlChanges.clear();
                }
                catch (SQLException e) {
                    c.rollback();
                    for (Entity row : this._rows) {
                        ((OperableTxBindings)row.getBindings()).failedCommit();
                    }
                    throw e;
                }
                finally {
                    this._connection = null;
                }
            }
        }
        finally {
            this._lock.writeLock().unlock();
        }
    }

    @Override
    public void commit(TxScope.ScopeConsumer change) throws SQLException {
        this.addSqlChange(change);
        this.commit();
    }

    private void executeSqlChange(Connection c, TxScope.ScopeConsumer sqlChange) throws SQLException {
        sqlChange.accept(this.newSqlChangeCtx(c));
    }

    @Override
    public TxScope.SqlChangeCtx newSqlChangeCtx(final Connection c) {
        return new TxScope.SqlChangeCtx(){

            @Override
            public TxScope getTxScope() {
                return BasicTxScope.this;
            }

            @Override
            public Connection getConnection() {
                return c;
            }

            @Override
            public void doCrud() throws SQLException {
                HashSet visited = new HashSet();
                for (Entity row : BasicTxScope.this._rows) {
                    BasicTxScope.this.doCrud(c, row, new LinkedHashMap(), visited);
                }
            }
        };
    }

    @Override
    public void revert() throws SQLException {
        if (this._connection != null) {
            throw new SQLException("Revert is not supported within a transaction");
        }
        this._lock.writeLock().lock();
        try {
            for (Entity row : this._rows) {
                ((OperableTxBindings)row.getBindings()).revert();
            }
            this._rows.clear();
            this._sqlChanges.clear();
        }
        finally {
            this._lock.writeLock().unlock();
        }
    }

    private void doCrud(Connection c, Entity row, Map<Entity, Set<FkDep>> unresolvedDeps, Set<Entity> visited) throws SQLException {
        if (visited.contains(row)) {
            return;
        }
        visited.add(row);
        if (this._processedRows.contains(row)) {
            return;
        }
        this._processedRows.add(row);
        this.doFkDependenciesFirst(c, row, unresolvedDeps, visited);
        CrudProvider crud = Dependencies.instance().getCrudProvider();
        TableInfo ti = row.tableInfo();
        UpdateContext<Entity> ctx = new UpdateContext<Entity>(this, row, ti.getDdlTableName(), this._dbConfig.getName(), ti.getPkCols(), ti.getUkCols(), ti.getAllCols());
        if (row.getBindings().isForInsert()) {
            crud.create(c, ctx);
        } else if (row.getBindings().isForUpdate()) {
            crud.update(c, ctx);
        } else if (row.getBindings().isForDelete()) {
            crud.delete(c, ctx);
        } else {
            throw new SQLException("Unexpected bindings kind, neither of insert/update/delete");
        }
        this.patchUnresolvedFkDeps(c, ctx, crud, unresolvedDeps.get(row));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void patchUnresolvedFkDeps(Connection c, UpdateContext<Entity> ctx, CrudProvider crud, Set<FkDep> unresolvedDeps) throws SQLException {
        if (unresolvedDeps == null) {
            return;
        }
        for (FkDep dep : unresolvedDeps) {
            Object pkId = ((OperableTxBindings)dep.pkRow.getBindings()).getHeldValue(dep.pkName);
            if (pkId == null) {
                throw new SQLException("pk value is null");
            }
            OperableTxBindings fkBindings = (OperableTxBindings)dep.fkRow.getBindings();
            Object priorPkId = fkBindings.put(dep.fkName, pkId);
            try {
                crud.update(c, ctx);
            }
            finally {
                fkBindings.put(dep.fkName, priorPkId);
                fkBindings.holdValue(dep.fkName, pkId);
            }
        }
    }

    private void doFkDependenciesFirst(Connection c, Entity row, Map<Entity, Set<FkDep>> unresolvedDeps, Set<Entity> visited) throws SQLException {
        for (Map.Entry entry : row.getBindings().entrySet()) {
            Object value = entry.getValue();
            if (!(value instanceof KeyRef)) continue;
            KeyRef ref = (KeyRef)value;
            Entity pkEntity = ref.getRef();
            FkDep fkDep = new FkDep(row, (String)entry.getKey(), pkEntity, ref.getKeyColName());
            this.doCrud(c, pkEntity, unresolvedDeps, visited);
            Object pkId = ((OperableTxBindings)pkEntity.getBindings()).getHeldValue(fkDep.pkName);
            if (pkId != null) {
                ((OperableTxBindings)row.getBindings()).holdValue(fkDep.fkName, pkId);
                continue;
            }
            unresolvedDeps.computeIfAbsent(pkEntity, __ -> new LinkedHashSet()).add(fkDep);
        }
    }

    @Override
    public Connection getActiveConnection() {
        return this._connection;
    }

    private static class FkDep {
        final Entity fkRow;
        final String fkName;
        final Entity pkRow;
        final String pkName;

        public FkDep(Entity fkRow, String fkName, Entity pkRow, String pkName) {
            this.fkRow = fkRow;
            this.fkName = fkName;
            this.pkRow = pkRow;
            this.pkName = pkName;
        }
    }
}

