/*
 * Decompiled with CFR 0.152.
 */
package manifold.sql.rt.impl.accessors;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.OffsetDateTime;
import manifold.sql.rt.api.BaseElement;
import manifold.sql.rt.impl.accessors.OtherValueAccessor;
import manifold.util.ReflectUtil;

public class Oracle_TimestampTzValueAccessor
extends OtherValueAccessor {
    public static final int JDBC_TYPE_TIMESTAMPTZ = -101;
    private static final String ORACLE_SQL_TIMESTAMPTZ = "oracle.sql.TIMESTAMPTZ";

    @Override
    public int getJdbcType() {
        return -101;
    }

    @Override
    public Class<?> getJavaType(BaseElement elem) {
        return OffsetDateTime.class;
    }

    @Override
    public Object getRowValue(ResultSet rs, BaseElement elem) throws SQLException {
        Object value = super.getRowValue(rs, elem);
        if (value != null) {
            if (ORACLE_SQL_TIMESTAMPTZ.equals(value.getClass().getName())) {
                Connection c = rs.getStatement().getConnection();
                c = (Connection)c.unwrap(ReflectUtil.type((String)"oracle.jdbc.OracleConnection"));
                value = ReflectUtil.method((Object)value, (String)"offsetDateTimeValue", (Class[])new Class[]{Connection.class}).invoke(new Object[]{c});
            } else {
                throw new SQLException("Unexpected type: " + value.getClass().getTypeName());
            }
        }
        return value;
    }

    @Override
    public void setParameter(PreparedStatement ps, int pos, Object value) throws SQLException {
        if (value instanceof OffsetDateTime) {
            value = ReflectUtil.method((String)ORACLE_SQL_TIMESTAMPTZ, (String)"of", (Class[])new Class[]{OffsetDateTime.class}).invokeStatic(new Object[]{value});
        }
        super.setParameter(ps, pos, value);
    }
}

