/*
 * Decompiled with CFR 0.152.
 */
package manifold.sql.rt.api;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.function.Function;
import manifold.sql.rt.api.ConnectionProvider;
import manifold.sql.rt.api.Dependencies;
import manifold.sql.rt.api.OperableTxScope;
import manifold.sql.rt.api.QueryContext;
import manifold.sql.rt.api.Result;
import manifold.sql.rt.api.ResultRow;
import manifold.sql.rt.api.TxScope;
import manifold.sql.rt.api.ValueAccessor;
import manifold.sql.rt.api.ValueAccessorProvider;
import manifold.util.ManExceptionUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Runner<T extends ResultRow> {
    private final QueryContext<T> _ctx;
    private final String _sqlQuery;

    public Runner(QueryContext<T> ctx, String sqlQuery) {
        this._ctx = ctx;
        this._sqlQuery = sqlQuery;
    }

    public Result<T> fetch() {
        return this.runQueryWithConnection(c -> this.runQuery((Connection)c));
    }

    public T fetchOne() {
        return (T)this.runQueryWithConnection(c -> this.runQueryOne((Connection)c));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <RT> RT runQueryWithConnection(Function<Connection, RT> query) {
        OperableTxScope txScope = (OperableTxScope)this._ctx.getTxScope();
        Connection activeConnection = txScope.getActiveConnection();
        if (activeConnection != null) {
            try {
                TxScope.SqlChangeCtx ctx = txScope.newSqlChangeCtx(activeConnection);
                ctx.doCrud();
                return query.apply(activeConnection);
            }
            catch (Exception e) {
                throw ManExceptionUtil.unchecked((Throwable)e);
            }
        }
        ConnectionProvider cp = Dependencies.instance().getConnectionProvider();
        try (Connection c = cp.getConnection(this._ctx.getConfigName(), this._ctx.getQueryClass());){
            RT RT = query.apply(c);
            return RT;
        }
        catch (Exception e) {
            throw ManExceptionUtil.unchecked((Throwable)e);
        }
    }

    /*
     * Exception decompiling
     */
    @NotNull
    private Result<T> runQuery(Connection c) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Nullable
    private T runQueryOne(Connection c) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[TRYBLOCK]], but top level block is 6[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void setParameters(PreparedStatement ps) throws SQLException {
        int i = 0;
        ValueAccessorProvider accProvider = Dependencies.instance().getValueAccessorProvider();
        for (Object param : this._ctx.getParams().values()) {
            ValueAccessor accessor = accProvider.get(this._ctx.getParamInfo()[i].getJdbcType());
            accessor.setParameter(ps, ++i, param);
        }
    }
}

