/*
 * Decompiled with CFR 0.152.
 */
package manifold.sql.rt.api;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import manifold.rt.api.Bindings;
import manifold.sql.rt.api.ExecutionEnv;

public interface DbConfig {
    public static final String DEFAULT_SCHEMA_PKG = "sql.schema.types";

    public String getName();

    public String getCatalogName();

    public String getSchemaName();

    public String getPath();

    public String getUrl();

    public String getBuildUrl();

    public String getSchemaPackage();

    public String getUser();

    public String getPassword();

    public boolean isDefault();

    public Bindings getProperties();

    public String getDbDdl();

    public String getCustomBaseInterface();

    public String getCustomBaseClass();

    public boolean isInMemory();

    default public String getBuildUrlOtherwiseRuntimeUrl() {
        String buildUrl = this.getBuildUrl();
        return buildUrl == null || buildUrl.isEmpty() ? this.getUrl() : buildUrl;
    }

    default public Properties toProperties() {
        String password;
        String user;
        Properties props = new Properties();
        Bindings properties = this.getProperties();
        if (properties != null) {
            props.putAll((Map<?, ?>)properties);
        }
        if ((user = this.getUser()) != null) {
            props.put("username", user);
        }
        if ((password = this.getPassword()) != null) {
            props.put("password", password);
        }
        return props;
    }

    public void init(Connection var1, ExecutionEnv var2) throws SQLException;
}

