/*
 * Decompiled with CFR 0.152.
 */
package manifold.sql.rt.impl.accessors;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import manifold.sql.rt.api.BaseElement;
import manifold.sql.rt.api.ValueAccessor;

public class IntegerValueAccessor
implements ValueAccessor {
    @Override
    public int getJdbcType() {
        return 4;
    }

    @Override
    public Class<?> getJavaType(BaseElement elem) {
        return elem.canBeNull() ? Integer.class : Integer.TYPE;
    }

    @Override
    public Integer getRowValue(ResultSet rs, BaseElement elem) throws SQLException {
        int value = rs.getInt(elem.getPosition());
        return value == 0 && rs.wasNull() ? null : Integer.valueOf(value);
    }

    @Override
    public void setParameter(PreparedStatement ps, int pos, Object value) throws SQLException {
        if (value == null) {
            ps.setNull(pos, this.getJdbcType());
        } else if (value instanceof Number) {
            ps.setInt(pos, ((Number)value).intValue());
        } else {
            ps.setObject(pos, value, this.getJdbcType());
        }
    }
}

