/*
 * Decompiled with CFR 0.152.
 */
package manifold.sql.rt.impl.accessors;

import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import manifold.sql.rt.api.BaseElement;
import manifold.sql.rt.api.ColumnInfo;
import manifold.sql.rt.api.ValueAccessor;

public class DoubleValueAccessor
implements ValueAccessor {
    @Override
    public int getJdbcType() {
        return 8;
    }

    @Override
    public Class<?> getJavaType(BaseElement elem) {
        return elem.canBeNull() ? Double.class : Double.TYPE;
    }

    @Override
    public Double getRowValue(ResultSet rs, BaseElement elem) throws SQLException {
        double value = rs.getDouble(elem.getPosition());
        return value == 0.0 && rs.wasNull() ? null : Double.valueOf(value);
    }

    @Override
    public String getParameterExpression(DatabaseMetaData metaData, Object value, ColumnInfo ci) {
        if (ci.getSqlType().equalsIgnoreCase("money")) {
            return value == null ? "NULL" : "CAST('" + value + "' as money)";
        }
        return ValueAccessor.super.getParameterExpression(metaData, value, ci);
    }

    @Override
    public void setParameter(PreparedStatement ps, int pos, Object value) throws SQLException {
        if (value == null) {
            ps.setNull(pos, this.getJdbcType());
        } else if (value instanceof Number) {
            ps.setDouble(pos, ((Number)value).doubleValue());
        } else {
            ps.setObject(pos, value, this.getJdbcType());
        }
    }
}

