/*
 * Decompiled with CFR 0.152.
 */
package manifold.sql.rt.impl.accessors;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import manifold.sql.rt.api.BaseElement;
import manifold.sql.rt.api.ValueAccessor;

public class BooleanValueAccessor
implements ValueAccessor {
    @Override
    public int getJdbcType() {
        return 16;
    }

    @Override
    public Class<?> getJavaType(BaseElement elem) {
        return elem.canBeNull() ? Boolean.class : Boolean.TYPE;
    }

    @Override
    public Boolean getRowValue(ResultSet rs, BaseElement elem) throws SQLException {
        boolean value = rs.getBoolean(elem.getPosition());
        return !value && rs.wasNull() ? null : Boolean.valueOf(value);
    }

    @Override
    public void setParameter(PreparedStatement ps, int pos, Object value) throws SQLException {
        if (value == null) {
            ps.setNull(pos, this.getJdbcType());
        } else if (value instanceof Boolean) {
            ps.setBoolean(pos, (Boolean)value);
        } else {
            ps.setObject(pos, value, this.getJdbcType());
        }
    }
}

