/*
 * Decompiled with CFR 0.152.
 */
package manifold.sql.rt.util;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.function.Consumer;
import java.util.function.Function;
import manifold.api.fs.IFile;
import manifold.api.util.cache.FqnCache;
import manifold.rt.api.util.Pair;
import manifold.sql.rt.api.DbLocationProvider;
import manifold.sql.rt.api.Dependencies;
import manifold.sql.rt.api.ExecutionEnv;

public class PropertyExpressionProcessor {
    public static Result process(Function<String, FqnCache<IFile>> resByExt, String source, ExecutionEnv executionEnv, Function<String, String> exprHandler) {
        int end;
        if (source == null) {
            return null;
        }
        ArrayList<Consumer<Connection>> initializers = new ArrayList<Consumer<Connection>>();
        int start = source.indexOf("${");
        while (start >= 0 && (end = source.indexOf(125, start + 2)) > 0) {
            String expr = source.substring(start + 2, end).trim();
            Pair<String, Consumer<Connection>> value = PropertyExpressionProcessor.eval(resByExt, expr, executionEnv, exprHandler);
            if (value.getFirst() != null) {
                source = new StringBuilder(source).replace(start, end + 1, (String)value.getFirst()).toString();
                if (value.getSecond() != null) {
                    initializers.add((Consumer<Connection>)value.getSecond());
                }
            } else {
                throw new RuntimeException("Expression '" + expr + "' in url : '" + source + "' is not a valid system property or environment variable");
            }
            start = source.indexOf("${", start);
        }
        return new Result(source, initializers);
    }

    private static Pair<String, Consumer<Connection>> eval(Function<String, FqnCache<IFile>> resByExt, String expr, ExecutionEnv executionEnv, Function<String, String> exprHandler) {
        String value;
        Pair<String, Consumer<Connection>> result = PropertyExpressionProcessor.evalProvided(resByExt, expr, executionEnv);
        if (result != null) {
            return result;
        }
        String string = value = exprHandler == null ? null : exprHandler.apply(expr);
        if (value == null && (value = System.getProperty(expr)) == null) {
            value = System.getenv(expr);
        }
        value = PropertyExpressionProcessor.makeSureTempDirEndsWithSeparator(expr, value);
        return new Pair((Object)value, null);
    }

    private static String makeSureTempDirEndsWithSeparator(String expr, String value) {
        if (expr.equals("java.io.tmpdir") && value != null && !value.endsWith("/") && !value.endsWith("\\")) {
            value = value + "/";
        }
        return value;
    }

    private static Pair<String, Consumer<Connection>> evalProvided(Function<String, FqnCache<IFile>> resByExt, String expr, ExecutionEnv executionEnv) {
        Pair<Object, Consumer<Connection>> location;
        if (!expr.startsWith("#")) {
            return null;
        }
        int sp = expr.indexOf(32, 1);
        if (sp < 0) {
            return null;
        }
        String tag = expr.substring(1, sp);
        ArrayList<String> args = new ArrayList<String>();
        String rest = expr.substring(sp + 1).trim();
        StringTokenizer tokenizer = new StringTokenizer(rest, ",");
        while (tokenizer.hasMoreTokens()) {
            String arg = tokenizer.nextToken().trim();
            args.add(arg);
        }
        String[] argsArray = args.toArray(new String[0]);
        DbLocationProvider dbLocProvider = Dependencies.instance().getDbLocationProvider();
        if (dbLocProvider != null && (location = dbLocProvider.getLocation(resByExt, executionEnv, tag, argsArray)).getFirst() != DbLocationProvider.UNHANDLED) {
            return new Pair((Object)String.valueOf(location.getFirst()), location.getSecond());
        }
        return null;
    }

    public static class Result {
        public String url;
        public List<Consumer<Connection>> initializers;

        public Result(String url, List<Consumer<Connection>> initializers) {
            this.url = url;
            this.initializers = initializers;
        }
    }
}

