/*
 * Decompiled with CFR 0.152.
 */
package manifold.sql.rt.impl.accessors;

import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDate;
import java.time.Year;
import java.time.YearMonth;
import manifold.sql.rt.api.BaseElement;
import manifold.sql.rt.api.ValueAccessor;

public class DateValueAccessor
implements ValueAccessor {
    @Override
    public int getJdbcType() {
        return 91;
    }

    @Override
    public Class<?> getJavaType(BaseElement elem) {
        if (elem.getSqlType().equalsIgnoreCase("year")) {
            return Year.class;
        }
        if (elem.getSqlType().equalsIgnoreCase("yearmonth")) {
            return YearMonth.class;
        }
        return LocalDate.class;
    }

    @Override
    public Object getRowValue(ResultSet rs, BaseElement elem) throws SQLException {
        Date date = rs.getDate(elem.getPosition());
        if (date == null) {
            return null;
        }
        String sqlType = elem.getSqlType();
        if (sqlType.equalsIgnoreCase("year")) {
            return Year.of(date.toLocalDate().getYear());
        }
        if (sqlType.equalsIgnoreCase("yearmonth")) {
            LocalDate localDate = date.toLocalDate();
            return YearMonth.of(localDate.getYear(), localDate.getMonth());
        }
        return date.toLocalDate();
    }

    @Override
    public void setParameter(PreparedStatement ps, int pos, Object value) throws SQLException {
        if (value == null) {
            ps.setNull(pos, this.getJdbcType());
        } else if (value instanceof LocalDate) {
            ps.setDate(pos, Date.valueOf((LocalDate)value));
        } else if (value instanceof Year) {
            ps.setShort(pos, (short)((Year)value).getValue());
        } else if (value instanceof YearMonth) {
            ps.setDate(pos, Date.valueOf(((YearMonth)value).atDay(1)));
        } else {
            ps.setObject(pos, value, this.getJdbcType());
        }
    }
}

