/*
 * Decompiled with CFR 0.152.
 */
package manifold.sql.rt.impl.accessors;

import java.io.Reader;
import java.io.StringReader;
import java.sql.Clob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import manifold.sql.rt.api.BaseElement;
import manifold.sql.rt.api.ValueAccessor;

public class ClobValueAccessor
implements ValueAccessor {
    @Override
    public int getJdbcType() {
        return 2005;
    }

    @Override
    public Class<?> getJavaType(BaseElement elem) {
        return String.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getRowValue(ResultSet rs, BaseElement elem) throws SQLException {
        Object res = rs.getObject(elem.getPosition());
        if (res == null) {
            return null;
        }
        if (res instanceof String) {
            return (String)res;
        }
        if (res instanceof Clob) {
            Clob clob = (Clob)res;
            try {
                String string = clob.getSubString(1L, (int)clob.length());
                return string;
            }
            finally {
                clob.free();
            }
        }
        if (res instanceof char[]) {
            return String.valueOf((char[])res);
        }
        throw new SQLException("Expecting a clob or String, but found: " + res.getClass());
    }

    @Override
    public void setParameter(PreparedStatement ps, int pos, Object value) throws SQLException {
        if (value == null) {
            ps.setNull(pos, this.getJdbcType());
        } else if (value instanceof String) {
            String string = (String)value;
            StringReader reader = new StringReader(string);
            ps.setCharacterStream(pos, (Reader)reader, string.length());
        } else {
            ps.setObject(pos, value, this.getJdbcType());
        }
    }
}

